/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.NodeManager;
import com.alipay.sofa.jraft.core.NodeMetrics;
import com.alipay.sofa.jraft.util.FileOutputSignalHandler;
import com.alipay.sofa.jraft.util.MetricReporter;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMetricsSignalHandler
extends FileOutputSignalHandler {
    private static Logger LOG = LoggerFactory.getLogger(NodeMetricsSignalHandler.class);
    private static final String DIR = SystemPropertyUtil.get("jraft.signal.node.metrics.dir", "");
    private static final String BASE_NAME = "node_metrics.log";

    @Override
    public void handle(String signalName) {
        List<Node> nodes = NodeManager.getInstance().getAllNodes();
        if (nodes.isEmpty()) {
            return;
        }
        try {
            File file = this.getOutputFile(DIR, BASE_NAME);
            LOG.info("Printing raft nodes metrics with signal: {} to file: {}.", (Object)signalName, (Object)file);
            try (PrintStream out = new PrintStream(new FileOutputStream(file, true));){
                for (Node node : nodes) {
                    NodeMetrics nodeMetrics = node.getNodeMetrics();
                    MetricRegistry registry = nodeMetrics.getMetricRegistry();
                    if (registry == null) {
                        LOG.warn("Node: {} received a signal to print metric, but it does not have metric enabled.", (Object)node);
                        continue;
                    }
                    MetricReporter reporter = MetricReporter.forRegistry(registry).outputTo(out).prefixedWith("-- " + node.getNodeId()).build();
                    reporter.report();
                }
            }
        }
        catch (IOException e) {
            LOG.error("Fail to print nodes metrics: {}.", nodes, (Object)e);
        }
    }
}

