/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private AtomicInteger threadIndex;
    private final String threadNamePrefix;
    private boolean isDemoThread;

    public NamedThreadFactory(String threadNamePrefix, boolean isDemoThread) {
        this(new AtomicInteger(0), threadNamePrefix, isDemoThread);
    }

    public NamedThreadFactory(AtomicInteger threadIndex, String threadNamePrefix, boolean isDemoThread) {
        this.threadIndex = threadIndex;
        this.threadNamePrefix = threadNamePrefix;
        this.isDemoThread = isDemoThread;
    }

    public NamedThreadFactory(String threadNamePrefix) {
        this(threadNamePrefix, false);
    }

    @Override
    public Thread newThread(Runnable r) {
        StringBuilder threadName = new StringBuilder(this.threadNamePrefix);
        if (null != this.threadIndex) {
            threadName.append("-").append(this.threadIndex.incrementAndGet());
        }
        Thread thread = new Thread(r, threadName.toString());
        if (this.isDemoThread) {
            thread.setDaemon(true);
        }
        return thread;
    }
}

