/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.toolbox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletRequest;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.decoration.LayoutDecoration;
import org.apache.jetspeed.decoration.Theme;
import org.apache.jetspeed.request.RequestContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThemeBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ATTRIBUTE_THEMES = "jsThemes";
    private String name;
    private String title;
    private String image;
    private boolean selected = false;

    public ThemeBean(String name, String title, String image) {
        this.setName(name);
        this.setTitle(title);
        this.setImage(image);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public static void clearThemesSession(PortletRequest request) {
        request.getPortletSession().removeAttribute("jsThemes");
    }

    public static List<ThemeBean> retrieveThemes(PortletRequest request, DecorationFactory decorationFactory) {
        return ThemeBean.retrieveThemes((PortletRequest)request, (DecorationFactory)decorationFactory, null);
    }

    public static List<ThemeBean> retrieveThemes(PortletRequest request, DecorationFactory decorationFactory, String overrideTheme) {
        ArrayList<ThemeBean> themes = (ArrayList<ThemeBean>)request.getPortletSession().getAttribute("jsThemes");
        if (themes != null) {
            return themes;
        }
        themes = new ArrayList<ThemeBean>();
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Set decorators = decorationFactory.getPageDecorations(rc);
        for (String name : decorators) {
            String icon;
            LayoutDecoration decor = decorationFactory.getLayoutDecoration(name, rc);
            String compatibility = decor.getProperty("compatibility");
            if (compatibility == null || compatibility.compareTo("2.2.1") < 0) continue;
            ResourceBundle rb = decor.getResourceBundle(rc.getLocale(), rc);
            String title = null;
            try {
                title = rb.getString("title");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (title == null) {
                title = decor.getName();
            }
            if ((icon = decor.getProperty("icon")) == null) {
                icon = "";
            }
            ThemeBean theme = new ThemeBean(decor.getName(), title, icon);
            Theme pageTheme = (Theme)rc.getRequest().getAttribute("org.apache.jetspeed.theme");
            if (overrideTheme == null) {
                overrideTheme = pageTheme.getPageLayoutDecoration().getName();
            }
            if (overrideTheme.equals(decor.getName())) {
                theme.setSelected(true);
            }
            themes.add(theme);
        }
        request.getPortletSession().setAttribute("themes", themes);
        return themes;
    }

    public static String getDefaultTheme(PortletRequest request, DecorationFactory decorationFactory) {
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Set decorators = decorationFactory.getPageDecorations(rc);
        for (String name : decorators) {
            LayoutDecoration decor = decorationFactory.getLayoutDecoration(name, rc);
            String compatibility = decor.getProperty("compatibility");
            if (compatibility == null || compatibility.compareTo("2.2.1") < 0) continue;
            return decor.getName();
        }
        return "jetspeed";
    }
}

