/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.spaces;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.portalsite.Menu;
import org.apache.jetspeed.portalsite.MenuElement;
import org.apache.jetspeed.portalsite.MenuOption;
import org.apache.jetspeed.portalsite.PortalSiteRequestContext;
import org.apache.jetspeed.portlets.spaces.SiteBreadcrumbMenu;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.spaces.Spaces;
import org.apache.portals.bridges.common.GenericServletPortlet;

public class SiteBreadcrumbMenu
extends GenericServletPortlet {
    public static final String PORTAL_SITE_REQUEST_CONTEXT_ATTR_KEY = "org.apache.jetspeed.portalsite.PortalSiteRequestContext";
    private Spaces spacesService;
    private PortalAdministration admin;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.spacesService = (Spaces)context.getAttribute("cps:SpacesService");
        if (this.spacesService == null) {
            throw new PortletException("Could not get instance of portal spaces service component");
        }
        this.admin = (PortalAdministration)this.getPortletContext().getAttribute("cps:PortalAdministration");
        if (null == this.admin) {
            throw new PortletException("Failed to find the Portal Administration on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        LinkedList<BreadcrumbMenuItem> breadcrumbs = new LinkedList<BreadcrumbMenuItem>();
        try {
            List breadcrumbsMenuElements;
            Locale preferredLocale = rc.getLocale();
            PortalSiteRequestContext siteRequestContext = (PortalSiteRequestContext)rc.getAttribute(PORTAL_SITE_REQUEST_CONTEXT_ATTR_KEY);
            Menu breadcrumbsMenu = siteRequestContext.getMenu("breadcrumbs");
            if (breadcrumbsMenu != null && (breadcrumbsMenuElements = breadcrumbsMenu.getElements()) != null) {
                for (MenuElement breadcrumbMenuElement : breadcrumbsMenuElements) {
                    if (!(breadcrumbMenuElement instanceof MenuOption)) continue;
                    MenuOption breadcrumbMenuOption = (MenuOption)breadcrumbMenuElement;
                    String title = breadcrumbMenuOption.getTitle(preferredLocale);
                    String url = this.admin.getPortalURL((PortletRequest)request, (PortletResponse)response, breadcrumbMenuOption.getUrl());
                    breadcrumbs.add(new BreadcrumbMenuItem(this, title, url));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("breadcrumbs", breadcrumbs);
        try {
            super.doView(request, response);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

