/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.site;

import java.io.Serializable;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.portlets.site.SiteTreeNode;

public class SiteTreeNode
implements Serializable {
    private static final long serialVersionUID = 2349948500132928089L;
    private String nodeName;
    private String nodePath;
    private boolean hasChildern;
    private boolean loaded;
    private FileType docType;

    public SiteTreeNode(Folder folder, boolean loaded) {
        this.nodeName = folder.getName();
        this.nodePath = folder.getPath();
        this.docType = FileType.Folder;
        this.loaded = loaded;
    }

    public SiteTreeNode(Folder folder) {
        this.nodeName = folder.getName();
        this.nodePath = folder.getPath();
        this.docType = FileType.Folder;
    }

    public SiteTreeNode(Page page) {
        this.nodeName = page.getName();
        this.nodePath = page.getPath();
        this.docType = FileType.Page;
    }

    public SiteTreeNode(Link link) {
        this.nodeName = link.getName();
        this.nodePath = link.getPath();
        this.docType = FileType.Link;
    }

    public SiteTreeNode(String name, String path, FileType type) {
        this.nodeName = name;
        this.nodePath = path;
        this.docType = type;
    }

    public SiteTreeNode(String name, String path, FileType type, boolean loaded) {
        this.nodeName = name;
        this.nodePath = path;
        this.docType = type;
        this.loaded = loaded;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public boolean isHasChildern() {
        return this.hasChildern;
    }

    public void setHasChildern(boolean hasChildern) {
        this.hasChildern = hasChildern;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public String toString() {
        return this.nodeName != null ? this.nodeName : super.toString();
    }

    public FileType getDocType() {
        return this.docType;
    }

    public void setDocType(FileType docType) {
        this.docType = docType;
    }
}

