/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.site;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.portlet.PortletRequest;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.page.FolderNotRemovedException;
import org.apache.jetspeed.page.FolderNotUpdatedException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.UnsupportedDocumentTypeException;
import org.apache.jetspeed.portlets.AdminPortletWebPage;
import org.apache.jetspeed.portlets.site.JetspeedDocument;
import org.apache.jetspeed.portlets.site.JetspeedDocumentMetaData;
import org.apache.jetspeed.portlets.site.MenuTreeNode;
import org.apache.jetspeed.portlets.site.PortalSiteManager;
import org.apache.jetspeed.portlets.site.PortalSiteManagerUtil;
import org.apache.jetspeed.portlets.site.SiteTreeNode;
import org.apache.jetspeed.portlets.site.model.ExcludesDefinitionBean;
import org.apache.jetspeed.portlets.site.model.IncludesDefinitionBean;
import org.apache.jetspeed.portlets.site.model.JetspeedMenuDefinition;
import org.apache.jetspeed.portlets.site.model.OptionsDefinitionBean;
import org.apache.jetspeed.portlets.site.model.SeparatorDefinitionBean;
import org.apache.jetspeed.portlets.wicket.AbstractAdminWebApplication;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.tree.LinkTree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalSiteManager
extends AdminPortletWebPage {
    public static final String PORTAL_SITE_MANAGER_INIT_NODE_TYPE_PARAM = "_jssmnodetype";
    public static final String PORTAL_SITE_MANAGER_INIT_NODE_PATH_PARAM = "_jssmnodepath";
    protected static final Logger log = LoggerFactory.getLogger(PortalSiteManager.class);
    protected PortletRegistry registry;
    protected DecorationFactory decorationFactory;
    public static final String TREE_ROOT = "jsRoot";
    private static final String JETSPEED_PATH_SEPRATOR = "/";
    private DefaultTreeModel treeModel;
    private AjaxTabbedPanel tabPanel;
    private DefaultTreeModel treeRoot;
    private JetspeedDocument document;
    private MenuDefinition menuDefinition;
    private List<String> pageDecorators;
    private List<String> portletDecorators;
    private List<String> pageThemes;
    private List<String> constraintsDefs;
    private List<String> targetList;
    private static final String ADD_ACTION = "add";
    private static final String REMOVE_ACTION = "remove";
    private static final String SAVE_ACTION = "save";
    private static final String INCLUDES = "includes";
    private static final String EXCLUDES = "excludes";
    public static final String FOLDER_NODE_TYPE = "folder";
    public static final String PAGE_NODE_TYPE = "page";
    public static final String LINK_NODE_TYPE = "link";
    List<ITab> menuTabs = new ArrayList();
    private List menuOptions = new ArrayList();
    String userFolder;
    private DefaultTreeModel menuTreeRoot;
    private LinkTree menuTree;

    public PortalSiteManager() {
        ArrayList tabList = new ArrayList();
        DefaultMutableTreeNode rootNode = this.populateTree();
        this.populateDocument(this.getInitSiteTreeNode());
        PortalTree siteTree = new PortalTree(this, "siteTree", (IModel)new PropertyModel((Object)this, "treeRoot"));
        siteTree.getTreeState().expandNode((Object)rootNode);
        this.tabPanel = new AjaxTabbedPanel("tabs", tabList);
        this.tabPanel.setOutputMarkupId(true);
        this.add(new Component[]{siteTree});
        Form treeForm = new Form("treeForm");
        treeForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */.setRequired(true)});
        treeForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        treeForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new FeedbackPanel("feedback")});
        this.add(new Component[]{treeForm});
        this.add(new Component[]{this.tabPanel});
        this.controlTabs();
        this.setVisibilitiesOfChildComponentsByPreferences("component.visibility.", true);
    }

    protected void controlTabs() {
        SiteTreeNode node = this.getUserSelectedNode();
        this.controlTabs(node);
    }

    protected void controlTabs(SiteTreeNode node) {
        TabbedPanel tabs = (TabbedPanel)this.get("tabs");
        tabs.getTabs().clear();
        4 tempTab = new /* Unavailable Anonymous Inner Class!! */;
        tabs.getTabs().add(tempTab);
        tempTab = new /* Unavailable Anonymous Inner Class!! */;
        tabs.getTabs().add(tempTab);
        tempTab = new /* Unavailable Anonymous Inner Class!! */;
        tabs.getTabs().add(tempTab);
        if (node.getDocType().equals((Object)SiteTreeNode.FileType.Folder)) {
            tempTab = new /* Unavailable Anonymous Inner Class!! */;
            tabs.getTabs().add(tempTab);
        }
        if (node.getDocType().equals((Object)SiteTreeNode.FileType.Folder) || node.getDocType().equals((Object)SiteTreeNode.FileType.Page)) {
            tempTab = new /* Unavailable Anonymous Inner Class!! */;
            tabs.getTabs().add(tempTab);
        }
        tempTab = new /* Unavailable Anonymous Inner Class!! */;
        tabs.getTabs().add(tempTab);
        tabs.setSelectedTab(0);
    }

    protected void insertMetadata(JetspeedDocumentMetaData metaData, Node node) {
        Locale locale = new Locale(metaData.getLanguage());
        node.getMetadata().addField(locale, metaData.getName(), metaData.getValue());
    }

    protected void updateMetadata(JetspeedDocumentMetaData metaData, JetspeedDocumentMetaData oldMetaData, Node node) {
        Collection cfields = node.getMetadata().getFields(oldMetaData.getName());
        if (cfields == null || cfields.size() == 0) {
            this.insertMetadata(metaData, node);
            return;
        }
        boolean found = false;
        for (LocalizedField field : cfields) {
            if (!this.areFieldsSame(field.getName(), oldMetaData.getName()) || !this.areFieldsSame(field.getLocale().toString(), oldMetaData.getLanguage())) continue;
            field.setName(metaData.getName());
            field.setLocale(new Locale(metaData.getLanguage()));
            field.setValue(metaData.getValue());
            found = true;
            break;
        }
        if (!found) {
            this.insertMetadata(metaData, node);
        }
    }

    protected void removeMetadata(JetspeedDocumentMetaData metaData, Node node) {
        Collection cfields = node.getMetadata().getFields(metaData.getName());
        Collection allFields = node.getMetadata().getFields();
        if (cfields == null || cfields.size() == 0) {
            return;
        }
        boolean found = false;
        for (LocalizedField field : cfields) {
            if (!this.areFieldsSame(field.getName(), metaData.getName()) || !this.areFieldsSame(field.getLocale().toString(), metaData.getLanguage())) continue;
            cfields.remove(field);
            if (allFields.remove(field)) {
                node.getMetadata().setFields(allFields);
            }
            found = true;
            break;
        }
    }

    protected boolean isBlank(String field) {
        return field == null || field.trim().length() == 0;
    }

    protected boolean isFieldModified(String paramValue, String prevValue) {
        if (paramValue == null) {
            return prevValue != null;
        }
        if (prevValue == null) {
            return true;
        }
        return !prevValue.equals(paramValue);
    }

    protected boolean areFieldsSame(String f1, String f2) {
        return !this.isFieldModified(f1, f2);
    }

    protected boolean isBooleanModified(String paramValue, boolean prevValue) {
        if (paramValue == null) {
            return prevValue;
        }
        return !prevValue;
    }

    protected void insertSecurityReference(String name, String kind, Node node) {
        if (node.getSecurityConstraints() == null) {
            SecurityConstraints cons = node.newSecurityConstraints();
            node.setSecurityConstraints(cons);
        }
        if (kind.equals("Owner")) {
            node.getSecurityConstraints().setOwner(name);
        } else {
            List refs = node.getSecurityConstraints().getSecurityConstraintsRefs();
            if (refs.contains(name)) {
                return;
            }
            refs.add(name);
        }
    }

    protected void updateSecurityReference(String name, String oldName, String kind, Node node) {
        List refs;
        if (node.getSecurityConstraints() == null) {
            SecurityConstraints cons = node.newSecurityConstraints();
            node.setSecurityConstraints(cons);
        }
        if ((refs = node.getSecurityConstraints().getSecurityConstraintsRefs()) == null || refs.size() == 0) {
            this.insertSecurityReference(name, kind, node);
        }
        boolean found = false;
        if (kind.equals("Owner")) {
            node.getSecurityConstraints().setOwner(name);
            found = true;
        } else {
            for (int ix = 0; ix < refs.size(); ++ix) {
                String ref = (String)refs.get(ix);
                if (!this.areFieldsSame(ref, oldName)) continue;
                refs.set(ix, name);
                found = true;
                break;
            }
        }
        if (!found) {
            this.insertSecurityReference(name, kind, node);
        }
    }

    protected void removeSecurityReference(String name, Node node) {
        if (node.getSecurityConstraints() != null) {
            String kind = "";
            if (kind.equals("Owner")) {
                node.getSecurityConstraints().setOwner(null);
            } else {
                List refs = node.getSecurityConstraints().getSecurityConstraintsRefs();
                if (!refs.contains(name)) {
                    return;
                }
                refs.remove(name);
            }
        }
    }

    protected String getUserFolder() {
        return this.userFolder;
    }

    protected void setUserFolder(String userFolder) {
        this.userFolder = userFolder;
    }

    protected String determineRootFolder() {
        PortletRequest request = ((AbstractAdminWebApplication)this.getApplication()).getPortletRequest();
        String jsroot = request.getParameter(TREE_ROOT);
        if (StringUtils.isEmpty((String)jsroot)) {
            jsroot = request.getPreferences().getValue(TREE_ROOT, JETSPEED_PATH_SEPRATOR);
        }
        return jsroot;
    }

    private void securityConstraintAction(String action, String constraint, String oldConstraintName) {
        SiteTreeNode node = this.getUserSelectedNode();
        Folder jetspeedNode = null;
        PageManager pageManager = this.getServiceLocator().getPageManager();
        if (node.getDocType() == SiteTreeNode.FileType.Folder) {
            jetspeedNode = this.getJetspeedFolder(node.getNodePath());
            if (action.equals(ADD_ACTION) || action.equals(SAVE_ACTION)) {
                this.updateSecurityReference(constraint, oldConstraintName, "", (Node)jetspeedNode);
            } else if (action.equals(REMOVE_ACTION)) {
                this.removeSecurityReference(constraint, (Node)jetspeedNode);
            }
            this.folderAction(jetspeedNode, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
            jetspeedNode = this.getJetspeedPage(node.getNodePath());
            if (action.equals(ADD_ACTION) || action.equals(SAVE_ACTION)) {
                this.updateSecurityReference(constraint, oldConstraintName, "", (Node)jetspeedNode);
            } else if (action.equals(REMOVE_ACTION)) {
                this.removeSecurityReference(constraint, (Node)jetspeedNode);
            }
            this.PageAction((Page)jetspeedNode, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Link) {
            jetspeedNode = this.getJetspeedLink(node.getNodePath());
            if (action.equals(ADD_ACTION) || action.equals(SAVE_ACTION)) {
                this.updateSecurityReference(constraint, oldConstraintName, "", (Node)jetspeedNode);
            } else if (action.equals(REMOVE_ACTION)) {
                this.removeSecurityReference(constraint, (Node)jetspeedNode);
            }
            this.linkAction((Link)jetspeedNode, SAVE_ACTION);
        }
        this.populateDocument(node);
    }

    private void metaDataAction(String action, JetspeedDocumentMetaData metaData, JetspeedDocumentMetaData oldMetaData) {
        SiteTreeNode node = this.getUserSelectedNode();
        Folder jetspeedNode = null;
        PageManager pageManager = this.getServiceLocator().getPageManager();
        if (node.getDocType() == SiteTreeNode.FileType.Folder) {
            jetspeedNode = this.getJetspeedFolder(node.getNodePath());
            if (action.equals(ADD_ACTION) || action.equals(SAVE_ACTION)) {
                this.updateMetadata(metaData, oldMetaData, (Node)jetspeedNode);
            } else if (action.equals(REMOVE_ACTION)) {
                this.removeMetadata(metaData, (Node)jetspeedNode);
            }
            this.folderAction(jetspeedNode, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
            jetspeedNode = this.getJetspeedPage(node.getNodePath());
            if (action.equals(ADD_ACTION) || action.equals(SAVE_ACTION)) {
                this.updateMetadata(metaData, oldMetaData, (Node)jetspeedNode);
            } else if (action.equals(REMOVE_ACTION)) {
                this.removeMetadata(metaData, (Node)jetspeedNode);
            }
            this.PageAction((Page)jetspeedNode, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Link) {
            jetspeedNode = this.getJetspeedLink(node.getNodePath());
            if (action.equals(ADD_ACTION) || action.equals(SAVE_ACTION)) {
                this.updateMetadata(metaData, oldMetaData, (Node)jetspeedNode);
            } else if (action.equals(REMOVE_ACTION)) {
                this.removeMetadata(metaData, (Node)jetspeedNode);
            }
            this.linkAction((Link)jetspeedNode, SAVE_ACTION);
        }
        this.populateDocument(node);
    }

    private DefaultMutableTreeNode populateUserTree(String userName) {
        DefaultMutableTreeNode rootNode = null;
        rootNode = this.retrieveFolders("/_user/" + userName, rootNode);
        this.treeRoot = new DefaultTreeModel(rootNode);
        return rootNode;
    }

    private DefaultMutableTreeNode populateTree() {
        DefaultMutableTreeNode rootNode = null;
        rootNode = this.retrieveFolders(this.determineRootFolder(), rootNode);
        this.treeRoot = new DefaultTreeModel(rootNode);
        return rootNode;
    }

    private DefaultMutableTreeNode populateCopyTree() {
        DefaultMutableTreeNode rootNode = null;
        rootNode = this.retrieveCopyFolders(JETSPEED_PATH_SEPRATOR, rootNode);
        this.treeRoot = new DefaultTreeModel(rootNode);
        return rootNode;
    }

    private DefaultMutableTreeNode retrieveFolders(String folderPath, DefaultMutableTreeNode rootNode) {
        return this.retrieveFolders(folderPath, rootNode, true);
    }

    private DefaultMutableTreeNode retrieveFolders(String folderPath, DefaultMutableTreeNode rootNode, boolean cleanBeforeRetrieve) {
        try {
            DefaultMutableTreeNode tmpNode;
            Folder rootfolder = this.getServiceLocator().getPageManager().getFolder(folderPath);
            if (rootNode == null) {
                rootNode = new DefaultMutableTreeNode(new SiteTreeNode(rootfolder, true));
            }
            if (cleanBeforeRetrieve) {
                rootNode.removeAllChildren();
            }
            for (Folder folder : rootfolder.getFolders()) {
                if (rootfolder.getPath().equals("/_user")) {
                    if (!folder.getName().startsWith("template")) continue;
                    rootNode.add(new DefaultMutableTreeNode(new SiteTreeNode(folder)));
                    continue;
                }
                rootNode.add(new DefaultMutableTreeNode(new SiteTreeNode(folder)));
            }
            for (Page page : rootfolder.getPages()) {
                tmpNode = new DefaultMutableTreeNode(new SiteTreeNode(page));
                tmpNode.setAllowsChildren(false);
                rootNode.add(tmpNode);
            }
            for (Link link : rootfolder.getLinks()) {
                tmpNode = new DefaultMutableTreeNode(new SiteTreeNode(link));
                tmpNode.setAllowsChildren(false);
                rootNode.add(tmpNode);
            }
        }
        catch (Exception e) {
            log.error("Failed to retrieve folders ", (Throwable)e);
        }
        return rootNode;
    }

    private DefaultMutableTreeNode retrieveCopyFolders(String folderPath, DefaultMutableTreeNode rootNode) {
        try {
            Folder rootfolder = this.getServiceLocator().getPageManager().getFolder(folderPath);
            if (rootNode == null) {
                rootNode = new DefaultMutableTreeNode(new SiteTreeNode(rootfolder, true));
            }
            for (Folder folder : rootfolder.getFolders()) {
                if (rootfolder.getPath().equals("/_user")) {
                    if (!folder.getName().startsWith("template")) continue;
                    rootNode.add(new DefaultMutableTreeNode(new SiteTreeNode(folder)));
                    continue;
                }
                rootNode.add(new DefaultMutableTreeNode(new SiteTreeNode(folder)));
            }
        }
        catch (Exception e) {
            log.error("Failed to retrieve folders ", (Throwable)e);
        }
        return rootNode;
    }

    private List<String> getPortletDecorators() {
        if (this.portletDecorators == null) {
            this.portletDecorators = new ArrayList(this.getServiceLocator().getDecorationFactory().getPortletDecorations(null));
        }
        return this.portletDecorators;
    }

    private List<String> getPageDecorators() {
        if (this.pageDecorators == null) {
            this.pageDecorators = new ArrayList(this.getServiceLocator().getDecorationFactory().getPageDecorations(null));
        }
        return this.pageDecorators;
    }

    private List<String> getThemes() {
        if (this.pageThemes == null) {
            this.pageThemes = new ArrayList(this.getServiceLocator().getDecorationFactory().getDesktopPageDecorations(null));
        }
        return this.pageThemes;
    }

    private List<String> getTargetList() {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
            this.targetList.add("new");
            this.targetList.add("self");
            this.targetList.add("top");
            this.targetList.add("parent");
        }
        return this.targetList;
    }

    private List<String> getConstraintsDef() {
        if (this.constraintsDefs == null) {
            this.constraintsDefs = new ArrayList();
            try {
                Iterator constraintsDefIterator = this.getServiceLocator().getPageManager().getPageSecurity().getSecurityConstraintsDefs().iterator();
                while (constraintsDefIterator.hasNext()) {
                    this.constraintsDefs.add(((SecurityConstraintsDef)constraintsDefIterator.next()).getName());
                }
            }
            catch (UnsupportedDocumentTypeException e) {
                log.error("Unsupported document type.", (Throwable)e);
            }
            catch (DocumentNotFoundException e) {
                log.error("Document is not found.", (Throwable)e);
            }
            catch (NodeException e) {
                log.error("Unexpected exception.", (Throwable)e);
            }
        }
        return this.constraintsDefs;
    }

    private void populateDocument(SiteTreeNode node) {
        try {
            if (node.getDocType() == SiteTreeNode.FileType.Folder) {
                this.document = new JetspeedDocument(this.getServiceLocator().getPageManager().getFolder(node.getNodePath()));
            } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
                this.document = new JetspeedDocument(this.getServiceLocator().getPageManager().getPage(node.getNodePath()));
            } else if (node.getDocType() == SiteTreeNode.FileType.Link) {
                this.document = new JetspeedDocument(this.getServiceLocator().getPageManager().getLink(node.getNodePath()));
            }
        }
        catch (Exception e) {
            log.error("Failed populate document.", (Throwable)e);
        }
    }

    private void metaOrderAction(JetspeedDocument document, String choices) {
        SiteTreeNode node = this.getUserSelectedNode();
        PageManager pageManger = this.getServiceLocator().getPageManager();
        List<String> documentOrder = null;
        if (node != null) {
            if (choices != null) {
                documentOrder = Arrays.asList(choices.split(","));
            }
            if (node.getDocType() == SiteTreeNode.FileType.Folder) {
                Folder folder = this.getJetspeedFolder(node.getNodePath());
                folder.setDocumentOrder(documentOrder);
                this.folderAction(folder, SAVE_ACTION);
            }
        }
    }

    private void excuteAction(JetspeedDocument document, String action) {
        SiteTreeNode node = this.getUserSelectedNode();
        PageManager pageManger = this.getServiceLocator().getPageManager();
        if (node != null) {
            if (node.getDocType() == SiteTreeNode.FileType.Folder) {
                Folder folder = this.getJetspeedFolder(node.getNodePath());
                if (action.equals(SAVE_ACTION)) {
                    folder.setTitle(document.getTitle());
                    folder.setShortTitle(document.getShortTitle());
                    folder.setDefaultPage(document.getPage());
                    folder.setDefaultDecorator(document.getPageDecorator(), "layout");
                    folder.setDefaultDecorator(document.getPortletDecorator(), "portlet");
                    folder.setSkin(document.getDesktopTheme());
                    folder.setHidden(document.isHidden());
                    this.folderAction(folder, SAVE_ACTION);
                } else if (action.equals(REMOVE_ACTION)) {
                    this.folderAction(folder, REMOVE_ACTION);
                }
            } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
                Page page = this.getJetspeedPage(node.getNodePath());
                if (action.equals(SAVE_ACTION)) {
                    page.setTitle(document.getTitle());
                    page.setShortTitle(document.getShortTitle());
                    page.setDefaultDecorator(document.getPageDecorator(), "layout");
                    page.setDefaultDecorator(document.getPortletDecorator(), "portlet");
                    page.setSkin(document.getDesktopTheme());
                    page.setHidden(document.isHidden());
                    this.PageAction(page, SAVE_ACTION);
                } else if (action.equals(REMOVE_ACTION)) {
                    this.PageAction(page, REMOVE_ACTION);
                }
            } else if (node.getDocType() == SiteTreeNode.FileType.Link) {
                Link link = this.getJetspeedLink(node.getNodePath());
                if (action.equals(SAVE_ACTION)) {
                    link.setTitle(document.getTitle());
                    link.setShortTitle(document.getShortTitle());
                    link.setUrl(document.getUrl());
                    link.setTitle(document.getTitle());
                    link.setHidden(document.isHidden());
                    this.linkAction(link, SAVE_ACTION);
                } else if (action.equals(REMOVE_ACTION)) {
                    this.linkAction(link, REMOVE_ACTION);
                }
            }
        }
    }

    private String fileExt(String fileName) {
        int extIndex = fileName.lastIndexOf(".");
        if (extIndex > 0) {
            return fileName.substring(extIndex + 1, fileName.length());
        }
        return "";
    }

    private ExportObject exportJetspeedtObject(SiteTreeNode siteNode, boolean recursive, String userName) {
        String downloadPath = "";
        String contentType = "text/xml";
        boolean success = true;
        ExportObject jetspeedObject = null;
        String objectPath = siteNode.getNodePath();
        if (!this.cleanUserFolder(userName)) {
            success = false;
        }
        if (success) {
            PageManager pageManager = this.getServiceLocator().getPageManager();
            PageManager castorPageManager = this.getServiceLocator().getCastorPageManager();
            try {
                Folder folder;
                if (siteNode.getDocType() == SiteTreeNode.FileType.Folder) {
                    folder = pageManager.getFolder(siteNode.getNodePath());
                    if (recursive) {
                        PortalSiteManagerUtil.importFolder((PageManager)castorPageManager, (Folder)folder, (String)userName, (String)this.getRealPath(folder.getPath()), (boolean)true);
                    } else {
                        Folder destFolder = castorPageManager.copyFolder(folder, PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + siteNode.getNodeName());
                        castorPageManager.updateFolder(destFolder);
                    }
                } else if (siteNode.getDocType() == SiteTreeNode.FileType.Page) {
                    objectPath = PortalSiteManagerUtil.getParentPath((String)objectPath);
                    folder = pageManager.getFolder(objectPath);
                    Page page = folder.getPage(siteNode.getNodeName());
                    Page destPage = castorPageManager.copyPage(page, PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + siteNode.getNodeName(), true);
                    castorPageManager.updatePage(destPage);
                } else if (siteNode.getDocType() == SiteTreeNode.FileType.Link) {
                    objectPath = PortalSiteManagerUtil.getParentPath((String)objectPath);
                    folder = pageManager.getFolder(objectPath);
                    Link link = folder.getLink(siteNode.getNodeName());
                    Link destLink = castorPageManager.copyLink(link, PortalSiteManagerUtil.getUserFolder((String)userName, (boolean)true) + siteNode.getNodeName());
                    castorPageManager.updateLink(destLink);
                }
                String link = userName + "_" + siteNode.getNodeName();
                if (siteNode.getDocType() == SiteTreeNode.FileType.Folder) {
                    contentType = "application/zip";
                    link = userName + ".zip";
                }
                downloadPath = PortalSiteManagerUtil.getDownloadLink((String)siteNode.getNodeName(), (String)userName, (String)siteNode.getDocType().toString());
                jetspeedObject = new ExportObject(this, downloadPath, contentType);
            }
            catch (Exception e) {
                log.error("Failed to export site node.", (Throwable)e);
            }
        }
        return jetspeedObject;
    }

    private String getTempFolder(String userName) {
        String dir = System.getProperty("java.io.tmpdir");
        String path = System.getProperty("file.separator");
        File file = new File(dir + path + userName);
        file.mkdir();
        return dir + path + userName;
    }

    private static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unzipfile(String file, String destination, String sepreator) {
        String filePath = "";
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(destination + sepreator + file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                filePath = destination + sepreator + entry.getName();
                this.createPath(filePath);
                InputStream input = null;
                FileOutputStream output = null;
                try {
                    input = zipFile.getInputStream(entry);
                    output = new FileOutputStream(filePath);
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    IOUtils.closeQuietly((InputStream)input);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)output);
                IOUtils.closeQuietly((InputStream)input);
            }
            boolean entry = true;
            return entry;
        }
        catch (IOException ioe) {
            log.error("Unexpected IO exception.", (Throwable)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private void createPath(String filePath) {
        String parentPath = "";
        File file = new File(filePath);
        File parent = new File(file.getParent());
        if (!parent.exists()) {
            parentPath = parent.getPath();
            this.createPath(parentPath);
            parent.mkdir();
        }
    }

    private Folder importFolders(PageManager pageManager, PageManager castorPageManager, Folder srcFolder, String userName, String destination, boolean copyIds) throws JetspeedException {
        Folder dstFolder = this.lookupFolder(castorPageManager, srcFolder.getPath());
        dstFolder = pageManager.copyFolder(srcFolder, destination);
        pageManager.updateFolder(dstFolder);
        String newPath = "";
        for (Page srcPage : srcFolder.getPages()) {
            Page dstPage = this.lookupPage(castorPageManager, srcPage.getPath());
            newPath = destination + this.getRealPath(srcPage.getPath());
            dstPage = pageManager.copyPage(srcPage, newPath, copyIds);
            pageManager.updatePage(dstPage);
        }
        for (Link srcLink : srcFolder.getLinks()) {
            Link dstLink = this.lookupLink(castorPageManager, srcLink.getPath());
            newPath = destination + this.getRealPath(srcLink.getPath());
            dstLink = pageManager.copyLink(srcLink, newPath);
            pageManager.updateLink(dstLink);
        }
        for (Folder folder : srcFolder.getFolders()) {
            newPath = destination + this.getRealPath(folder.getPath());
            this.importFolders(pageManager, castorPageManager, folder, userName, newPath, copyIds);
        }
        return dstFolder;
    }

    private Page lookupPage(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getPage(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Link lookupLink(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getLink(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Folder lookupFolder(PageManager castorPageManager, String path) {
        try {
            return castorPageManager.getFolder(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getRealPath(String path) {
        int index = path.lastIndexOf(JETSPEED_PATH_SEPRATOR);
        if (index > 0) {
            return path.substring(index);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanUserFolder(String userName) {
        boolean success = false;
        PortalSiteManager portalSiteManager = this;
        synchronized (portalSiteManager) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            String path = System.getProperty("file.separator");
            String folder = tmpdir + path + userName;
            File dir = new File(folder);
            if (dir.exists()) {
                success = this.deleteDir(dir);
            }
            success = dir.mkdir();
        }
        return success;
    }

    private boolean deleteDir(File dir) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return dir.delete();
    }

    private void setFolderTreeNodeLoadedByPath(Node node, boolean loaded) {
        DefaultMutableTreeNode destParentTreeNode = this.getTreeNodeByPath(node.getPath());
        SiteTreeNode siteTreeNode = (SiteTreeNode)destParentTreeNode.getUserObject();
        siteTreeNode.setLoaded(loaded);
    }

    private DefaultMutableTreeNode getTreeNodeByPath(String path) {
        PortalTree tree = (PortalTree)this.getPage().get("siteTree");
        TreeModel treeModel = tree.getModelObject();
        ArrayList treeNodeList = new ArrayList();
        this.findTreeNodeByPath((DefaultMutableTreeNode)treeModel.getRoot(), path, treeNodeList, 1);
        return treeNodeList.isEmpty() ? null : (DefaultMutableTreeNode)treeNodeList.get(0);
    }

    private void findTreeNodeByPath(DefaultMutableTreeNode node, String path, List<DefaultMutableTreeNode> treeNodeList, int maxSize) {
        SiteTreeNode siteTreeNode = (SiteTreeNode)node.getUserObject();
        if (siteTreeNode != null && path.equals(siteTreeNode.getNodePath())) {
            treeNodeList.add(node);
        }
        if (treeNodeList.size() >= maxSize) {
            return;
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            this.findTreeNodeByPath(child, path, treeNodeList, maxSize);
            if (treeNodeList.size() < maxSize) continue;
            return;
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreeModel treeModel;
        Iterator selectedNode;
        PortalTree tree = (PortalTree)this.getPage().get("siteTree");
        Collection selectedNodes = tree.getTreeState().getSelectedNodes();
        DefaultMutableTreeNode treeNode = null;
        if (selectedNodes != null && (selectedNode = selectedNodes.iterator()).hasNext()) {
            treeNode = (DefaultMutableTreeNode)selectedNode.next();
        }
        if (treeNode == null && (treeModel = tree.getModelObject()) != null && treeModel.getRoot() != null) {
            treeNode = (DefaultMutableTreeNode)treeModel.getRoot();
        }
        if (treeNode == null) {
            treeNode = new DefaultMutableTreeNode(new SiteTreeNode("root", JETSPEED_PATH_SEPRATOR, SiteTreeNode.FileType.Folder));
        }
        return treeNode;
    }

    private DefaultMutableTreeNode getMenuSelectedNode() {
        Collection selectedNodes = this.menuTree.getTreeState().getSelectedNodes();
        DefaultMutableTreeNode treeNode = null;
        if (selectedNodes != null) {
            Iterator selectedNode = selectedNodes.iterator();
            if (selectedNode.hasNext()) {
                treeNode = (DefaultMutableTreeNode)selectedNode.next();
            }
            if (treeNode == null) {
                treeNode = new DefaultMutableTreeNode(new MenuTreeNode("Menus", null));
            }
        }
        return treeNode;
    }

    private SiteTreeNode getUserSelectedNode() {
        return (SiteTreeNode)this.getSelectedNode().getUserObject();
    }

    private void getSubFoldersPage(JetspeedDocument document) {
        ArrayList<String> pageFolder = new ArrayList<String>();
        List documentOrder = document.getDocumentOrder();
        try {
            Folder folder = this.getJetspeedFolder(document.getPath());
            Iterator folders = folder.getFolders().iterator();
            while (folders.hasNext()) {
                pageFolder.add(((Folder)folders.next()).getName());
            }
            Iterator pages = folder.getPages().iterator();
            while (pages.hasNext()) {
                pageFolder.add(((Page)pages.next()).getName());
            }
            Iterator links = folder.getLinks().iterator();
            while (links.hasNext()) {
                pageFolder.add(((Link)links.next()).getName());
            }
            for (String documentName : pageFolder) {
                if (documentOrder.contains(documentName)) continue;
                documentOrder.add(documentName);
            }
        }
        catch (InvalidFolderException e) {
            log.error("Invalid folder.", (Throwable)e);
        }
        catch (NodeException e) {
            log.error("Unexpected exception.", (Throwable)e);
        }
    }

    private void getMenus(JetspeedDocument document, DefaultMutableTreeNode menuNode) {
        MenuDefinition definition2 = null;
        DefaultMutableTreeNode menu = null;
        List menuDefinitions = null;
        menuDefinitions = this.getUserSelectedNode().getDocType() == SiteTreeNode.FileType.Folder ? this.getJetspeedFolder(document.getPath()).getMenuDefinitions() : this.getJetspeedPage(document.getPath()).getMenuDefinitions();
        if (menuDefinitions == null || menuDefinitions.size() == 0) {
            return;
        }
        for (MenuDefinition definition2 : menuDefinitions) {
            menu = new DefaultMutableTreeNode(new MenuTreeNode(definition2.getName(), document.getPath(), document.getType(), this.getServiceLocator()));
            menuNode.add(menu);
        }
    }

    private void getMenuElements(MenuDefinition definition, String type) {
        List<Object> elements = new ArrayList();
        if (definition.getMenuElements() == null || definition.getMenuElements().size() == 0) {
            elements = Collections.EMPTY_LIST;
        } else {
            Iterator menuElements = definition.getMenuElements().iterator();
            Object menuElement = null;
            while (menuElements.hasNext()) {
                menuElement = menuElements.next();
                if (type.equals("menu") && menuElement instanceof MenuDefinition) {
                    elements.add(menuElement);
                    continue;
                }
                if (type.equals("option") && menuElement instanceof MenuOptionsDefinition) {
                    elements.add(menuElement);
                    continue;
                }
                if (type.equals("separator") && menuElement instanceof MenuSeparatorDefinition) {
                    elements.add(menuElement);
                    continue;
                }
                if (type.equals(INCLUDES) && menuElement instanceof MenuIncludeDefinition) {
                    elements.add(menuElement);
                    continue;
                }
                if (!type.equals(EXCLUDES) || !(menuElement instanceof MenuExcludeDefinition)) continue;
                elements.add(menuElement);
            }
        }
        this.setMenuOption(elements);
    }

    private void updateList(List menuDefinitions, MenuDefinition olddefinition, MenuDefinition definition) {
        menuDefinitions.remove(definition);
        menuDefinitions.add(definition);
    }

    protected Object copyMenuElement(String type, Object srcElement) {
        PageManager pageManger = this.getServiceLocator().getPageManager();
        if (srcElement instanceof MenuDefinition) {
            MenuDefinition source = (MenuDefinition)srcElement;
            MenuDefinition menu = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menu = pageManger.newPageMenuDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menu = pageManger.newFolderMenuDefinition();
            }
            menu.setDepth(source.getDepth());
            menu.setName(source.getName());
            menu.setOptions(source.getOptions());
            menu.setOrder(source.getOrder());
            menu.setPaths(source.isPaths());
            menu.setProfile(source.getProfile());
            menu.setRegexp(source.isRegexp());
            menu.setShortTitle(source.getShortTitle());
            menu.setSkin(source.getSkin());
            menu.setTitle(source.getTitle());
            menu.getMetadata().copyFields(source.getMetadata().getFields());
            List elements = source.getMenuElements();
            if (elements != null) {
                ArrayList<Object> copiedElements = new ArrayList<Object>();
                for (Object element : elements) {
                    Object copiedElement = this.copyMenuElement(type, element);
                    if (copiedElement == null) continue;
                    copiedElements.add(copiedElement);
                }
                menu.setMenuElements(copiedElements);
            }
            return menu;
        }
        if (srcElement instanceof MenuExcludeDefinition) {
            MenuExcludeDefinition source = (MenuExcludeDefinition)srcElement;
            MenuExcludeDefinition menuExclude = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuExclude = pageManger.newPageMenuExcludeDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuExclude = pageManger.newFolderMenuExcludeDefinition();
            }
            menuExclude.setName(source.getName());
            return menuExclude;
        }
        if (srcElement instanceof MenuIncludeDefinition) {
            MenuIncludeDefinition source = (MenuIncludeDefinition)srcElement;
            MenuIncludeDefinition menuInclude = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuInclude = pageManger.newPageMenuIncludeDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuInclude = pageManger.newFolderMenuIncludeDefinition();
            }
            menuInclude.setName(source.getName());
            menuInclude.setNest(source.isNest());
            return menuInclude;
        }
        if (srcElement instanceof MenuOptionsDefinition) {
            MenuOptionsDefinition source = (MenuOptionsDefinition)srcElement;
            MenuOptionsDefinition menuOptions = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuOptions = pageManger.newPageMenuOptionsDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuOptions = pageManger.newFolderMenuOptionsDefinition();
            }
            menuOptions.setDepth(source.getDepth());
            menuOptions.setOptions(source.getOptions());
            menuOptions.setOrder(source.getOrder());
            menuOptions.setPaths(source.isPaths());
            menuOptions.setProfile(source.getProfile());
            menuOptions.setRegexp(source.isRegexp());
            menuOptions.setSkin(source.getSkin());
            return menuOptions;
        }
        if (srcElement instanceof MenuSeparatorDefinition) {
            MenuSeparatorDefinition source = (MenuSeparatorDefinition)srcElement;
            MenuSeparatorDefinition menuSeparator = null;
            if (type.equals(PAGE_NODE_TYPE)) {
                menuSeparator = pageManger.newPageMenuSeparatorDefinition();
            } else if (type.equals(FOLDER_NODE_TYPE)) {
                menuSeparator = pageManger.newFolderMenuSeparatorDefinition();
            }
            menuSeparator.setSkin(source.getSkin());
            menuSeparator.setTitle(source.getTitle());
            menuSeparator.setText(source.getText());
            menuSeparator.getMetadata().copyFields(source.getMetadata().getFields());
            return menuSeparator;
        }
        return null;
    }

    private String getNodeType() {
        String nodeType = FOLDER_NODE_TYPE;
        if (this.getUserSelectedNode().getDocType() == SiteTreeNode.FileType.Page) {
            nodeType = PAGE_NODE_TYPE;
        }
        return nodeType;
    }

    protected MenuDefinition getMenuDefinition() {
        return (MenuDefinition)this.getPortletRequest().getPortletSession().getAttribute("menuDefinition");
    }

    protected void setMenuDefinition(MenuDefinition menuDefinition) {
        this.getPortletRequest().getPortletSession().setAttribute("menuDefinition", (Object)menuDefinition);
    }

    protected void menuActions(String action, String options, OptionsDefinitionBean element) {
        SiteTreeNode node = this.getUserSelectedNode();
        MenuDefinition definition = this.getMenuDefinition();
        MenuOptionsDefinition oldElement = this.getOptionsDefinition(options);
        MenuOptionsDefinition newElement = this.getOptionsDefinition(element);
        if (node.getDocType() == SiteTreeNode.FileType.Folder) {
            Folder folder = this.getJetspeedFolder(node.getNodePath());
            List menuList = folder.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(definition);
                if (definition.getMenuElements() != null) {
                    definition.getMenuElements().remove(oldElement);
                    definition.getMenuElements().add(newElement);
                } else {
                    ArrayList<MenuOptionsDefinition> elements = new ArrayList<MenuOptionsDefinition>();
                    elements.add(newElement);
                    definition.setMenuElements(elements);
                }
                menuList.add(definition);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(definition);
                definition.getMenuElements().remove(oldElement);
                menuList.add(definition);
            }
            folder.setMenuDefinitions(menuList);
            this.folderAction(folder, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
            Page page = this.getJetspeedPage(node.getNodePath());
            List menuList = page.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(definition);
                if (definition.getMenuElements() != null) {
                    definition.getMenuElements().remove(oldElement);
                    definition.getMenuElements().add(newElement);
                } else {
                    ArrayList<MenuOptionsDefinition> elements = new ArrayList<MenuOptionsDefinition>();
                    elements.add(newElement);
                    definition.setMenuElements(elements);
                }
                menuList.add(definition);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(definition);
                definition.getMenuElements().remove(oldElement);
                menuList.add(definition);
            }
            page.setMenuDefinitions(menuList);
            this.PageAction(page, SAVE_ACTION);
        }
        this.setMenuDefinition(definition);
        this.getMenuElements(definition, "option");
    }

    protected void menuActions(String action, String name, JetspeedMenuDefinition element) {
        MenuDefinition oldElement = this.getDefinition(name);
        SiteTreeNode node = this.getUserSelectedNode();
        MenuDefinition newElement = this.getMenuDefinition(this.document.getType(), element);
        if (oldElement != null && oldElement.getMenuElements() != null) {
            newElement.setMenuElements(oldElement.getMenuElements());
        }
        if (node.getDocType() == SiteTreeNode.FileType.Folder) {
            Folder folder = this.getJetspeedFolder(node.getNodePath());
            LinkedList<MenuDefinition> menuList = folder.getMenuDefinitions();
            if (menuList == null) {
                menuList = new LinkedList<MenuDefinition>();
            }
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(oldElement);
                menuList.add(newElement);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(oldElement);
            } else if (action.equals(ADD_ACTION)) {
                menuList.add(newElement);
            }
            folder.setMenuDefinitions(menuList);
            this.folderAction(folder, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
            Page page = this.getJetspeedPage(node.getNodePath());
            List menuList = page.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(oldElement);
                menuList.add(newElement);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(oldElement);
            } else if (action.equals(ADD_ACTION)) {
                menuList.add(newElement);
            }
            page.setMenuDefinitions(menuList);
            this.PageAction(page, SAVE_ACTION);
        }
        this.setMenuDefinition(newElement);
    }

    protected void menuActions(String action, String name, SeparatorDefinitionBean element) {
        SiteTreeNode node = this.getUserSelectedNode();
        MenuDefinition definition = this.getMenuDefinition();
        MenuSeparatorDefinition oldElement = this.getSeparatorDefinition(element.getText());
        MenuSeparatorDefinition newElement = this.getSeparatorDefinition(element);
        if (node.getDocType() == SiteTreeNode.FileType.Folder) {
            Folder folder = this.getJetspeedFolder(node.getNodePath());
            List menuList = folder.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(definition);
                if (definition.getMenuElements() != null) {
                    definition.getMenuElements().remove(oldElement);
                    definition.getMenuElements().add(newElement);
                } else {
                    ArrayList<MenuSeparatorDefinition> elements = new ArrayList<MenuSeparatorDefinition>();
                    elements.add(newElement);
                    definition.setMenuElements(elements);
                }
                menuList.add(definition);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(definition);
                definition.getMenuElements().remove(oldElement);
                menuList.add(definition);
            }
            folder.setMenuDefinitions(menuList);
            this.folderAction(folder, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
            Page page = this.getJetspeedPage(node.getNodePath());
            List menuList = page.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(definition);
                if (definition.getMenuElements() != null) {
                    definition.getMenuElements().remove(oldElement);
                    definition.getMenuElements().add(newElement);
                } else {
                    ArrayList<MenuSeparatorDefinition> elements = new ArrayList<MenuSeparatorDefinition>();
                    elements.add(newElement);
                    definition.setMenuElements(elements);
                }
                menuList.add(definition);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(definition);
                definition.getMenuElements().remove(oldElement);
                menuList.add(definition);
            }
            page.setMenuDefinitions(menuList);
            this.PageAction(page, SAVE_ACTION);
        }
        this.setMenuDefinition(definition);
        this.getMenuElements(definition, "separator");
    }

    protected void menuActions(String action, String name, IncludesDefinitionBean element) {
        SiteTreeNode node = this.getUserSelectedNode();
        MenuDefinition definition = this.getMenuDefinition();
        MenuIncludeDefinition oldElement = this.getIncludesDefinition(name);
        MenuIncludeDefinition newElement = this.getIncludesDefinition(element);
        if (node.getDocType() == SiteTreeNode.FileType.Folder) {
            Folder folder = this.getJetspeedFolder(node.getNodePath());
            List menuList = folder.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(definition);
                if (definition.getMenuElements() != null) {
                    definition.getMenuElements().remove(oldElement);
                    definition.getMenuElements().add(newElement);
                } else {
                    ArrayList<MenuIncludeDefinition> elements = new ArrayList<MenuIncludeDefinition>();
                    elements.add(newElement);
                    definition.setMenuElements(elements);
                }
                menuList.add(definition);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(definition);
                definition.getMenuElements().remove(oldElement);
                menuList.add(definition);
            }
            folder.setMenuDefinitions(menuList);
            this.folderAction(folder, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
            Page page = this.getJetspeedPage(node.getNodePath());
            List menuList = page.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(definition);
                if (definition.getMenuElements() != null) {
                    definition.getMenuElements().remove(oldElement);
                    definition.getMenuElements().add(newElement);
                } else {
                    ArrayList<MenuIncludeDefinition> elements = new ArrayList<MenuIncludeDefinition>();
                    elements.add(newElement);
                    definition.setMenuElements(elements);
                }
                menuList.add(definition);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(definition);
                definition.getMenuElements().remove(oldElement);
                menuList.add(definition);
            }
            page.setMenuDefinitions(menuList);
            this.PageAction(page, SAVE_ACTION);
        }
        this.setMenuDefinition(definition);
        this.getMenuElements(definition, INCLUDES);
    }

    protected void menuActions(String action, String name, ExcludesDefinitionBean element) {
        SiteTreeNode node = this.getUserSelectedNode();
        MenuDefinition definition = this.getMenuDefinition();
        MenuExcludeDefinition oldElement = this.getExcludeDefinition(name);
        MenuExcludeDefinition newElement = this.getExcludesDefinition(element);
        if (node.getDocType() == SiteTreeNode.FileType.Folder) {
            Folder folder = this.getJetspeedFolder(node.getNodePath());
            List menuList = folder.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(definition);
                if (definition.getMenuElements() != null) {
                    definition.getMenuElements().remove(oldElement);
                    definition.getMenuElements().add(newElement);
                } else {
                    ArrayList<MenuExcludeDefinition> elements = new ArrayList<MenuExcludeDefinition>();
                    elements.add(newElement);
                    definition.setMenuElements(elements);
                }
                menuList.add(definition);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(definition);
                definition.getMenuElements().remove(oldElement);
                menuList.add(definition);
            }
            folder.setMenuDefinitions(menuList);
            this.folderAction(folder, SAVE_ACTION);
        } else if (node.getDocType() == SiteTreeNode.FileType.Page) {
            Page page = this.getJetspeedPage(node.getNodePath());
            List menuList = page.getMenuDefinitions();
            if (action.equals(SAVE_ACTION)) {
                menuList.remove(definition);
                if (definition.getMenuElements() != null) {
                    definition.getMenuElements().remove(oldElement);
                    definition.getMenuElements().add(newElement);
                } else {
                    ArrayList<MenuExcludeDefinition> elements = new ArrayList<MenuExcludeDefinition>();
                    elements.add(newElement);
                    definition.setMenuElements(elements);
                }
                menuList.add(definition);
            } else if (action.equals(REMOVE_ACTION)) {
                menuList.remove(definition);
                definition.getMenuElements().remove(oldElement);
                menuList.add(definition);
            }
            page.setMenuDefinitions(menuList);
            this.PageAction(page, SAVE_ACTION);
        }
        this.setMenuDefinition(definition);
        this.getMenuElements(definition, EXCLUDES);
    }

    protected Page getJetspeedPage(String pagePath) {
        Page page = null;
        try {
            page = this.getServiceLocator().getPageManager().getPage(pagePath);
        }
        catch (PageNotFoundException e) {
            log.error("Page is not found: {}", (Object)pagePath);
            return null;
        }
        catch (InvalidFolderException e) {
            log.error("Invalid folder path: {}", (Object)pagePath);
            return null;
        }
        catch (NodeException e) {
            log.error("Unexpected exception.", (Throwable)e);
            return null;
        }
        return page;
    }

    protected Link getJetspeedLink(String pagePath) {
        Link link = null;
        try {
            link = this.getServiceLocator().getPageManager().getLink(pagePath);
        }
        catch (PageNotFoundException e) {
            log.error("Page is not found: {}", (Object)pagePath);
            return null;
        }
        catch (InvalidFolderException e) {
            log.error("Invalid folder path: {}", (Object)pagePath);
            return null;
        }
        catch (NodeException e) {
            log.error("Unexpected exception.", (Throwable)e);
            return null;
        }
        catch (DocumentNotFoundException e) {
            log.error("Document is not found: {}", (Object)pagePath);
            return null;
        }
        return link;
    }

    protected Folder getJetspeedFolder(String folderPath) {
        Folder folder = null;
        try {
            folder = this.getServiceLocator().getPageManager().getFolder(folderPath);
        }
        catch (FolderNotFoundException e) {
            log.error("Folder is not found: {}", (Object)folderPath);
            return null;
        }
        catch (InvalidFolderException e) {
            log.error("Invalid folder path: {}", (Object)folderPath);
            return null;
        }
        catch (NodeException e) {
            log.error("Unexpected exception.", (Throwable)e);
            return null;
        }
        return folder;
    }

    protected void invalidatePortalSiteSessionContext() {
        this.getPortalRequestContext().setSessionAttribute("org.apache.jetspeed.portalsite.PortalSiteSessionContext", null);
    }

    protected boolean folderAction(Folder folder, String action) {
        if (action.equals(SAVE_ACTION)) {
            try {
                this.getServiceLocator().getPageManager().updateFolder(folder);
                this.invalidatePortalSiteSessionContext();
            }
            catch (FolderNotUpdatedException e) {
                log.error("Folder is not updated.", (Throwable)e);
                return false;
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                return false;
            }
        }
        if (action.equals(REMOVE_ACTION)) {
            try {
                this.getServiceLocator().getPageManager().removeFolder(folder);
                this.invalidatePortalSiteSessionContext();
            }
            catch (FolderNotRemovedException e) {
                log.error("Folder is not removed.", (Throwable)e);
                return false;
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected boolean PageAction(Page page, String action) {
        if (action.equals(SAVE_ACTION)) {
            try {
                this.getServiceLocator().getPageManager().updatePage(page);
                this.invalidatePortalSiteSessionContext();
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                return false;
            }
        }
        if (action.equals(REMOVE_ACTION)) {
            try {
                this.getServiceLocator().getPageManager().removePage(page);
                this.invalidatePortalSiteSessionContext();
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected boolean linkAction(Link link, String action) {
        if (action.equals(SAVE_ACTION)) {
            try {
                this.getServiceLocator().getPageManager().updateLink(link);
                this.invalidatePortalSiteSessionContext();
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                return false;
            }
        }
        if (action.equals(REMOVE_ACTION)) {
            try {
                this.getServiceLocator().getPageManager().removeLink(link);
                this.invalidatePortalSiteSessionContext();
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public List getMenuOption() {
        return this.menuOptions;
    }

    public void setMenuOption(List menuOptions) {
        this.menuOptions = menuOptions;
    }

    private void controlMenuTabs(boolean nodeSelected) {
        10 tab = null;
        this.menuTabs.clear();
        if (nodeSelected) {
            tab = new /* Unavailable Anonymous Inner Class!! */;
            this.menuTabs.add(tab);
            tab = new /* Unavailable Anonymous Inner Class!! */;
            this.menuTabs.add(tab);
            tab = new /* Unavailable Anonymous Inner Class!! */;
            this.menuTabs.add(tab);
            tab = new /* Unavailable Anonymous Inner Class!! */;
            this.menuTabs.add(tab);
            tab = new /* Unavailable Anonymous Inner Class!! */;
            this.menuTabs.add(tab);
        }
    }

    public List<ITab> getMenuTab() {
        return this.menuTabs;
    }

    private MenuOptionsDefinition getOptionsDefinition(String options) {
        List elements = this.getMenuDefinition().getMenuElements();
        if (elements != null) {
            for (int index = 0; index < elements.size(); ++index) {
                Object element = elements.get(index);
                if (!(element instanceof MenuOptionsDefinition) || !((MenuOptionsDefinition)element).getOptions().equals(options)) continue;
                return (MenuOptionsDefinition)element;
            }
        }
        return null;
    }

    private MenuSeparatorDefinition getSeparatorDefinition(String options) {
        List elements = this.getMenuDefinition().getMenuElements();
        if (elements != null) {
            for (int index = 0; index < elements.size(); ++index) {
                Object element = elements.get(index);
                if (!(element instanceof MenuSeparatorDefinition) || !((MenuSeparatorDefinition)element).getText().equals(options)) continue;
                return (MenuSeparatorDefinition)element;
            }
        }
        return null;
    }

    private MenuExcludeDefinition getExcludeDefinition(String options) {
        List elements = this.getMenuDefinition().getMenuElements();
        if (elements != null) {
            for (int index = 0; index < elements.size(); ++index) {
                Object element = elements.get(index);
                if (!(element instanceof MenuExcludeDefinition) || !((MenuExcludeDefinition)element).getName().equals(options)) continue;
                return (MenuExcludeDefinition)element;
            }
        }
        return null;
    }

    private MenuIncludeDefinition getIncludesDefinition(String options) {
        List elements = this.getMenuDefinition().getMenuElements();
        if (elements != null) {
            for (int index = 0; index < elements.size(); ++index) {
                Object element = elements.get(index);
                if (!(element instanceof MenuIncludeDefinition) || !((MenuIncludeDefinition)element).getName().equals(options)) continue;
                return (MenuIncludeDefinition)element;
            }
        }
        return null;
    }

    public MenuDefinition getDefinition(String name) {
        MenuDefinition definition = null;
        boolean found = true;
        try {
            if (this.document.getType().equals(FOLDER_NODE_TYPE)) {
                return this.getMenu(this.getServiceLocator().getPageManager().getFolder(this.document.getPath()).getMenuDefinitions(), name);
            }
            if (this.document.getType().equals(PAGE_NODE_TYPE)) {
                return this.getMenu(this.getServiceLocator().getPageManager().getPage(this.document.getPath()).getMenuDefinitions(), name);
            }
        }
        catch (PageNotFoundException e) {
            found = false;
        }
        catch (FolderNotFoundException e) {
            found = false;
        }
        catch (InvalidFolderException e) {
            found = false;
        }
        catch (NodeException e) {
            found = false;
        }
        catch (Exception e) {
            found = false;
        }
        if (!found) {
            if (this.document.getType().equals(PAGE_NODE_TYPE)) {
                definition = this.getServiceLocator().getPageManager().newPageMenuDefinition();
            } else if (this.document.getType().equals(FOLDER_NODE_TYPE)) {
                definition = this.getServiceLocator().getPageManager().newFolderMenuDefinition();
            }
        }
        return definition;
    }

    private MenuDefinition getMenu(List menuDefinitions, String name) {
        for (int index = 0; index < menuDefinitions.size(); ++index) {
            MenuDefinition definition = (MenuDefinition)menuDefinitions.get(index);
            if (!definition.getName().equals(name)) continue;
            return definition;
        }
        if (this.document.getType().equals(PAGE_NODE_TYPE)) {
            return this.getServiceLocator().getPageManager().newPageMenuDefinition();
        }
        return this.getServiceLocator().getPageManager().newFolderMenuDefinition();
    }

    private MenuDefinition getMenuDefinition(String type, JetspeedMenuDefinition menuDefinition) {
        MenuDefinition definition = null;
        definition = this.document.getType().equals(PAGE_NODE_TYPE) ? this.getServiceLocator().getPageManager().newPageMenuDefinition() : this.getServiceLocator().getPageManager().newFolderMenuDefinition();
        definition.setDepth(menuDefinition.getDepth());
        definition.setName(menuDefinition.getName());
        definition.setOptions(menuDefinition.getOptions());
        definition.setOrder(menuDefinition.getOrder());
        definition.setPaths(menuDefinition.isPaths());
        definition.setRegexp(menuDefinition.isRegexp());
        definition.setTitle(menuDefinition.getTitle());
        definition.setShortTitle(menuDefinition.getShortTitle());
        definition.setSkin(menuDefinition.getSkin());
        definition.setProfile(menuDefinition.getProfile());
        return definition;
    }

    private MenuSeparatorDefinition getSeparatorDefinition(SeparatorDefinitionBean separator) {
        MenuSeparatorDefinition definition = null;
        definition = this.document.getType().equals(PAGE_NODE_TYPE) ? this.getServiceLocator().getPageManager().newPageMenuSeparatorDefinition() : this.getServiceLocator().getPageManager().newFolderMenuSeparatorDefinition();
        definition.setText(separator.getText());
        definition.setTitle(separator.getTitle());
        return definition;
    }

    private MenuExcludeDefinition getExcludesDefinition(ExcludesDefinitionBean excludes) {
        MenuExcludeDefinition definition = null;
        definition = this.document.getType().equals(PAGE_NODE_TYPE) ? this.getServiceLocator().getPageManager().newPageMenuExcludeDefinition() : this.getServiceLocator().getPageManager().newFolderMenuExcludeDefinition();
        definition.setName(excludes.getName());
        return definition;
    }

    private MenuIncludeDefinition getIncludesDefinition(IncludesDefinitionBean includes) {
        MenuIncludeDefinition definition = null;
        definition = this.document.getType().equals(PAGE_NODE_TYPE) ? this.getServiceLocator().getPageManager().newPageMenuIncludeDefinition() : this.getServiceLocator().getPageManager().newFolderMenuIncludeDefinition();
        definition.setName(includes.getName());
        definition.setNest(includes.isNest());
        return definition;
    }

    private MenuOptionsDefinition getOptionsDefinition(OptionsDefinitionBean options) {
        MenuOptionsDefinition definition = null;
        definition = this.document.getType().equals(PAGE_NODE_TYPE) ? this.getServiceLocator().getPageManager().newPageMenuOptionsDefinition() : this.getServiceLocator().getPageManager().newFolderMenuOptionsDefinition();
        definition.setDepth(options.getDepth());
        definition.setOptions(options.getOptions());
        definition.setOrder(options.getOrder());
        definition.setPaths(options.isPaths());
        definition.setRegexp(options.isRegexp());
        definition.setSkin(options.getSkin());
        definition.setProfile(options.getProfile());
        return definition;
    }

    private SiteTreeNode getInitSiteTreeNode() {
        SiteTreeNode siteTreeNode = null;
        PortletRequest portletRequest = this.getPortletRequest();
        String pathParam = portletRequest.getParameter(PORTAL_SITE_MANAGER_INIT_NODE_PATH_PARAM);
        if (pathParam == null && (pathParam = this.getPreference(PORTAL_SITE_MANAGER_INIT_NODE_PATH_PARAM)) == null) {
            pathParam = this.getInitParam(PORTAL_SITE_MANAGER_INIT_NODE_PATH_PARAM);
        }
        if (pathParam != null) {
            String type = PAGE_NODE_TYPE;
            String typeParam = null;
            if (typeParam == null && (typeParam = this.getPreference(PORTAL_SITE_MANAGER_INIT_NODE_TYPE_PARAM)) == null) {
                typeParam = this.getInitParam(PORTAL_SITE_MANAGER_INIT_NODE_TYPE_PARAM);
            }
            if (typeParam != null) {
                type = typeParam;
            }
            PageManager pageManager = this.getServiceLocator().getPageManager();
            DefaultMutableTreeNode treeRootNode = null;
            try {
                if (PAGE_NODE_TYPE.equals(type)) {
                    Page page = pageManager.getPage(pathParam);
                    siteTreeNode = new SiteTreeNode(page.getName(), page.getPath(), SiteTreeNode.FileType.Page, true);
                    treeRootNode = new DefaultMutableTreeNode(new SiteTreeNode(page));
                } else if (FOLDER_NODE_TYPE.equals(type)) {
                    Folder folder = pageManager.getFolder(pathParam);
                    siteTreeNode = new SiteTreeNode(folder.getName(), folder.getPath(), SiteTreeNode.FileType.Folder, true);
                    treeRootNode = new DefaultMutableTreeNode(new SiteTreeNode(folder, true));
                } else if (LINK_NODE_TYPE.equals(type)) {
                    Link link = pageManager.getLink(pathParam);
                    siteTreeNode = new SiteTreeNode(link.getName(), link.getPath(), SiteTreeNode.FileType.Link, true);
                    treeRootNode = new DefaultMutableTreeNode(new SiteTreeNode(link));
                }
            }
            catch (Exception e) {
                log.error("Failed to retrieve the init site tree node on " + pathParam, (Throwable)e);
            }
            if (treeRootNode != null) {
                this.treeRoot = new DefaultTreeModel(treeRootNode);
            }
        }
        if (siteTreeNode == null) {
            siteTreeNode = new SiteTreeNode("ROOT", JETSPEED_PATH_SEPRATOR, SiteTreeNode.FileType.Folder, true);
        }
        return siteTreeNode;
    }

    private String getFolderOwner(Folder folder) {
        String owner = null;
        SecurityConstraints constraints = folder.getSecurityConstraints();
        if (constraints != null) {
            owner = constraints.getOwner();
        }
        return owner;
    }

    static /* synthetic */ DefaultMutableTreeNode access$000(PortalSiteManager x0, String x1) {
        return x0.populateUserTree(x1);
    }

    static /* synthetic */ DefaultMutableTreeNode access$100(PortalSiteManager x0) {
        return x0.populateTree();
    }

    static /* synthetic */ void access$300(PortalSiteManager x0, SiteTreeNode x1) {
        x0.populateDocument(x1);
    }

    static /* synthetic */ DefaultMutableTreeNode access$400(PortalSiteManager x0, String x1, DefaultMutableTreeNode x2) {
        return x0.retrieveFolders(x1, x2);
    }

    static /* synthetic */ AjaxTabbedPanel access$500(PortalSiteManager x0) {
        return x0.tabPanel;
    }

    static /* synthetic */ List access$600(PortalSiteManager x0) {
        return x0.getPageDecorators();
    }

    static /* synthetic */ List access$700(PortalSiteManager x0) {
        return x0.getPortletDecorators();
    }

    static /* synthetic */ List access$800(PortalSiteManager x0) {
        return x0.getThemes();
    }

    static /* synthetic */ List access$900(PortalSiteManager x0) {
        return x0.getTargetList();
    }

    static /* synthetic */ SiteTreeNode access$1000(PortalSiteManager x0) {
        return x0.getUserSelectedNode();
    }

    static /* synthetic */ void access$1100(PortalSiteManager x0, JetspeedDocument x1, String x2) {
        x0.excuteAction(x1, x2);
    }

    static /* synthetic */ DefaultMutableTreeNode access$1200(PortalSiteManager x0) {
        return x0.getSelectedNode();
    }

    static /* synthetic */ void access$1300(PortalSiteManager x0, String x1, String x2, String x3) {
        x0.securityConstraintAction(x1, x2, x3);
    }

    static /* synthetic */ void access$1400(PortalSiteManager x0, String x1, JetspeedDocumentMetaData x2, JetspeedDocumentMetaData x3) {
        x0.metaDataAction(x1, x2, x3);
    }

    static /* synthetic */ List access$1500(PortalSiteManager x0) {
        return x0.getConstraintsDef();
    }

    static /* synthetic */ DefaultTreeModel access$1600(PortalSiteManager x0) {
        return x0.menuTreeRoot;
    }

    static /* synthetic */ JetspeedDocument access$1700(PortalSiteManager x0) {
        return x0.document;
    }

    static /* synthetic */ LinkTree access$1800(PortalSiteManager x0) {
        return x0.menuTree;
    }

    static /* synthetic */ void access$1900(PortalSiteManager x0, boolean x1) {
        x0.controlMenuTabs(x1);
    }

    static /* synthetic */ String access$2200(PortalSiteManager x0, String x1) {
        return x0.fileExt(x1);
    }

    static /* synthetic */ boolean access$2300(PortalSiteManager x0, String x1) {
        return x0.cleanUserFolder(x1);
    }

    static /* synthetic */ String access$2400(PortalSiteManager x0, String x1) {
        return x0.getTempFolder(x1);
    }

    static /* synthetic */ boolean access$2500(PortalSiteManager x0, String x1, String x2, String x3) {
        return x0.unzipfile(x1, x2, x3);
    }

    static /* synthetic */ Folder access$2600(PortalSiteManager x0, PageManager x1, PageManager x2, Folder x3, String x4, String x5, boolean x6) throws JetspeedException {
        return x0.importFolders(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ void access$2900(PortalSiteManager x0, JetspeedDocument x1) {
        x0.getSubFoldersPage(x1);
    }

    static /* synthetic */ void access$3000(PortalSiteManager x0, JetspeedDocument x1, String x2) {
        x0.metaOrderAction(x1, x2);
    }

    static /* synthetic */ DefaultTreeModel access$1602(PortalSiteManager x0, DefaultTreeModel x1) {
        x0.menuTreeRoot = x1;
        return x0.menuTreeRoot;
    }

    static /* synthetic */ LinkTree access$1802(PortalSiteManager x0, LinkTree x1) {
        x0.menuTree = x1;
        return x0.menuTree;
    }

    static /* synthetic */ String access$3100(PortalSiteManager x0) {
        return x0.getNodeType();
    }

    static /* synthetic */ void access$3200(PortalSiteManager x0, JetspeedDocument x1, DefaultMutableTreeNode x2) {
        x0.getMenus(x1, x2);
    }

    static /* synthetic */ void access$3300(PortalSiteManager x0, MenuDefinition x1, String x2) {
        x0.getMenuElements(x1, x2);
    }

    static /* synthetic */ ExportObject access$3400(PortalSiteManager x0, SiteTreeNode x1, boolean x2, String x3) {
        return x0.exportJetspeedtObject(x1, x2, x3);
    }

    static /* synthetic */ DefaultMutableTreeNode access$3900(PortalSiteManager x0, String x1, DefaultMutableTreeNode x2) {
        return x0.retrieveCopyFolders(x1, x2);
    }

    static /* synthetic */ String access$4000(PortalSiteManager x0, Folder x1) {
        return x0.getFolderOwner(x1);
    }

    static /* synthetic */ void access$4100(PortalSiteManager x0, Node x1, boolean x2) {
        x0.setFolderTreeNodeLoadedByPath(x1, x2);
    }
}

