/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.prm;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.wicket.IClusterable;

public class LanguageBean
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private transient Language language;
    private Locale locale;

    public LanguageBean(Language language) {
        this.language = language;
        this.locale = language.getLocale();
    }

    public String getTitle() {
        return this.language.getTitle();
    }

    public void setTitle(String title) {
        this.language.setTitle(title);
    }

    public String getShortTitle() {
        return this.language.getShortTitle();
    }

    public void setShortTitle(String shortTitle) {
        this.language.setShortTitle(shortTitle);
    }

    public boolean isSupportedLocale() {
        return this.language.isSupportedLocale();
    }

    public void setSupportedLocale(boolean supportedLocale) {
        this.language.setSupportedLocale(supportedLocale);
    }

    public String getKeywords() {
        return this.language.getKeywords();
    }

    public void setKeywords(String keywords) {
        this.language.setKeywords(keywords);
    }

    public String getLocaleString() {
        return this.locale.toString();
    }

    public void setLocaleString(String localeString) {
        String language = null;
        String country = null;
        String[] tokens = StringUtils.splitPreserveAllTokens((String)localeString, (char)'_');
        if (tokens.length > 0) {
            language = tokens[0];
        }
        if (tokens.length > 1) {
            country = tokens[1];
        }
        this.locale = country == null ? new Locale(language) : new Locale(language, country);
    }

    public Locale getLocale() {
        return this.locale;
    }
}

