/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataChangeset;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.request.batch.AbstractODataBatchRequestItem;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchRequestContext;
import org.apache.olingo.client.core.communication.request.batch.ODataChangesetResponseItem;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataChangesetImpl
extends AbstractODataBatchRequestItem
implements ODataChangeset {
    private int contentId = 0;
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final ODataBatchRequestContext batchRequestContext;
    private final String boundary;
    private final ODataChangesetResponseItem expectedResItem;

    ODataChangesetImpl(ODataBatchRequest req, ODataChangesetResponseItem expectedResItem, ODataBatchRequestContext batchRequestContext) {
        super(req);
        this.expectedResItem = expectedResItem;
        this.batchRequestContext = batchRequestContext;
        this.boundary = "changeset_" + UUID.randomUUID();
    }

    @Override
    public int getLastContentId() {
        return this.contentId;
    }

    @Override
    protected void closeItem() {
        if (this.hasStreamedSomething) {
            this.newLine();
            this.stream(("--" + this.boundary + "--").getBytes(DEFAULT_CHARSET));
            this.newLine();
            this.newLine();
        }
    }

    @Override
    public ODataChangeset addRequest(ODataBatchableRequest request) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Current batch item is closed");
        }
        if (request.getMethod() == HttpMethod.GET) {
            throw new IllegalArgumentException("Invalid request. GET method not allowed in changeset");
        }
        if (!this.hasStreamedSomething) {
            this.stream(("Content-Type: " + ContentType.MULTIPART_MIXED + ";boundary=" + this.boundary).getBytes(DEFAULT_CHARSET));
            this.newLine();
            this.newLine();
            this.hasStreamedSomething = true;
        }
        this.contentId = this.getContentId();
        this.newLine();
        this.stream(("--" + this.boundary).getBytes(DEFAULT_CHARSET));
        this.newLine();
        this.streamRequestHeader(String.valueOf(this.contentId));
        request.batch(this.req, String.valueOf(this.contentId));
        this.expectedResItem.addResponse(String.valueOf(this.contentId), (ODataResponse)((AbstractODataRequest)((Object)request)).getResponseTemplate());
        return this;
    }

    private int getContentId() {
        return this.batchRequestContext.getAndIncrementContentId();
    }
}

