/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.NonNull;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

public final class DefaultSecurityFilterChain
implements SecurityFilterChain,
BeanNameAware,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(DefaultSecurityFilterChain.class);
    private final RequestMatcher requestMatcher;
    private final List<Filter> filters;
    private String beanName;
    private ConfigurableListableBeanFactory beanFactory;

    public DefaultSecurityFilterChain(RequestMatcher requestMatcher, Filter ... filters) {
        this(requestMatcher, Arrays.asList(filters));
    }

    public DefaultSecurityFilterChain(RequestMatcher requestMatcher, List<Filter> filters) {
        if (filters.isEmpty()) {
            logger.debug((Object)LogMessage.format((String)"Will not secure %s", (Object)requestMatcher));
        } else {
            ArrayList<String> filterNames = new ArrayList<String>();
            for (Filter filter : filters) {
                filterNames.add(filter.getClass().getSimpleName());
            }
            String names = StringUtils.collectionToDelimitedString(filterNames, (String)", ");
            logger.debug((Object)LogMessage.format((String)"Will secure %s with filters: %s", (Object)requestMatcher, (Object)names));
        }
        this.requestMatcher = requestMatcher;
        this.filters = new ArrayList<Filter>(filters);
    }

    public RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        return this.requestMatcher.matches(request);
    }

    public String toString() {
        ArrayList<String> filterNames = new ArrayList<String>();
        for (Filter filter : this.filters) {
            String name = filter.getClass().getSimpleName();
            if (name.endsWith("Filter")) {
                name = name.substring(0, name.length() - "Filter".length());
            }
            filterNames.add(name);
        }
        Object declaration = this.getClass().getSimpleName();
        if (this.beanName != null) {
            BeanDefinition bd;
            String description;
            declaration = (String)declaration + " defined as '" + this.beanName + "'";
            if (this.beanFactory != null && (description = (bd = this.beanFactory.getBeanDefinition(this.beanName)).getResourceDescription()) != null) {
                declaration = (String)declaration + " in [" + description + "]";
            }
        }
        return (String)declaration + " matching [" + String.valueOf(this.requestMatcher) + "] and having filters " + String.valueOf(filterNames);
    }

    public void setBeanName(@NonNull String name) {
        this.beanName = name;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory listable;
            this.beanFactory = listable = (ConfigurableListableBeanFactory)beanFactory;
        }
    }
}

