/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jpt30.tools.FileObject;
import jpt30.tools.JavaFileManager;
import jpt30.tools.JavaFileObject;
import jpt30.tools.StandardLocation;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.classpath.AptCacheForSourceQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.ModuleLocation;
import org.netbeans.modules.java.source.parsing.ModuleSourceFileManager;
import org.netbeans.modules.java.source.parsing.SiblingProvider;
import org.netbeans.modules.java.source.parsing.SourceFileManager;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;

public class AptSourceFileManager
extends SourceFileManager {
    public static final String ORIGIN_FILE = "apt-origin";
    public static final String ORIGIN_SOURCE_ELEMENT_URL = "apt-source-element";
    public static final String ORIGIN_RESOURCE_ELEMENT_URL = "apt-resource-element";
    private final ClassPath userRoots;
    private final SiblingProvider siblings;
    private final FileManagerTransaction fileTx;
    private final ModuleSourceFileManager moduleSourceFileManager;
    private Iterable<Set<JavaFileManager.Location>> cachedModuleLocations;

    public AptSourceFileManager(@NonNull ClassPath userRoots, @NonNull ClassPath aptRoots, @NonNull SiblingProvider siblings, @NonNull FileManagerTransaction fileTx, @NullAllowed ModuleSourceFileManager moduleSFileManager) {
        super(aptRoots, true);
        assert (userRoots != null);
        assert (siblings != null);
        this.userRoots = userRoots;
        this.siblings = siblings;
        this.fileTx = fileTx;
        this.moduleSourceFileManager = moduleSFileManager;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        return this.fileTx.filter(l, packageName, super.list(l, packageName, kinds, recursive));
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location l, String pkgName, String relativeName, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager.Location location;
        URL aptRoot = this.getAptRoot(sibling);
        if (ModuleLocation.isInstance(l)) {
            ModuleLocation mloc = ModuleLocation.cast(l);
            l = mloc.getBaseLocation();
            if (aptRoot == null) {
                Iterator<? extends URL> it = mloc.getModuleRoots().iterator();
                aptRoot = it.hasNext() ? it.next() : null;
            } else if (!mloc.getModuleRoots().contains(aptRoot)) {
                throw new UnsupportedOperationException("ModuleLocation's APT root differs from the sibling's APT root");
            }
        }
        if (StandardLocation.SOURCE_OUTPUT != (location = l)) {
            throw new UnsupportedOperationException("Only apt output is supported.");
        }
        if (aptRoot == null) {
            throw new UnsupportedOperationException(this.noAptRootDebug(sibling));
        }
        String nameStr = pkgName.length() == 0 ? relativeName : pkgName.replace('.', File.separatorChar) + File.separatorChar + relativeName;
        return Optional.ofNullable(URLMapper.findFileObject(aptRoot)).map(fo -> {
            File f = FileUtil.toFile(fo);
            return this.fileTx.createFileObject(location, new File(f, nameStr), f, null, null);
        }).get();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager.Location location;
        URL aptRoot = this.getAptRoot(sibling);
        if (ModuleLocation.isInstance(l)) {
            ModuleLocation mloc = ModuleLocation.cast(l);
            l = mloc.getBaseLocation();
            if (aptRoot == null) {
                Iterator<? extends URL> it = mloc.getModuleRoots().iterator();
                aptRoot = it.hasNext() ? it.next() : null;
            } else if (!mloc.getModuleRoots().contains(aptRoot)) {
                throw new UnsupportedOperationException("ModuleLocation's APT root differs from the sibling's APT root");
            }
        }
        if (StandardLocation.SOURCE_OUTPUT != (location = l)) {
            throw new UnsupportedOperationException("Only apt output is supported.");
        }
        if (aptRoot == null) {
            throw new UnsupportedOperationException(this.noAptRootDebug(sibling));
        }
        String nameStr = className.replace('.', File.separatorChar) + kind.extension;
        return Optional.ofNullable(URLMapper.findFileObject(aptRoot)).map(fo -> {
            File f = FileUtil.toFile(fo);
            return this.fileTx.createFileObject(location, new File(f, nameStr), f, null, null);
        }).get();
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        return super.handleOption(head, tail);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        if (location != StandardLocation.SOURCE_OUTPUT) {
            throw new UnsupportedOperationException("Only apt output is supported.");
        }
        if (this.cachedModuleLocations == null) {
            if (this.moduleSourceFileManager != null) {
                HashSet entriesUrl = new HashSet();
                this.sourceRoots.entries().forEach(e -> entriesUrl.add(e.getURL()));
                this.cachedModuleLocations = this.moduleSourceFileManager.sourceModuleLocations().stream().map(ml -> {
                    ModuleLocation oml = ModuleLocation.create(StandardLocation.SOURCE_OUTPUT, ml.getModuleRoots().stream().map(src -> {
                        try {
                            return BaseUtilities.toURI(JavaIndex.getAptFolder(src, false)).toURL();
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace(ioe);
                            return null;
                        }
                    }).filter(cacheEntry -> cacheEntry != null && entriesUrl.contains(cacheEntry)).collect(Collectors.toSet()), ml.getModuleName());
                    return oml.getModuleRoots().isEmpty() ? null : Collections.singleton(oml);
                }).filter(locations -> locations != null).collect(Collectors.toList());
            } else {
                this.cachedModuleLocations = Collections.emptySet();
            }
        }
        return this.cachedModuleLocations;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        return StreamSupport.stream(this.listLocationsForModules(location).spliterator(), false).flatMap(c -> c.stream()).filter(l -> moduleName.equals(ModuleLocation.cast(l).getModuleName())).findAny().orElse(null);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        URL foUrl = fo.toUri().toURL();
        for (Set<JavaFileManager.Location> s : this.listLocationsForModules(location)) {
            for (JavaFileManager.Location l : s) {
                ModuleLocation ml = ModuleLocation.cast(l);
                for (URL uRL : ml.getModuleRoots()) {
                    if (!FileObjects.isParentOf(uRL, foUrl)) continue;
                    return l;
                }
            }
        }
        return null;
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        ModuleLocation ml = ModuleLocation.cast(location);
        return ml.getModuleName();
    }

    private URL getAptRoot(FileObject sibling) {
        URL ownerRoot = this.getOwnerRoot(sibling);
        if (ownerRoot == null) {
            return null;
        }
        return AptCacheForSourceQuery.getAptFolder(ownerRoot);
    }

    private URL getOwnerRoot(FileObject sibling) {
        try {
            return this.siblings.hasSibling() ? this.getOwnerRootSib(this.siblings.getSibling()) : (sibling == null ? this.getOwnerRootNoSib() : this.getOwnerRootSib(sibling.toUri().toURL()));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace(ex);
            return null;
        }
    }

    private URL getOwnerRootSib(URL sibling) throws MalformedURLException {
        URL rootURL;
        assert (sibling != null);
        for (ClassPath.Entry entry : this.userRoots.entries()) {
            rootURL = entry.getURL();
            if (!FileObjects.isParentOf(rootURL, sibling)) continue;
            return rootURL;
        }
        for (ClassPath.Entry entry : this.sourceRoots.entries()) {
            rootURL = entry.getURL();
            if (!FileObjects.isParentOf(rootURL, sibling)) continue;
            return rootURL;
        }
        return null;
    }

    private URL getOwnerRootNoSib() {
        List<ClassPath.Entry> entries = this.userRoots.entries();
        return entries.size() == 1 ? entries.get(0).getURL() : null;
    }

    private String noAptRootDebug(FileObject sibling) {
        StringBuilder sb = new StringBuilder("No apt root for source root: ");
        sb.append(this.getOwnerRoot(sibling));
        sb.append(" sibling: ");
        if (this.siblings.hasSibling()) {
            sb.append(this.siblings.getSibling());
        } else if (sibling != null) {
            sb.append(sibling.toUri());
        } else {
            sb.append("none");
        }
        return sb.toString();
    }
}

