/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.standalone;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Lifecycle;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Type;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Provides;
import org.apache.maven.api.di.SessionScoped;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.LifecycleRegistry;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.services.PackagingRegistry;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.SettingsBuilder;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.spi.TypeProvider;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.di.Injector;
import org.apache.maven.di.Key;
import org.apache.maven.di.Scope;
import org.apache.maven.di.impl.DIException;
import org.apache.maven.impl.AbstractSession;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.di.SessionScope;
import org.apache.maven.impl.resolver.scopes.Maven4ScopeManagerConfiguration;
import org.apache.maven.impl.standalone.RepositorySystemSupplier;
import org.apache.maven.impl.standalone.UnsupportedInStandaloneModeException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.scope.ScopeManagerConfiguration;
import org.eclipse.aether.internal.impl.scope.ScopeManagerImpl;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.scope.ScopeManager;

public class ApiRunner {
    public static Session createSession() {
        return ApiRunner.createSession(null);
    }

    public static Session createSession(Consumer<Injector> injectorConsumer) {
        return ApiRunner.createSession(injectorConsumer, null);
    }

    public static Session createSession(Consumer<Injector> injectorConsumer, Path localRepo) {
        Injector injector = Injector.create();
        injector.bindInstance(Injector.class, (Object)injector);
        injector.bindImplicit(ApiRunner.class);
        injector.bindImplicit(RepositorySystemSupplier.class);
        injector.bindInstance(LocalRepoProvider.class, () -> localRepo);
        injector.discover(ApiRunner.class.getClassLoader());
        if (injectorConsumer != null) {
            injectorConsumer.accept(injector);
        }
        Session session = (Session)injector.getInstance(Session.class);
        SessionScope scope = new SessionScope();
        scope.enter();
        scope.seed(Session.class, session);
        injector.bindScope(SessionScoped.class, (Scope)scope);
        return session;
    }

    @Provides
    static Lookup newLookup(final Injector injector) {
        return new Lookup(){

            public <T> T lookup(Class<T> type) {
                try {
                    return (T)injector.getInstance(type);
                }
                catch (DIException e) {
                    throw new MavenException("Unable to locate instance of type " + String.valueOf(type), (Throwable)e);
                }
            }

            public <T> T lookup(Class<T> type, String name) {
                try {
                    return (T)injector.getInstance(Key.of(type, (Object)name));
                }
                catch (DIException e) {
                    throw new MavenException("Unable to locate instance of type " + String.valueOf(type), (Throwable)e);
                }
            }

            public <T> Optional<T> lookupOptional(Class<T> type) {
                try {
                    return Optional.of(injector.getInstance(type));
                }
                catch (DIException e) {
                    return Optional.empty();
                }
            }

            public <T> Optional<T> lookupOptional(Class<T> type, String name) {
                try {
                    return Optional.of(injector.getInstance(Key.of(type, (Object)name)));
                }
                catch (DIException e) {
                    return Optional.empty();
                }
            }

            public <T> List<T> lookupList(Class<T> type) {
                return (List)injector.getInstance(new Key<List<T>>(){});
            }

            public <T> Map<String, T> lookupMap(Class<T> type) {
                return (Map)injector.getInstance(new Key<Map<String, T>>(){});
            }
        };
    }

    @Provides
    static ArtifactManager newArtifactManager() {
        return new ArtifactManager(){
            private final Map<Artifact, Path> paths = new ConcurrentHashMap<Artifact, Path>();

            public Optional<Path> getPath(Artifact artifact) {
                return Optional.ofNullable(this.paths.get(artifact));
            }

            public void setPath(ProducedArtifact artifact, Path path) {
                this.paths.put((Artifact)artifact, path);
            }
        };
    }

    @Provides
    static PackagingRegistry newPackagingRegistry(TypeRegistry typeRegistry) {
        return id -> Optional.of(new DumbPackaging(id, typeRegistry.require(id), Map.of()));
    }

    @Provides
    static TypeRegistry newTypeRegistry(final List<TypeProvider> providers) {
        return new TypeRegistry(){

            public Optional<Type> lookup(String id) {
                return providers.stream().flatMap(p -> p.provides().stream()).filter(t -> Objects.equals(id, t.id())).findAny();
            }
        };
    }

    @Provides
    static LifecycleRegistry newLifecycleRegistry() {
        return new LifecycleRegistry(){

            public Iterator<Lifecycle> iterator() {
                return Collections.emptyIterator();
            }

            public Optional<Lifecycle> lookup(String id) {
                return Optional.empty();
            }

            public List<String> computePhases(Lifecycle lifecycle) {
                return List.of();
            }
        };
    }

    @Provides
    static Session newSession(RepositorySystem system, Lookup lookup, @Nullable LocalRepoProvider localRepoProvider) {
        HashMap<String, String> properties = new HashMap<String, String>();
        System.getenv().forEach((k, v) -> properties.put("env." + k, (String)v));
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put(k.toString(), v.toString())));
        properties.put("user.home", "target");
        Path userHome = Paths.get((String)properties.get("user.home"), new String[0]);
        Path mavenUserHome = userHome.resolve(".m2");
        Path mavenSystemHome = properties.containsKey("maven.home") ? Paths.get((String)properties.get("maven.home"), new String[0]) : (properties.containsKey("env.MAVEN_HOME") ? Paths.get((String)properties.get("env.MAVEN_HOME"), new String[0]) : null);
        DefaultRepositorySystemSession rsession = new DefaultRepositorySystemSession(h -> false);
        rsession.setScopeManager((ScopeManager)new ScopeManagerImpl((ScopeManagerConfiguration)Maven4ScopeManagerConfiguration.INSTANCE));
        rsession.setSystemProperties(properties);
        rsession.setConfigProperties(properties);
        DefaultSession session = new DefaultSession((RepositorySystemSession)rsession, system, List.of(((RepositoryFactory)lookup.lookup(RepositoryFactory.class)).createRemote("central", "https://repo.maven.apache.org/maven2")), null, lookup);
        Settings settings = session.getService(SettingsBuilder.class).build((Session)session, mavenSystemHome != null ? mavenSystemHome.resolve("settings.xml") : null, mavenUserHome.resolve("settings.xml")).getEffectiveSettings();
        String localRepository = settings.getLocalRepository() != null && !settings.getLocalRepository().isEmpty() ? settings.getLocalRepository() : (localRepoProvider != null && localRepoProvider.getLocalRepo() != null ? localRepoProvider.getLocalRepo().toString() : mavenUserHome.resolve("repository").toString());
        LocalRepositoryManager llm = system.newLocalRepositoryManager((RepositorySystemSession)rsession, new LocalRepository(localRepository));
        rsession.setLocalRepositoryManager(llm);
        org.apache.maven.api.model.Profile profile = session.getService(SettingsBuilder.class).convert(Profile.newBuilder().repositories((Collection)settings.getRepositories()).pluginRepositories((Collection)settings.getPluginRepositories()).build());
        RepositoryFactory repositoryFactory = session.getService(RepositoryFactory.class);
        List<RemoteRepository> repositories = profile.getRepositories().stream().map(arg_0 -> ((RepositoryFactory)repositoryFactory).createRemote(arg_0)).toList();
        InternalSession s = (InternalSession)session.withRemoteRepositories(repositories);
        InternalSession.associate((RepositorySystemSession)rsession, s);
        return s;
    }

    static interface LocalRepoProvider {
        public Path getLocalRepo();
    }

    static class DefaultSession
    extends AbstractSession {
        private final Map<String, String> systemProperties;
        private final Instant startTime = MonotonicClock.now();

        DefaultSession(RepositorySystemSession session, RepositorySystem repositorySystem, Lookup lookup) {
            this(session, repositorySystem, Collections.emptyList(), null, lookup);
        }

        protected DefaultSession(RepositorySystemSession session, RepositorySystem repositorySystem, List<RemoteRepository> repositories, List<org.eclipse.aether.repository.RemoteRepository> resolverRepositories, Lookup lookup) {
            super(session, repositorySystem, repositories, resolverRepositories, lookup);
            this.systemProperties = System.getenv().entrySet().stream().collect(Collectors.toMap(e -> "env." + (String)e.getKey(), Map.Entry::getValue));
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.systemProperties.put(k.toString(), v.toString())));
        }

        @Override
        protected Session newSession(RepositorySystemSession session, List<RemoteRepository> repositories) {
            return new DefaultSession(session, this.repositorySystem, repositories, null, this.lookup);
        }

        public Settings getSettings() {
            return Settings.newInstance();
        }

        @Nonnull
        public Collection<ToolchainModel> getToolchains() {
            return List.of();
        }

        public Map<String, String> getUserProperties() {
            return Map.of();
        }

        public Map<String, String> getSystemProperties() {
            return this.systemProperties;
        }

        public Map<String, String> getEffectiveProperties(Project project) {
            HashMap<String, String> result = new HashMap<String, String>(this.getSystemProperties());
            if (project != null) {
                result.putAll(project.getModel().getProperties());
            }
            result.putAll(this.getUserProperties());
            return result;
        }

        public Version getMavenVersion() {
            return null;
        }

        public int getDegreeOfConcurrency() {
            return 0;
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public Path getTopDirectory() {
            return null;
        }

        public Path getRootDirectory() {
            throw new IllegalStateException();
        }

        public List<Project> getProjects() {
            return List.of();
        }

        public Map<String, Object> getPluginContext(Project project) {
            throw new UnsupportedInStandaloneModeException();
        }
    }

    record DumbPackaging(String id, Type type, Map<String, PluginContainer> plugins) implements Packaging
    {
    }
}

