/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.xml;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

class ImmutableCollections {
    private static final List<?> EMPTY_LIST = new AbstractImmutableList<Object>(){

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 0;
        }
    };
    private static final Map<?, ?> EMPTY_MAP = new AbstractImmutableMap<Object, Object>(){

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return new AbstractImmutableSet<Map.Entry<Object, Object>>(){

                @Override
                public Iterator<Map.Entry<Object, Object>> iterator() {
                    return new Iterator<Map.Entry<Object, Object>>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public Map.Entry<Object, Object> next() {
                            throw new NoSuchElementException();
                        }
                    };
                }

                @Override
                public int size() {
                    return 0;
                }
            };
        }
    };

    ImmutableCollections() {
    }

    static <E> List<E> copy(Collection<E> collection) {
        if (collection == null) {
            return ImmutableCollections.emptyList();
        }
        if (collection instanceof AbstractImmutableList) {
            return (List)collection;
        }
        return switch (collection.size()) {
            case 0 -> ImmutableCollections.emptyList();
            case 1 -> ImmutableCollections.singletonList(collection.iterator().next());
            case 2 -> {
                Iterator<E> it = collection.iterator();
                yield new List2<E>(it.next(), it.next());
            }
            default -> new ListN<E>(collection);
        };
    }

    static <E> List<E> emptyList() {
        return EMPTY_LIST;
    }

    static <E> List<E> singletonList(E element) {
        return new List1<E>(element);
    }

    static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return ImmutableCollections.emptyMap();
        }
        if (map instanceof AbstractImmutableMap) {
            return map;
        }
        return switch (map.size()) {
            case 0 -> ImmutableCollections.emptyMap();
            case 1 -> {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                yield ImmutableCollections.singletonMap(entry.getKey(), entry.getValue());
            }
            default -> new MapN<K, V>(map);
        };
    }

    static <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    static <K, V> Map<K, V> singletonMap(K key, V value) {
        return new Map1<K, V>(key, value);
    }

    static Properties copy(Properties properties) {
        if (properties instanceof ROProperties) {
            return properties;
        }
        return new ROProperties(properties);
    }

    private static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }

    private static abstract class AbstractImmutableList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private AbstractImmutableList() {
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public Iterator<E> iterator() {
            return new Itr(0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new Itr(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index < 0 || index > this.size()) {
                throw this.outOfBounds(index);
            }
            return new Itr(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > this.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            return new SubList(fromIndex, toIndex);
        }

        protected IndexOutOfBoundsException outOfBounds(int index) {
            return new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }

        private class Itr
        implements ListIterator<E> {
            int index;

            private Itr(int index) {
                this.index = index;
            }

            @Override
            public boolean hasNext() {
                return this.index < AbstractImmutableList.this.size();
            }

            @Override
            public E next() {
                return AbstractImmutableList.this.get(this.index++);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public E previous() {
                return AbstractImmutableList.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw ImmutableCollections.uoe();
            }

            @Override
            public void set(E e) {
                throw ImmutableCollections.uoe();
            }

            @Override
            public void add(E e) {
                throw ImmutableCollections.uoe();
            }
        }

        private class SubList
        extends AbstractImmutableList<E> {
            private final int fromIndex;
            private final int toIndex;

            private SubList(int fromIndex, int toIndex) {
                this.fromIndex = fromIndex;
                this.toIndex = toIndex;
            }

            @Override
            public E get(int index) {
                if (index < 0 || index > this.size()) {
                    throw this.outOfBounds(index);
                }
                return AbstractImmutableList.this.get(this.fromIndex + index);
            }

            @Override
            public int size() {
                return this.toIndex - this.fromIndex;
            }
        }
    }

    private static class List2<E>
    extends AbstractImmutableList<E> {
        private final E element1;
        private final E element2;

        private List2(E element1, E element2) {
            this.element1 = element1;
            this.element2 = element2;
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.element1;
            }
            if (index == 1) {
                return this.element2;
            }
            throw this.outOfBounds(index);
        }

        @Override
        public int size() {
            return 2;
        }
    }

    private static class ListN<E>
    extends AbstractImmutableList<E> {
        private final Object[] elements;

        private ListN(Collection<E> elements) {
            this.elements = elements.toArray();
        }

        @Override
        public E get(int index) {
            return (E)this.elements[index];
        }

        @Override
        public int size() {
            return this.elements.length;
        }
    }

    private static class List1<E>
    extends AbstractImmutableList<E> {
        private final E element;

        private List1(E element) {
            this.element = element;
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.element;
            }
            throw this.outOfBounds(index);
        }

        @Override
        public int size() {
            return 1;
        }
    }

    private static abstract class AbstractImmutableMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private AbstractImmutableMap() {
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V replace(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw ImmutableCollections.uoe();
        }
    }

    private static class MapN<K, V>
    extends AbstractImmutableMap<K, V> {
        private final Object[] entries;

        private MapN(Map<K, V> map) {
            if (map != null) {
                this.entries = new Object[map.size()];
                int idx = 0;
                for (Map.Entry<K, V> e : map.entrySet()) {
                    this.entries[idx++] = new AbstractMap.SimpleImmutableEntry<K, V>(e.getKey(), e.getValue());
                }
            } else {
                this.entries = new Object[0];
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractImmutableSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < entries.length;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.index < entries.length) {
                                return (Map.Entry)entries[this.index++];
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }

                @Override
                public int size() {
                    return entries.length;
                }
            };
        }
    }

    private static class Map1<K, V>
    extends AbstractImmutableMap<K, V> {
        private final Map.Entry<K, V> entry;

        private Map1(K key, V value) {
            this.entry = new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractImmutableSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index == 0;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.index++ == 0) {
                                return entry;
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }

                @Override
                public int size() {
                    return 1;
                }
            };
        }
    }

    private static class ROProperties
    extends Properties {
        private ROProperties(Properties props) {
            if (props != null) {
                for (Map.Entry<Object, Object> e : props.entrySet()) {
                    super.put(e.getKey(), e.getValue());
                }
            }
        }

        @Override
        public Object put(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public Object remove(Object key) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void putAll(Map<?, ?> t) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public Object putIfAbsent(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean replace(Object key, Object oldValue, Object newValue) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public Object replace(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            throw ImmutableCollections.uoe();
        }
    }

    private static abstract class AbstractImmutableSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private AbstractImmutableSet() {
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw ImmutableCollections.uoe();
        }
    }
}

