/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import org.apache.maven.api.Service;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.services.xml.XmlWriterException;
import org.apache.maven.api.services.xml.XmlWriterRequest;

@Experimental
public interface XmlFactory<T>
extends Service {
    @Nonnull
    default public T read(@Nonnull Path path) throws XmlReaderException {
        return this.read(path, true);
    }

    @Nonnull
    default public T read(@Nonnull Path path, boolean strict) throws XmlReaderException {
        return this.read(XmlReaderRequest.builder().path(path).strict(strict).build());
    }

    @Nonnull
    default public T read(@Nonnull InputStream input) throws XmlReaderException {
        return this.read(input, true);
    }

    @Nonnull
    default public T read(@Nonnull InputStream input, boolean strict) throws XmlReaderException {
        return this.read(XmlReaderRequest.builder().inputStream(input).strict(strict).build());
    }

    @Nonnull
    default public T read(@Nonnull Reader reader) throws XmlReaderException {
        return this.read(reader, true);
    }

    @Nonnull
    default public T read(@Nonnull Reader reader, boolean strict) throws XmlReaderException {
        return this.read(XmlReaderRequest.builder().reader(reader).strict(strict).build());
    }

    @Nonnull
    public T read(@Nonnull XmlReaderRequest var1) throws XmlReaderException;

    default public void write(@Nonnull T content, @Nonnull Path path) throws XmlWriterException {
        this.write(XmlWriterRequest.builder().content(content).path(path).build());
    }

    default public void write(@Nonnull T content, @Nonnull OutputStream outputStream) throws XmlWriterException {
        this.write(XmlWriterRequest.builder().content(content).outputStream(outputStream).build());
    }

    default public void write(@Nonnull T content, @Nonnull Writer writer) throws XmlWriterException {
        this.write(XmlWriterRequest.builder().content(content).writer(writer).build());
    }

    public void write(@Nonnull XmlWriterRequest<T> var1) throws XmlWriterException;

    @Nonnull
    default public T fromXmlString(@Nonnull String xml) throws XmlReaderException {
        return this.read(new StringReader(xml));
    }

    @Nonnull
    default public String toXmlString(@Nonnull T content) throws XmlWriterException {
        StringWriter sw = new StringWriter();
        this.write(content, sw);
        return sw.toString();
    }
}

