/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthorityBinding
extends SAMLObject
implements Cloneable {
    protected String binding = null;
    protected String location = null;
    protected QName authorityKind = null;

    public SAMLAuthorityBinding() {
    }

    public SAMLAuthorityBinding(String string, String string2, QName qName) throws SAMLException {
        this.binding = XML.assign(string);
        this.location = XML.assign(string2);
        this.authorityKind = qName;
    }

    public SAMLAuthorityBinding(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAuthorityBinding(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAuthorityBinding.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAuthorityBinding() requires saml:AuthorityBinding at root");
        }
        this.binding = XML.assign(element.getAttributeNS(null, "Binding"));
        this.location = XML.assign(element.getAttributeNS(null, "Location"));
        this.authorityKind = XML.getQNameAttribute(element, null, "AuthorityKind");
        this.checkValidity();
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("binding cannot be null or empty");
        }
        this.binding = string;
        this.setDirty(true);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("location cannot be null or empty");
        }
        this.location = string;
        this.setDirty(true);
    }

    public QName getAuthorityKind() {
        return this.authorityKind;
    }

    public void setAuthorityKind(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("authorityKind cannot be null");
        }
        this.authorityKind = qName;
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            element.setAttributeNS(null, "Binding", this.binding);
            element.setAttributeNS(null, "Location", this.location);
            if (!"urn:oasis:names:tc:SAML:1.0:protocol".equals(this.authorityKind.getNamespaceURI())) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:kind", this.authorityKind.getNamespaceURI());
                element.setAttributeNS(null, "AuthorityKind", "kind:" + this.authorityKind.getLocalPart());
            } else {
                element.setAttributeNS(null, "AuthorityKind", "samlp:" + this.authorityKind.getLocalPart());
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.binding) || XML.isEmpty(this.location) || this.authorityKind == null) {
            throw new MalformedException("AuthorityBinding is invalid, must have Binding, Location, and AuthorityKind");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

