/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLArray;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MLStructure
extends MLArray {
    private Set<String> keys;
    private List<Map<String, MLArray>> mlStructArray;
    private int currentIndex = 0;

    public MLStructure(String name, int[] dims) {
        this(name, dims, 2, 0);
    }

    public MLStructure(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
        this.mlStructArray = new ArrayList<Map<String, MLArray>>(dims[0] * dims[1]);
        this.keys = new LinkedHashSet<String>();
    }

    public void setField(String name, MLArray value) {
        this.setField(name, value, this.currentIndex);
    }

    public void setField(String name, MLArray value, int m, int n) {
        this.setField(name, value, this.getIndex(m, n));
    }

    public void setField(String name, MLArray value, int index) {
        this.keys.add(name);
        this.currentIndex = index;
        if (this.mlStructArray.isEmpty() || this.mlStructArray.size() <= index) {
            this.mlStructArray.add(index, new LinkedHashMap());
        }
        this.mlStructArray.get(index).put(name, value);
    }

    public int getMaxFieldLenth() {
        int maxLen = 0;
        for (String s : this.keys) {
            maxLen = s.length() > maxLen ? s.length() : maxLen;
        }
        return maxLen + 1;
    }

    public byte[] getKeySetToByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        char[] buffer = new char[this.getMaxFieldLenth()];
        try {
            for (String s : this.keys) {
                Arrays.fill(buffer, '\u0000');
                System.arraycopy(s.toCharArray(), 0, buffer, 0, s.length());
                dos.writeBytes(new String(buffer));
            }
        }
        catch (IOException e) {
            System.err.println("Could not write Structure key set to byte array: " + e);
            return new byte[0];
        }
        return baos.toByteArray();
    }

    public Collection<MLArray> getAllFields() {
        ArrayList<MLArray> fields = new ArrayList<MLArray>();
        for (Map<String, MLArray> struct : this.mlStructArray) {
            fields.addAll(struct.values());
        }
        return fields;
    }

    public Collection<String> getFieldNames() {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        fieldNames.addAll(this.keys);
        return fieldNames;
    }

    public MLArray getField(String name) {
        return this.getField(name, this.currentIndex);
    }

    public MLArray getField(String name, int m, int n) {
        return this.getField(name, this.getIndex(m, n));
    }

    public MLArray getField(String name, int index) {
        if (this.mlStructArray.isEmpty()) {
            return null;
        }
        return this.mlStructArray.get(index).get(name);
    }

    @Override
    public String contentToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + " = \n");
        if (this.getM() * this.getN() == 1) {
            for (String key : this.keys) {
                sb.append("\t" + key + " : " + this.getField(key) + "\n");
            }
        } else {
            sb.append("\n");
            sb.append(this.getM() + "x" + this.getN());
            sb.append(" struct array with fields: \n");
            for (String key : this.keys) {
                sb.append("\t" + key + "\n");
            }
        }
        return sb.toString();
    }
}

