/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RTreeNode
extends GeneralEnvelope {
    private static final long serialVersionUID = -6544217991652682694L;
    private RTreeNode parent;
    private RTreeNode firstChild;
    private RTreeNode sibling;

    public RTreeNode(Envelope envelope) {
        super(envelope);
    }

    public final RTreeNode getParent() {
        return this.parent;
    }

    public final List<RTreeNode> getChildren() {
        ArrayList<RTreeNode> arrayList = new ArrayList<RTreeNode>();
        RTreeNode rTreeNode = this.firstChild;
        while (rTreeNode != null) {
            assert (rTreeNode.parent == this) : rTreeNode;
            arrayList.add(rTreeNode);
            rTreeNode = rTreeNode.sibling;
        }
        return arrayList;
    }

    public static void walk(RTreeNode rTreeNode, Consumer<? super RTreeNode> consumer) {
        while (rTreeNode != null) {
            consumer.accept(rTreeNode);
            RTreeNode.walk(rTreeNode.firstChild, consumer);
            rTreeNode = rTreeNode.sibling;
        }
    }

    public final void addNode(RTreeNode rTreeNode) {
        while (rTreeNode != null) {
            RTreeNode rTreeNode2;
            block2: {
                rTreeNode2 = rTreeNode.sibling;
                rTreeNode.sibling = null;
                RTreeNode rTreeNode3 = this;
                do {
                    RTreeNode rTreeNode4 = rTreeNode3;
                    if (rTreeNode3.tryAddChild(rTreeNode)) break block2;
                } while ((rTreeNode3 = rTreeNode3.sibling) != null);
                rTreeNode4.sibling = rTreeNode;
                rTreeNode.parent = this.parent;
            }
            rTreeNode = rTreeNode2;
        }
    }

    private boolean tryAddChild(RTreeNode rTreeNode) {
        assert (rTreeNode.sibling == null) : rTreeNode;
        if (this.contains(rTreeNode)) {
            RTreeNode rTreeNode2 = this.firstChild;
            if (rTreeNode2 == null) {
                this.firstChild = rTreeNode;
            } else {
                do {
                    RTreeNode rTreeNode3 = rTreeNode2;
                    if (!rTreeNode2.tryAddChild(rTreeNode)) continue;
                    return true;
                } while ((rTreeNode2 = rTreeNode2.sibling) != null);
                rTreeNode3.sibling = rTreeNode;
            }
            rTreeNode.parent = this;
            return true;
        }
        return false;
    }

    public final RTreeNode finish() {
        Uniformizer uniformizer = new Uniformizer();
        RTreeNode.walk(this, uniformizer);
        uniformizer.set = true;
        RTreeNode.walk(this, uniformizer);
        RTreeNode rTreeNode = this.sibling;
        if (rTreeNode == null) {
            return this;
        }
        this.parent = new RTreeNode(this);
        this.parent.firstChild = this;
        do {
            this.parent.add(rTreeNode);
            rTreeNode.parent = this.parent;
        } while ((rTreeNode = rTreeNode.sibling) != null);
        return this.parent;
    }

    public static RTreeNode locate(RTreeNode rTreeNode, DirectPosition directPosition) {
        RTreeNode rTreeNode2 = null;
        do {
            if (rTreeNode.contains(directPosition)) {
                RTreeNode rTreeNode3 = rTreeNode.firstChild;
                while (rTreeNode3 != null) {
                    if (rTreeNode3 != rTreeNode2 && rTreeNode3.contains(directPosition)) {
                        rTreeNode = rTreeNode3;
                        rTreeNode3 = rTreeNode.firstChild;
                        continue;
                    }
                    rTreeNode3 = rTreeNode3.sibling;
                }
                return rTreeNode;
            }
            rTreeNode2 = rTreeNode;
        } while ((rTreeNode = rTreeNode.parent) != null);
        return null;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * this.getChildren().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.getChildren().equals(((RTreeNode)object).getChildren());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return "Domain";
    }

    @Override
    public String toString() {
        return this.toTree().toString();
    }

    public final TreeTable toTree() {
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.VALUE);
        this.toTree(defaultTreeTable.getRoot());
        return defaultTreeTable;
    }

    private void toTree(TreeTable.Node node) {
        node.setValue(TableColumn.VALUE, super.toString());
        for (RTreeNode rTreeNode : this.getChildren()) {
            rTreeNode.toTree(node.newChild());
        }
    }

    private static final class Uniformizer
    implements Consumer<RTreeNode> {
        private CoordinateReferenceSystem common;
        boolean set;

        private Uniformizer() {
        }

        @Override
        public void accept(RTreeNode rTreeNode) {
            if (this.set) {
                rTreeNode.setCoordinateReferenceSystem(this.common);
            } else {
                CoordinateReferenceSystem coordinateReferenceSystem = rTreeNode.getCoordinateReferenceSystem();
                if (this.common == null) {
                    this.common = coordinateReferenceSystem;
                } else if (coordinateReferenceSystem != null && !Utilities.equalsIgnoreMetadata(this.common, coordinateReferenceSystem)) {
                    throw new MismatchedReferenceSystemException(Errors.format((short)78));
                }
            }
        }
    }
}

