﻿// Lucene version compatibility level 4.8.1
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class ItalianStemmer : SnowballProgram
    {
        // LUCENENET specific: Factored out methodObject by using Func<bool> instead of Reflection

        private readonly static Among[] a_0 = {
                    new Among ( "", -1, 7 ),
                    new Among ( "qu", 0, 6 ),
                    new Among ( "\u00E1", 0, 1 ),
                    new Among ( "\u00E9", 0, 2 ),
                    new Among ( "\u00ED", 0, 3 ),
                    new Among ( "\u00F3", 0, 4 ),
                    new Among ( "\u00FA", 0, 5 )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "", -1, 3 ),
                    new Among ( "I", 0, 1 ),
                    new Among ( "U", 0, 2 )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "la", -1, -1 ),
                    new Among ( "cela", 0, -1 ),
                    new Among ( "gliela", 0, -1 ),
                    new Among ( "mela", 0, -1 ),
                    new Among ( "tela", 0, -1 ),
                    new Among ( "vela", 0, -1 ),
                    new Among ( "le", -1, -1 ),
                    new Among ( "cele", 6, -1 ),
                    new Among ( "gliele", 6, -1 ),
                    new Among ( "mele", 6, -1 ),
                    new Among ( "tele", 6, -1 ),
                    new Among ( "vele", 6, -1 ),
                    new Among ( "ne", -1, -1 ),
                    new Among ( "cene", 12, -1 ),
                    new Among ( "gliene", 12, -1 ),
                    new Among ( "mene", 12, -1 ),
                    new Among ( "sene", 12, -1 ),
                    new Among ( "tene", 12, -1 ),
                    new Among ( "vene", 12, -1 ),
                    new Among ( "ci", -1, -1 ),
                    new Among ( "li", -1, -1 ),
                    new Among ( "celi", 20, -1 ),
                    new Among ( "glieli", 20, -1 ),
                    new Among ( "meli", 20, -1 ),
                    new Among ( "teli", 20, -1 ),
                    new Among ( "veli", 20, -1 ),
                    new Among ( "gli", 20, -1 ),
                    new Among ( "mi", -1, -1 ),
                    new Among ( "si", -1, -1 ),
                    new Among ( "ti", -1, -1 ),
                    new Among ( "vi", -1, -1 ),
                    new Among ( "lo", -1, -1 ),
                    new Among ( "celo", 31, -1 ),
                    new Among ( "glielo", 31, -1 ),
                    new Among ( "melo", 31, -1 ),
                    new Among ( "telo", 31, -1 ),
                    new Among ( "velo", 31, -1 )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "ando", -1, 1 ),
                    new Among ( "endo", -1, 1 ),
                    new Among ( "ar", -1, 2 ),
                    new Among ( "er", -1, 2 ),
                    new Among ( "ir", -1, 2 )
                };

        private readonly static Among[] a_4 = {
                    new Among ( "ic", -1, -1 ),
                    new Among ( "abil", -1, -1 ),
                    new Among ( "os", -1, -1 ),
                    new Among ( "iv", -1, 1 )
                };

        private readonly static Among[] a_5 = {
                    new Among ( "ic", -1, 1 ),
                    new Among ( "abil", -1, 1 ),
                    new Among ( "iv", -1, 1 )
                };

        private readonly static Among[] a_6 = {
                    new Among ( "ica", -1, 1 ),
                    new Among ( "logia", -1, 3 ),
                    new Among ( "osa", -1, 1 ),
                    new Among ( "ista", -1, 1 ),
                    new Among ( "iva", -1, 9 ),
                    new Among ( "anza", -1, 1 ),
                    new Among ( "enza", -1, 5 ),
                    new Among ( "ice", -1, 1 ),
                    new Among ( "atrice", 7, 1 ),
                    new Among ( "iche", -1, 1 ),
                    new Among ( "logie", -1, 3 ),
                    new Among ( "abile", -1, 1 ),
                    new Among ( "ibile", -1, 1 ),
                    new Among ( "usione", -1, 4 ),
                    new Among ( "azione", -1, 2 ),
                    new Among ( "uzione", -1, 4 ),
                    new Among ( "atore", -1, 2 ),
                    new Among ( "ose", -1, 1 ),
                    new Among ( "ante", -1, 1 ),
                    new Among ( "mente", -1, 1 ),
                    new Among ( "amente", 19, 7 ),
                    new Among ( "iste", -1, 1 ),
                    new Among ( "ive", -1, 9 ),
                    new Among ( "anze", -1, 1 ),
                    new Among ( "enze", -1, 5 ),
                    new Among ( "ici", -1, 1 ),
                    new Among ( "atrici", 25, 1 ),
                    new Among ( "ichi", -1, 1 ),
                    new Among ( "abili", -1, 1 ),
                    new Among ( "ibili", -1, 1 ),
                    new Among ( "ismi", -1, 1 ),
                    new Among ( "usioni", -1, 4 ),
                    new Among ( "azioni", -1, 2 ),
                    new Among ( "uzioni", -1, 4 ),
                    new Among ( "atori", -1, 2 ),
                    new Among ( "osi", -1, 1 ),
                    new Among ( "anti", -1, 1 ),
                    new Among ( "amenti", -1, 6 ),
                    new Among ( "imenti", -1, 6 ),
                    new Among ( "isti", -1, 1 ),
                    new Among ( "ivi", -1, 9 ),
                    new Among ( "ico", -1, 1 ),
                    new Among ( "ismo", -1, 1 ),
                    new Among ( "oso", -1, 1 ),
                    new Among ( "amento", -1, 6 ),
                    new Among ( "imento", -1, 6 ),
                    new Among ( "ivo", -1, 9 ),
                    new Among ( "it\u00E0", -1, 8 ),
                    new Among ( "ist\u00E0", -1, 1 ),
                    new Among ( "ist\u00E8", -1, 1 ),
                    new Among ( "ist\u00EC", -1, 1 )
                };

        private readonly static Among[] a_7 = {
                    new Among ( "isca", -1, 1 ),
                    new Among ( "enda", -1, 1 ),
                    new Among ( "ata", -1, 1 ),
                    new Among ( "ita", -1, 1 ),
                    new Among ( "uta", -1, 1 ),
                    new Among ( "ava", -1, 1 ),
                    new Among ( "eva", -1, 1 ),
                    new Among ( "iva", -1, 1 ),
                    new Among ( "erebbe", -1, 1 ),
                    new Among ( "irebbe", -1, 1 ),
                    new Among ( "isce", -1, 1 ),
                    new Among ( "ende", -1, 1 ),
                    new Among ( "are", -1, 1 ),
                    new Among ( "ere", -1, 1 ),
                    new Among ( "ire", -1, 1 ),
                    new Among ( "asse", -1, 1 ),
                    new Among ( "ate", -1, 1 ),
                    new Among ( "avate", 16, 1 ),
                    new Among ( "evate", 16, 1 ),
                    new Among ( "ivate", 16, 1 ),
                    new Among ( "ete", -1, 1 ),
                    new Among ( "erete", 20, 1 ),
                    new Among ( "irete", 20, 1 ),
                    new Among ( "ite", -1, 1 ),
                    new Among ( "ereste", -1, 1 ),
                    new Among ( "ireste", -1, 1 ),
                    new Among ( "ute", -1, 1 ),
                    new Among ( "erai", -1, 1 ),
                    new Among ( "irai", -1, 1 ),
                    new Among ( "isci", -1, 1 ),
                    new Among ( "endi", -1, 1 ),
                    new Among ( "erei", -1, 1 ),
                    new Among ( "irei", -1, 1 ),
                    new Among ( "assi", -1, 1 ),
                    new Among ( "ati", -1, 1 ),
                    new Among ( "iti", -1, 1 ),
                    new Among ( "eresti", -1, 1 ),
                    new Among ( "iresti", -1, 1 ),
                    new Among ( "uti", -1, 1 ),
                    new Among ( "avi", -1, 1 ),
                    new Among ( "evi", -1, 1 ),
                    new Among ( "ivi", -1, 1 ),
                    new Among ( "isco", -1, 1 ),
                    new Among ( "ando", -1, 1 ),
                    new Among ( "endo", -1, 1 ),
                    new Among ( "Yamo", -1, 1 ),
                    new Among ( "iamo", -1, 1 ),
                    new Among ( "avamo", -1, 1 ),
                    new Among ( "evamo", -1, 1 ),
                    new Among ( "ivamo", -1, 1 ),
                    new Among ( "eremo", -1, 1 ),
                    new Among ( "iremo", -1, 1 ),
                    new Among ( "assimo", -1, 1 ),
                    new Among ( "ammo", -1, 1 ),
                    new Among ( "emmo", -1, 1 ),
                    new Among ( "eremmo", 54, 1 ),
                    new Among ( "iremmo", 54, 1 ),
                    new Among ( "immo", -1, 1 ),
                    new Among ( "ano", -1, 1 ),
                    new Among ( "iscano", 58, 1 ),
                    new Among ( "avano", 58, 1 ),
                    new Among ( "evano", 58, 1 ),
                    new Among ( "ivano", 58, 1 ),
                    new Among ( "eranno", -1, 1 ),
                    new Among ( "iranno", -1, 1 ),
                    new Among ( "ono", -1, 1 ),
                    new Among ( "iscono", 65, 1 ),
                    new Among ( "arono", 65, 1 ),
                    new Among ( "erono", 65, 1 ),
                    new Among ( "irono", 65, 1 ),
                    new Among ( "erebbero", -1, 1 ),
                    new Among ( "irebbero", -1, 1 ),
                    new Among ( "assero", -1, 1 ),
                    new Among ( "essero", -1, 1 ),
                    new Among ( "issero", -1, 1 ),
                    new Among ( "ato", -1, 1 ),
                    new Among ( "ito", -1, 1 ),
                    new Among ( "uto", -1, 1 ),
                    new Among ( "avo", -1, 1 ),
                    new Among ( "evo", -1, 1 ),
                    new Among ( "ivo", -1, 1 ),
                    new Among ( "ar", -1, 1 ),
                    new Among ( "ir", -1, 1 ),
                    new Among ( "er\u00E0", -1, 1 ),
                    new Among ( "ir\u00E0", -1, 1 ),
                    new Among ( "er\u00F2", -1, 1 ),
                    new Among ( "ir\u00F2", -1, 1 )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)128, (char)128, (char)8, (char)2, (char)1 };

        private static readonly char[] g_AEIO = { (char)17, (char)65, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)128, (char)128, (char)8, (char)2 };

        private static readonly char[] g_CG = { (char)17 };

        private int I_p2;
        private int I_p1;
        private int I_pV;

        private void copy_from(ItalianStemmer other)
        {
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            I_pV = other.I_pV;
            base.CopyFrom(other);
        }

        private bool r_prelude()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            // (, line 34
            // test, line 35
            v_1 = m_cursor;
            // repeat, line 35
            while (true)
            {
                v_2 = m_cursor;
                do
                {
                    // (, line 35
                    // [, line 36
                    m_bra = m_cursor;
                    // substring, line 36
                    among_var = FindAmong(a_0, 7);
                    if (among_var == 0)
                    {
                        goto lab1;
                    }
                    // ], line 36
                    m_ket = m_cursor;
                    switch (among_var)
                    {
                        case 0:
                            goto lab1;
                        case 1:
                            // (, line 37
                            // <-, line 37
                            SliceFrom("\u00E0");
                            break;
                        case 2:
                            // (, line 38
                            // <-, line 38
                            SliceFrom("\u00E8");
                            break;
                        case 3:
                            // (, line 39
                            // <-, line 39
                            SliceFrom("\u00EC");
                            break;
                        case 4:
                            // (, line 40
                            // <-, line 40
                            SliceFrom("\u00F2");
                            break;
                        case 5:
                            // (, line 41
                            // <-, line 41
                            SliceFrom("\u00F9");
                            break;
                        case 6:
                            // (, line 42
                            // <-, line 42
                            SliceFrom("qU");
                            break;
                        case 7:
                            // (, line 43
                            // next, line 43
                            if (m_cursor >= m_limit)
                            {
                                goto lab1;
                            }
                            m_cursor++;
                            break;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;

                } while (false);
                lab1:
                m_cursor = v_2;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            m_cursor = v_1;
            // repeat, line 46
            while (true)
            {
                v_3 = m_cursor;
                do
                {
                    // goto, line 46
                    while (true)
                    {
                        v_4 = m_cursor;
                        do
                        {
                            // (, line 46
                            if (!(InGrouping(g_v, 97, 249)))
                            {
                                goto lab5;
                            }
                            // [, line 47
                            m_bra = m_cursor;
                            // or, line 47
                            do
                            {
                                v_5 = m_cursor;
                                do
                                {
                                    // (, line 47
                                    // literal, line 47
                                    if (!(Eq_S(1, "u")))
                                    {
                                        goto lab7;
                                    }
                                    // ], line 47
                                    m_ket = m_cursor;
                                    if (!(InGrouping(g_v, 97, 249)))
                                    {
                                        goto lab7;
                                    }
                                    // <-, line 47
                                    SliceFrom("U");
                                    goto lab6;
                                } while (false);
                                lab7:
                                m_cursor = v_5;
                                // (, line 48
                                // literal, line 48
                                if (!(Eq_S(1, "i")))
                                {
                                    goto lab5;
                                }
                                // ], line 48
                                m_ket = m_cursor;
                                if (!(InGrouping(g_v, 97, 249)))
                                {
                                    goto lab5;
                                }
                                // <-, line 48
                                SliceFrom("I");
                            } while (false);
                            lab6:
                            m_cursor = v_4;
                            goto golab4;
                        } while (false);
                        lab5:
                        m_cursor = v_4;
                        if (m_cursor >= m_limit)
                        {
                            goto lab3;
                        }
                        m_cursor++;
                    }
                    golab4:
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab2;

                    goto end_of_outer_loop_2;

                } while (false);
                lab3:
                m_cursor = v_3;
                goto replab2;
                end_of_outer_loop_2: { }
            }
            replab2:
            return true;
        }

        private bool r_mark_regions()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_6;
            int v_8;
            // (, line 52
            I_pV = m_limit;
            I_p1 = m_limit;
            I_p2 = m_limit;
            // do, line 58
            v_1 = m_cursor;
            do
            {
                // (, line 58
                // or, line 60
                do
                {
                    v_2 = m_cursor;
                    do
                    {
                        // (, line 59
                        if (!(InGrouping(g_v, 97, 249)))
                        {
                            goto lab2;
                        }
                        // or, line 59
                        do
                        {
                            v_3 = m_cursor;
                            do
                            {
                                // (, line 59
                                if (!(OutGrouping(g_v, 97, 249)))
                                {
                                    goto lab4;
                                }
                                // gopast, line 59
                                while (true)
                                {
                                    do
                                    {
                                        if (!(InGrouping(g_v, 97, 249)))
                                        {
                                            goto lab6;
                                        }
                                        goto golab5;
                                    } while (false);
                                    lab6:
                                    if (m_cursor >= m_limit)
                                    {
                                        goto lab4;
                                    }
                                    m_cursor++;
                                }
                                golab5:
                                goto lab3;
                            } while (false);
                            lab4:
                            m_cursor = v_3;
                            // (, line 59
                            if (!(InGrouping(g_v, 97, 249)))
                            {
                                goto lab2;
                            }
                            // gopast, line 59
                            while (true)
                            {
                                do
                                {
                                    if (!(OutGrouping(g_v, 97, 249)))
                                    {
                                        goto lab8;
                                    }
                                    goto golab7;
                                } while (false);
                                lab8:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab2;
                                }
                                m_cursor++;
                            }
                            golab7:;
                        } while (false);
                        lab3:
                        goto lab1;
                    } while (false);
                    lab2:
                    m_cursor = v_2;
                    // (, line 61
                    if (!(OutGrouping(g_v, 97, 249)))
                    {
                        goto lab0;
                    }
                    // or, line 61
                    do
                    {
                        v_6 = m_cursor;
                        do
                        {
                            // (, line 61
                            if (!(OutGrouping(g_v, 97, 249)))
                            {
                                goto lab10;
                            }
                            // gopast, line 61
                            while (true)
                            {
                                do
                                {
                                    if (!(InGrouping(g_v, 97, 249)))
                                    {
                                        goto lab12;
                                    }
                                    goto golab11;
                                } while (false);
                                lab12:
                                if (m_cursor >= m_limit)
                                {
                                    goto lab10;
                                }
                                m_cursor++;
                            }
                            golab11:
                            goto lab9;
                        } while (false);
                        lab10:
                        m_cursor = v_6;
                        // (, line 61
                        if (!(InGrouping(g_v, 97, 249)))
                        {
                            goto lab0;
                        }
                        // next, line 61
                        if (m_cursor >= m_limit)
                        {
                            goto lab0;
                        }
                        m_cursor++;
                    } while (false);
                    lab9:;
                } while (false);
                lab1:
                // setmark pV, line 62
                I_pV = m_cursor;
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 64
            v_8 = m_cursor;
            do
            {
                // (, line 64
                // gopast, line 65
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 97, 249)))
                        {
                            goto lab15;
                        }
                        goto golab14;
                    } while (false);
                    lab15:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab14:
                // gopast, line 65
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 249)))
                        {
                            goto lab17;
                        }
                        goto golab16;
                    } while (false);
                    lab17:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab16:
                // setmark p1, line 65
                I_p1 = m_cursor;
                // gopast, line 66
                while (true)
                {
                    do
                    {
                        if (!(InGrouping(g_v, 97, 249)))
                        {
                            goto lab19;
                        }
                        goto golab18;
                    } while (false);
                    lab19:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab18:
                // gopast, line 66
                while (true)
                {
                    do
                    {
                        if (!(OutGrouping(g_v, 97, 249)))
                        {
                            goto lab21;
                        }
                        goto golab20;
                    } while (false);
                    lab21:
                    if (m_cursor >= m_limit)
                    {
                        goto lab13;
                    }
                    m_cursor++;
                }
                golab20:
                // setmark p2, line 66
                I_p2 = m_cursor;
            } while (false);
            lab13:
            m_cursor = v_8;
            return true;
        }

        private bool r_postlude()
        {
            int among_var;
            int v_1;
            // repeat, line 70
            while (true)
            {
                v_1 = m_cursor;
                do
                {
                    // (, line 70
                    // [, line 72
                    m_bra = m_cursor;
                    // substring, line 72
                    among_var = FindAmong(a_1, 3);
                    if (among_var == 0)
                    {
                        goto lab1;
                    }
                    // ], line 72
                    m_ket = m_cursor;
                    switch (among_var)
                    {
                        case 0:
                            goto lab1;
                        case 1:
                            // (, line 73
                            // <-, line 73
                            SliceFrom("i");
                            break;
                        case 2:
                            // (, line 74
                            // <-, line 74
                            SliceFrom("u");
                            break;
                        case 3:
                            // (, line 75
                            // next, line 75
                            if (m_cursor >= m_limit)
                            {
                                goto lab1;
                            }
                            m_cursor++;
                            break;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;

                } while (false);
                lab1:
                m_cursor = v_1;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            return true;
        }

        private bool r_RV()
        {
            if (!(I_pV <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R1()
        {
            if (!(I_p1 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_attached_pronoun()
        {
            int among_var;
            // (, line 86
            // [, line 87
            m_ket = m_cursor;
            // substring, line 87
            if (FindAmongB(a_2, 37) == 0)
            {
                return false;
            }
            // ], line 87
            m_bra = m_cursor;
            // among, line 97
            among_var = FindAmongB(a_3, 5);
            if (among_var == 0)
            {
                return false;
            }
            // (, line 97
            // call RV, line 97
            if (!r_RV())
            {
                return false;
            }
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 98
                    // delete, line 98
                    SliceDel();
                    break;
                case 2:
                    // (, line 99
                    // <-, line 99
                    SliceFrom("e");
                    break;
            }
            return true;
        }

        private bool r_standard_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            // (, line 103
            // [, line 104
            m_ket = m_cursor;
            // substring, line 104
            among_var = FindAmongB(a_6, 51);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 104
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 111
                    // call R2, line 111
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 111
                    SliceDel();
                    break;
                case 2:
                    // (, line 113
                    // call R2, line 113
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 113
                    SliceDel();
                    // try, line 114
                    v_1 = m_limit - m_cursor;
                    do
                    {
                        // (, line 114
                        // [, line 114
                        m_ket = m_cursor;
                        // literal, line 114
                        if (!(Eq_S_B(2, "ic")))
                        {
                            m_cursor = m_limit - v_1;
                            goto lab0;
                        }
                        // ], line 114
                        m_bra = m_cursor;
                        // call R2, line 114
                        if (!r_R2())
                        {
                            m_cursor = m_limit - v_1;
                            goto lab0;
                        }
                        // delete, line 114
                        SliceDel();
                    } while (false);
                    lab0:
                    break;
                case 3:
                    // (, line 117
                    // call R2, line 117
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 117
                    SliceFrom("log");
                    break;
                case 4:
                    // (, line 119
                    // call R2, line 119
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 119
                    SliceFrom("u");
                    break;
                case 5:
                    // (, line 121
                    // call R2, line 121
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 121
                    SliceFrom("ente");
                    break;
                case 6:
                    // (, line 123
                    // call RV, line 123
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 123
                    SliceDel();
                    break;
                case 7:
                    // (, line 124
                    // call R1, line 125
                    if (!r_R1())
                    {
                        return false;
                    }
                    // delete, line 125
                    SliceDel();
                    // try, line 126
                    v_2 = m_limit - m_cursor;
                    do
                    {
                        // (, line 126
                        // [, line 127
                        m_ket = m_cursor;
                        // substring, line 127
                        among_var = FindAmongB(a_4, 4);
                        if (among_var == 0)
                        {
                            m_cursor = m_limit - v_2;
                            goto lab1;
                        }
                        // ], line 127
                        m_bra = m_cursor;
                        // call R2, line 127
                        if (!r_R2())
                        {
                            m_cursor = m_limit - v_2;
                            goto lab1;
                        }
                        // delete, line 127
                        SliceDel();
                        switch (among_var)
                        {
                            case 0:
                                m_cursor = m_limit - v_2;
                                goto lab1;
                            case 1:
                                // (, line 128
                                // [, line 128
                                m_ket = m_cursor;
                                // literal, line 128
                                if (!(Eq_S_B(2, "at")))
                                {
                                    m_cursor = m_limit - v_2;
                                    goto lab1;
                                }
                                // ], line 128
                                m_bra = m_cursor;
                                // call R2, line 128
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_2;
                                    goto lab1;
                                }
                                // delete, line 128
                                SliceDel();
                                break;
                        }
                    } while (false);
                    lab1:
                    break;
                case 8:
                    // (, line 133
                    // call R2, line 134
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 134
                    SliceDel();
                    // try, line 135
                    v_3 = m_limit - m_cursor;
                    do
                    {
                        // (, line 135
                        // [, line 136
                        m_ket = m_cursor;
                        // substring, line 136
                        among_var = FindAmongB(a_5, 3);
                        if (among_var == 0)
                        {
                            m_cursor = m_limit - v_3;
                            goto lab2;
                        }
                        // ], line 136
                        m_bra = m_cursor;
                        switch (among_var)
                        {
                            case 0:
                                m_cursor = m_limit - v_3;
                                goto lab2;
                            case 1:
                                // (, line 137
                                // call R2, line 137
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_3;
                                    goto lab2;
                                }
                                // delete, line 137
                                SliceDel();
                                break;
                        }
                    } while (false);
                    lab2:
                    break;
                case 9:
                    // (, line 141
                    // call R2, line 142
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 142
                    SliceDel();
                    // try, line 143
                    v_4 = m_limit - m_cursor;
                    do
                    {
                        // (, line 143
                        // [, line 143
                        m_ket = m_cursor;
                        // literal, line 143
                        if (!(Eq_S_B(2, "at")))
                        {
                            m_cursor = m_limit - v_4;
                            goto lab3;
                        }
                        // ], line 143
                        m_bra = m_cursor;
                        // call R2, line 143
                        if (!r_R2())
                        {
                            m_cursor = m_limit - v_4;
                            goto lab3;
                        }
                        // delete, line 143
                        SliceDel();
                        // [, line 143
                        m_ket = m_cursor;
                        // literal, line 143
                        if (!(Eq_S_B(2, "ic")))
                        {
                            m_cursor = m_limit - v_4;
                            goto lab3;
                        }
                        // ], line 143
                        m_bra = m_cursor;
                        // call R2, line 143
                        if (!r_R2())
                        {
                            m_cursor = m_limit - v_4;
                            goto lab3;
                        }
                        // delete, line 143
                        SliceDel();
                    } while (false);
                    lab3:
                    break;
            }
            return true;
        }

        private bool r_verb_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            // setlimit, line 148
            v_1 = m_limit - m_cursor;
            // tomark, line 148
            if (m_cursor < I_pV)
            {
                return false;
            }
            m_cursor = I_pV;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 148
            // [, line 149
            m_ket = m_cursor;
            // substring, line 149
            among_var = FindAmongB(a_7, 87);
            if (among_var == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            // ], line 149
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    m_limit_backward = v_2;
                    return false;
                case 1:
                    // (, line 163
                    // delete, line 163
                    SliceDel();
                    break;
            }
            m_limit_backward = v_2;
            return true;
        }

        private bool r_vowel_suffix()
        {
            int v_1;
            int v_2;
            // (, line 170
            // try, line 171
            v_1 = m_limit - m_cursor;
            do
            {
                // (, line 171
                // [, line 172
                m_ket = m_cursor;
                if (!(InGroupingB(g_AEIO, 97, 242)))
                {
                    m_cursor = m_limit - v_1;
                    goto lab0;
                }
                // ], line 172
                m_bra = m_cursor;
                // call RV, line 172
                if (!r_RV())
                {
                    m_cursor = m_limit - v_1;
                    goto lab0;
                }
                // delete, line 172
                SliceDel();
                // [, line 173
                m_ket = m_cursor;
                // literal, line 173
                if (!(Eq_S_B(1, "i")))
                {
                    m_cursor = m_limit - v_1;
                    goto lab0;
                }
                // ], line 173
                m_bra = m_cursor;
                // call RV, line 173
                if (!r_RV())
                {
                    m_cursor = m_limit - v_1;
                    goto lab0;
                }
                // delete, line 173
                SliceDel();
            } while (false);
            lab0:
            // try, line 175
            v_2 = m_limit - m_cursor;
            do
            {
                // (, line 175
                // [, line 176
                m_ket = m_cursor;
                // literal, line 176
                if (!(Eq_S_B(1, "h")))
                {
                    m_cursor = m_limit - v_2;
                    goto lab1;
                }
                // ], line 176
                m_bra = m_cursor;
                if (!(InGroupingB(g_CG, 99, 103)))
                {
                    m_cursor = m_limit - v_2;
                    goto lab1;
                }
                // call RV, line 176
                if (!r_RV())
                {
                    m_cursor = m_limit - v_2;
                    goto lab1;
                }
                // delete, line 176
                SliceDel();
            } while (false);
            lab1:
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            // (, line 181
            // do, line 182
            v_1 = m_cursor;
            do
            {
                // call prelude, line 182
                if (!r_prelude())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 183
            v_2 = m_cursor;
            do
            {
                // call mark_regions, line 183
                if (!r_mark_regions())
                {
                    goto lab1;
                }
            } while (false);
            lab1:
            m_cursor = v_2;
            // backwards, line 184
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 184
            // do, line 185
            v_3 = m_limit - m_cursor;
            do
            {
                // call attached_pronoun, line 185
                if (!r_attached_pronoun())
                {
                    goto lab2;
                }
            } while (false);
            lab2:
            m_cursor = m_limit - v_3;
            // do, line 186
            v_4 = m_limit - m_cursor;
            do
            {
                // (, line 186
                // or, line 186
                do
                {
                    v_5 = m_limit - m_cursor;
                    do
                    {
                        // call standard_suffix, line 186
                        if (!r_standard_suffix())
                        {
                            goto lab5;
                        }
                        goto lab4;
                    } while (false);
                    lab5:
                    m_cursor = m_limit - v_5;
                    // call verb_suffix, line 186
                    if (!r_verb_suffix())
                    {
                        goto lab3;
                    }
                } while (false);
                lab4:;
            } while (false);
            lab3:
            m_cursor = m_limit - v_4;
            // do, line 187
            v_6 = m_limit - m_cursor;
            do
            {
                // call vowel_suffix, line 187
                if (!r_vowel_suffix())
                {
                    goto lab6;
                }
            } while (false);
            lab6:
            m_cursor = m_limit - v_6;
            m_cursor = m_limit_backward;                    // do, line 189
            v_7 = m_cursor;
            do
            {
                // call postlude, line 189
                if (!r_postlude())
                {
                    goto lab7;
                }
            } while (false);
            lab7:
            m_cursor = v_7;
            return true;
        }


        public override bool Equals(object o)
        {
            return o is ItalianStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}