/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AttributeException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Detail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Model;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ModelList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ModelMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PathException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Policy;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.TextException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.TreeModel$OrderList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

class TreeModel
implements Model {
    private Expression expression;
    private LabelMap attributes;
    private LabelMap elements;
    private ModelMap models;
    private TreeModel$OrderList order;
    private Policy policy;
    private Detail detail;
    private String name;
    private String prefix;
    private Label text;
    private Label list;
    private int index;

    public TreeModel(Policy policy, Detail detail) {
        this(policy, detail, null, null, 1);
    }

    public TreeModel(Policy policy, Detail detail, String string, String string2, int n) {
        this.attributes = new LabelMap(policy);
        this.elements = new LabelMap(policy);
        this.models = new ModelMap(detail);
        this.order = new TreeModel$OrderList();
        this.detail = detail;
        this.policy = policy;
        this.prefix = string2;
        this.index = n;
        this.name = string;
    }

    @Override
    public Model lookup(Expression expression) {
        String string = expression.getFirst();
        int n = expression.getIndex();
        Model model = this.lookup(string, n);
        if (expression.isPath()) {
            expression = expression.getPath(1, 0);
            if (model != null) {
                return model.lookup(expression);
            }
        }
        return model;
    }

    @Override
    public void registerElement(String string) {
        if (!this.order.contains(string)) {
            this.order.add(string);
        }
        this.elements.put(string, null);
    }

    @Override
    public void registerAttribute(String string) {
        this.attributes.put(string, null);
    }

    @Override
    public void registerText(Label label) {
        if (this.text != null) {
            throw new TextException("Duplicate text annotation on %s", label);
        }
        this.text = label;
    }

    @Override
    public void registerAttribute(Label label) {
        String string = label.getName();
        if (this.attributes.get(string) != null) {
            throw new AttributeException("Duplicate annotation of name '%s' on %s", string, label);
        }
        this.attributes.put(string, label);
    }

    @Override
    public void registerElement(Label label) {
        String string = label.getName();
        if (this.elements.get(string) != null) {
            throw new ElementException("Duplicate annotation of name '%s' on %s", string, label);
        }
        if (!this.order.contains(string)) {
            this.order.add(string);
        }
        if (label.isTextList()) {
            this.list = label;
        }
        this.elements.put(string, label);
    }

    @Override
    public ModelMap getModels() {
        return this.models.getModels();
    }

    @Override
    public LabelMap getAttributes() {
        return this.attributes.getLabels();
    }

    @Override
    public LabelMap getElements() {
        return this.elements.getLabels();
    }

    @Override
    public boolean isModel(String string) {
        return this.models.containsKey(string);
    }

    @Override
    public boolean isElement(String string) {
        return this.elements.containsKey(string);
    }

    @Override
    public boolean isAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public Iterator iterator() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.order) {
            arrayList.add(string);
        }
        return arrayList.iterator();
    }

    @Override
    public void validate(Class clazz) {
        this.validateExpressions(clazz);
        this.validateAttributes(clazz);
        this.validateElements(clazz);
        this.validateModels(clazz);
        this.validateText(clazz);
    }

    private void validateText(Class clazz) {
        if (this.text != null) {
            if (!this.elements.isEmpty()) {
                throw new TextException("Text annotation %s used with elements in %s", this.text, clazz);
            }
            if (this.isComposite()) {
                throw new TextException("Text annotation %s can not be used with paths in %s", this.text, clazz);
            }
        }
    }

    private void validateExpressions(Class clazz) {
        for (Label label : this.elements) {
            if (label == null) continue;
            this.validateExpression(label);
        }
        for (Label label : this.attributes) {
            if (label == null) continue;
            this.validateExpression(label);
        }
        if (this.text != null) {
            this.validateExpression(this.text);
        }
    }

    private void validateExpression(Label label) {
        Expression expression = label.getExpression();
        if (this.expression != null) {
            String string;
            String string2 = this.expression.getPath();
            if (!string2.equals(string = expression.getPath())) {
                throw new PathException("Path '%s' does not match '%s' in %s", string2, string, this.detail);
            }
        } else {
            this.expression = expression;
        }
    }

    private void validateModels(Class clazz) {
        for (ModelList modelList : this.models) {
            int n = 1;
            for (Model model : modelList) {
                if (model == null) continue;
                String string = model.getName();
                int n2 = model.getIndex();
                if (n2 != n++) {
                    throw new ElementException("Path section '%s[%s]' is out of sequence in %s", string, n2, clazz);
                }
                model.validate(clazz);
            }
        }
    }

    private void validateAttributes(Class clazz) {
        Set set = this.attributes.keySet();
        for (String string : set) {
            Label label = (Label)this.attributes.get(string);
            if (label == null) {
                throw new AttributeException("Ordered attribute '%s' does not exist in %s", string, clazz);
            }
            if (this.expression == null) continue;
            this.expression.getAttribute(string);
        }
    }

    private void validateElements(Class clazz) {
        Set set = this.elements.keySet();
        for (String string : set) {
            ModelList modelList = (ModelList)this.models.get(string);
            Label label = (Label)this.elements.get(string);
            if (modelList == null && label == null) {
                throw new ElementException("Ordered element '%s' does not exist in %s", string, clazz);
            }
            if (modelList != null && label != null && !modelList.isEmpty()) {
                throw new ElementException("Element '%s' is also a path name in %s", string, clazz);
            }
            if (this.expression == null) continue;
            this.expression.getElement(string);
        }
    }

    @Override
    public void register(Label label) {
        if (label.isAttribute()) {
            this.registerAttribute(label);
        } else if (label.isText()) {
            this.registerText(label);
        } else {
            this.registerElement(label);
        }
    }

    @Override
    public Model lookup(String string, int n) {
        return this.models.lookup(string, n);
    }

    @Override
    public Model register(String string, String string2, int n) {
        Model model = this.models.lookup(string, n);
        if (model == null) {
            return this.create(string, string2, n);
        }
        return model;
    }

    private Model create(String string, String string2, int n) {
        TreeModel treeModel = new TreeModel(this.policy, this.detail, string, string2, n);
        if (string != null) {
            this.models.register(string, treeModel);
            this.order.add(string);
        }
        return treeModel;
    }

    @Override
    public boolean isComposite() {
        for (ModelList modelList : this.models) {
            for (Model model : modelList) {
                if (model == null || model.isEmpty()) continue;
                return true;
            }
        }
        return !this.models.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        if (this.text != null) {
            return false;
        }
        if (!this.elements.isEmpty()) {
            return false;
        }
        if (!this.attributes.isEmpty()) {
            return false;
        }
        return !this.isComposite();
    }

    @Override
    public Label getText() {
        if (this.list != null) {
            return this.list;
        }
        return this.text;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return String.format("model '%s[%s]'", this.name, this.index);
    }
}

