/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AnnotationFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Detail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.GetPart;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodName;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodPart;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Reflector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.SetPart;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Support;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

class MethodPartFactory {
    private final AnnotationFactory factory;

    public MethodPartFactory(Detail detail, Support support) {
        this.factory = new AnnotationFactory(detail, support);
    }

    public MethodPart getInstance(Method method, Annotation[] annotationArray) {
        Annotation annotation = this.getAnnotation(method);
        if (annotation != null) {
            return this.getInstance(method, annotation, annotationArray);
        }
        return null;
    }

    public MethodPart getInstance(Method method, Annotation annotation, Annotation[] annotationArray) {
        MethodName methodName = this.getName(method, annotation);
        MethodType methodType = methodName.getType();
        if (methodType == MethodType.SET) {
            return new SetPart(methodName, annotation, annotationArray);
        }
        return new GetPart(methodName, annotation, annotationArray);
    }

    private MethodName getName(Method method, Annotation annotation) {
        MethodType methodType = this.getMethodType(method);
        if (methodType == MethodType.GET) {
            return this.getRead(method, methodType);
        }
        if (methodType == MethodType.IS) {
            return this.getRead(method, methodType);
        }
        if (methodType == MethodType.SET) {
            return this.getWrite(method, methodType);
        }
        throw new MethodException("Annotation %s must mark a set or get method", annotation);
    }

    private MethodType getMethodType(Method method) {
        String string = method.getName();
        if (string.startsWith("get")) {
            return MethodType.GET;
        }
        if (string.startsWith("is")) {
            return MethodType.IS;
        }
        if (string.startsWith("set")) {
            return MethodType.SET;
        }
        return MethodType.NONE;
    }

    private Annotation getAnnotation(Method method) {
        Class[] classArray = this.getDependents(method);
        Class clazz = this.getType(method);
        if (clazz != null) {
            return this.factory.getInstance(clazz, classArray);
        }
        return null;
    }

    private Class[] getDependents(Method method) {
        MethodType methodType = this.getMethodType(method);
        if (methodType == MethodType.SET) {
            return Reflector.getParameterDependents(method, 0);
        }
        if (methodType == MethodType.GET) {
            return Reflector.getReturnDependents(method);
        }
        if (methodType == MethodType.IS) {
            return Reflector.getReturnDependents(method);
        }
        return null;
    }

    public Class getType(Method method) {
        MethodType methodType = this.getMethodType(method);
        if (methodType == MethodType.SET) {
            return this.getParameterType(method);
        }
        if (methodType == MethodType.GET) {
            return this.getReturnType(method);
        }
        if (methodType == MethodType.IS) {
            return this.getReturnType(method);
        }
        return null;
    }

    private Class getParameterType(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1) {
            return method.getParameterTypes()[0];
        }
        return null;
    }

    private Class getReturnType(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            return method.getReturnType();
        }
        return null;
    }

    private MethodName getRead(Method method, MethodType methodType) {
        Class<?>[] classArray = method.getParameterTypes();
        String string = method.getName();
        if (classArray.length != 0) {
            throw new MethodException("Get method %s is not a valid property", method);
        }
        String string2 = this.getTypeName(string, methodType);
        if (string2 == null) {
            throw new MethodException("Could not get name for %s", method);
        }
        return new MethodName(method, methodType, string2);
    }

    private MethodName getWrite(Method method, MethodType methodType) {
        Class<?>[] classArray = method.getParameterTypes();
        String string = method.getName();
        if (classArray.length != 1) {
            throw new MethodException("Set method %s is not a valid property", method);
        }
        String string2 = this.getTypeName(string, methodType);
        if (string2 == null) {
            throw new MethodException("Could not get name for %s", method);
        }
        return new MethodName(method, methodType, string2);
    }

    private String getTypeName(String string, MethodType methodType) {
        int n = methodType.getPrefix();
        int n2 = string.length();
        if (n2 > n) {
            string = string.substring(n, n2);
        }
        return Reflector.getName(string);
    }
}

