/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ByteVector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ModuleVisitor;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.SymbolTable;

final class ModuleWriter
extends ModuleVisitor {
    private final SymbolTable symbolTable;
    private final int moduleNameIndex;
    private final int moduleFlags;
    private final int moduleVersionIndex;
    private int requiresCount;
    private final ByteVector requires;
    private int exportsCount;
    private final ByteVector exports;
    private int opensCount;
    private final ByteVector opens;
    private int usesCount;
    private final ByteVector usesIndex;
    private int providesCount;
    private final ByteVector provides;
    private int packageCount;
    private final ByteVector packageIndex;
    private int mainClassIndex;

    ModuleWriter(SymbolTable symbolTable, int n, int n2, int n3) {
        super(589824);
        this.symbolTable = symbolTable;
        this.moduleNameIndex = n;
        this.moduleFlags = n2;
        this.moduleVersionIndex = n3;
        this.requires = new ByteVector();
        this.exports = new ByteVector();
        this.opens = new ByteVector();
        this.usesIndex = new ByteVector();
        this.provides = new ByteVector();
        this.packageIndex = new ByteVector();
    }

    public void visitMainClass(String string) {
        this.mainClassIndex = this.symbolTable.addConstantClass((String)string).index;
    }

    public void visitPackage(String string) {
        this.packageIndex.putShort(this.symbolTable.addConstantPackage((String)string).index);
        ++this.packageCount;
    }

    public void visitRequire(String string, int n, String string2) {
        this.requires.putShort(this.symbolTable.addConstantModule((String)string).index).putShort(n).putShort(string2 == null ? 0 : this.symbolTable.addConstantUtf8(string2));
        ++this.requiresCount;
    }

    public void visitExport(String string, int n, String ... stringArray) {
        this.exports.putShort(this.symbolTable.addConstantPackage((String)string).index).putShort(n);
        if (stringArray == null) {
            this.exports.putShort(0);
        } else {
            this.exports.putShort(stringArray.length);
            for (String string2 : stringArray) {
                this.exports.putShort(this.symbolTable.addConstantModule((String)string2).index);
            }
        }
        ++this.exportsCount;
    }

    public void visitOpen(String string, int n, String ... stringArray) {
        this.opens.putShort(this.symbolTable.addConstantPackage((String)string).index).putShort(n);
        if (stringArray == null) {
            this.opens.putShort(0);
        } else {
            this.opens.putShort(stringArray.length);
            for (String string2 : stringArray) {
                this.opens.putShort(this.symbolTable.addConstantModule((String)string2).index);
            }
        }
        ++this.opensCount;
    }

    public void visitUse(String string) {
        this.usesIndex.putShort(this.symbolTable.addConstantClass((String)string).index);
        ++this.usesCount;
    }

    public void visitProvide(String string, String ... stringArray) {
        this.provides.putShort(this.symbolTable.addConstantClass((String)string).index);
        this.provides.putShort(stringArray.length);
        for (String string2 : stringArray) {
            this.provides.putShort(this.symbolTable.addConstantClass((String)string2).index);
        }
        ++this.providesCount;
    }

    public void visitEnd() {
    }
}

