/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.search.StrParser;
import org.apache.solr.search.SyntaxError;

public class LegacyFacet {
    private SolrParams params;
    private Map<String, Object> json;
    private Map<String, Object> currentCommand = null;
    private Map<String, Object> currentSubs;
    String facetValue;
    String key;
    SolrParams localParams;
    SolrParams orig;
    SolrParams required;
    Map<String, List<Subfacet>> subFacets;

    public LegacyFacet(SolrParams params) {
        this.params = params;
        this.orig = params;
        this.json = new LinkedHashMap<String, Object>();
        this.currentSubs = this.json;
    }

    Map<String, Object> getLegacy() {
        String[] ranges;
        String[] fields;
        this.subFacets = LegacyFacet.parseSubFacets(this.params);
        String[] queries = this.params.getParams("facet.query");
        if (queries != null) {
            for (String q : queries) {
                this.addQueryFacet(q);
            }
        }
        if ((fields = this.params.getParams("facet.field")) != null) {
            for (String field : fields) {
                this.addFieldFacet(field);
            }
        }
        if ((ranges = this.params.getParams("facet.range")) != null) {
            for (String range : ranges) {
                this.addRangeFacet(range);
            }
        }
        return this.json;
    }

    protected static Map<String, List<Subfacet>> parseSubFacets(SolrParams params) {
        HashMap<String, List<Subfacet>> map = new HashMap<String, List<Subfacet>>();
        Iterator iter = params.getParameterNamesIterator();
        String SUBFACET = "subfacet.";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(SUBFACET)) continue;
            List parts = StrUtils.splitSmart((String)key, (char)'.');
            if (parts.size() != 3) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "expected subfacet parameter name of the form subfacet.mykey.field, got:" + key);
            }
            Subfacet sub = new Subfacet();
            sub.parentKey = (String)parts.get(1);
            sub.type = (String)parts.get(2);
            sub.value = params.get(key);
            ArrayList<Subfacet> subs = (ArrayList<Subfacet>)map.get(sub.parentKey);
            if (subs == null) {
                subs = new ArrayList<Subfacet>(1);
            }
            subs.add(sub);
            map.put(sub.parentKey, subs);
        }
        return map;
    }

    protected void addQueryFacet(String q) {
        this.parseParams("facet.query", q);
        HashMap<String, Object> cmd = new HashMap<String, Object>(2);
        HashMap<String, Object> type = new HashMap<String, Object>(1);
        type.put("query", cmd);
        cmd.put("q", q);
        this.addSub(this.key, type);
        this.handleSubs(cmd);
    }

    protected void addRangeFacet(String field) {
        this.parseParams("facet.range", field);
        HashMap<String, Object> cmd = new HashMap<String, Object>(5);
        HashMap<String, Object> type = new HashMap<String, Object>(1);
        type.put("range", cmd);
        String f = this.key;
        cmd.put("field", this.facetValue);
        cmd.put("start", this.required.getFieldParam(f, "facet.range.start"));
        cmd.put("end", this.required.getFieldParam(f, "facet.range.end"));
        cmd.put("gap", this.required.getFieldParam(f, "facet.range.gap"));
        String[] p = this.params.getFieldParams(f, "facet.range.other");
        if (p != null) {
            cmd.put("other", p.length == 1 ? p[0] : Arrays.asList(p));
        }
        if ((p = this.params.getFieldParams(f, "facet.range.include")) != null) {
            cmd.put("include", p.length == 1 ? p[0] : Arrays.asList(p));
        }
        int mincount = this.params.getFieldInt(f, "facet.mincount", 0);
        cmd.put("mincount", mincount);
        boolean hardend = this.params.getFieldBool(f, "facet.range.hardend", false);
        if (hardend) {
            cmd.put("hardend", hardend);
        }
        this.addSub(this.key, type);
        this.handleSubs(cmd);
    }

    protected void addFieldFacet(String field) {
        this.parseParams("facet.field", field);
        String f = this.key;
        int offset = this.params.getFieldInt(f, "facet.offset", 0);
        int limit = this.params.getFieldInt(f, "facet.limit", 10);
        int mincount = this.params.getFieldInt(f, "facet.mincount", 1);
        boolean missing = this.params.getFieldBool(f, "facet.missing", false);
        String sort = this.params.getFieldParam(f, "facet.sort", limit > 0 ? "count" : "index");
        String prefix = this.params.getFieldParam(f, "facet.prefix");
        HashMap<String, Object> cmd = new HashMap<String, Object>();
        cmd.put("field", this.facetValue);
        if (offset != 0) {
            cmd.put("offset", offset);
        }
        if (limit != 10) {
            cmd.put("limit", limit);
        }
        if (mincount != 1) {
            cmd.put("mincount", mincount);
        }
        if (missing) {
            cmd.put("missing", missing);
        }
        if (prefix != null) {
            cmd.put("prefix", prefix);
        }
        if (!sort.equals("count")) {
            if (sort.equals("index")) {
                cmd.put("sort", "index asc");
            } else {
                cmd.put("sort", sort);
            }
        }
        HashMap<String, Object> type = new HashMap<String, Object>(1);
        type.put("terms", cmd);
        this.addSub(this.key, type);
        this.handleSubs(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubs(Map<String, Object> cmd) {
        Map<String, Object> savedCmd = this.currentCommand;
        Map<String, Object> savedSubs = this.currentSubs;
        try {
            List<Subfacet> subs;
            this.currentCommand = cmd;
            this.currentSubs = null;
            String[] stats = this.params.getFieldParams(this.key, "facet.stat");
            if (stats != null) {
                for (String stat : stats) {
                    this.addStat(stat);
                }
            }
            if ((subs = this.subFacets.get(this.key)) != null) {
                for (Subfacet subfacet : subs) {
                    if ("field".equals(subfacet.type)) {
                        this.addFieldFacet(subfacet.value);
                        continue;
                    }
                    if ("query".equals(subfacet.type)) {
                        this.addQueryFacet(subfacet.value);
                        continue;
                    }
                    if (!"range".equals(subfacet.type)) continue;
                    this.addQueryFacet(subfacet.value);
                }
            }
        }
        finally {
            this.currentCommand = savedCmd;
            this.currentSubs = savedSubs;
        }
    }

    private void addStat(String val) {
        StrParser sp = new StrParser(val);
        int start = 0;
        sp.eatws();
        if (sp.pos >= sp.end) {
            this.addStat(val, val);
        }
        String key = null;
        String funcStr = val;
        if (key == null) {
            key = SolrReturnFields.getFieldName(sp);
            if (key != null && sp.opt(':')) {
                funcStr = val.substring(sp.pos);
            } else {
                sp.pos = start;
                key = null;
            }
        }
        if (key == null) {
            key = funcStr;
        }
        this.addStat(key, funcStr);
    }

    private void addStat(String key, String val) {
        if ("count".equals(val) || "count()".equals(val)) {
            return;
        }
        this.getCurrentSubs().put(key, val);
    }

    private void addSub(String key, Map<String, Object> sub) {
        this.getCurrentSubs().put(key, sub);
    }

    private Map<String, Object> getCurrentSubs() {
        if (this.currentSubs == null) {
            this.currentSubs = new LinkedHashMap<String, Object>();
            this.currentCommand.put("facet", this.currentSubs);
        }
        return this.currentSubs;
    }

    protected void parseParams(String type, String param) {
        this.facetValue = param;
        this.key = param;
        try {
            this.localParams = QueryParsing.getLocalParams(param, this.orig);
            if (this.localParams == null) {
                this.params = this.orig;
                this.required = new RequiredSolrParams(this.params);
                return;
            }
            this.params = SolrParams.wrapDefaults((SolrParams)this.localParams, (SolrParams)this.orig);
            this.required = new RequiredSolrParams(this.params);
            if (type != "facet.query") {
                this.facetValue = this.localParams.get("v");
            }
            this.key = this.facetValue;
            this.key = this.localParams.get("key", this.key);
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    protected static class Subfacet {
        public String parentKey;
        public String type;
        public String value;

        protected Subfacet() {
        }
    }
}

