/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CdcrBufferStateManager;
import org.apache.solr.handler.CdcrLeaderStateManager;
import org.apache.solr.handler.CdcrParams;
import org.apache.solr.handler.CdcrStateManager;
import org.apache.solr.update.CdcrUpdateLog;

class CdcrBufferManager
implements CdcrStateManager.CdcrStateObserver {
    private CdcrLeaderStateManager leaderStateManager;
    private CdcrBufferStateManager bufferStateManager;
    private final SolrCore core;

    CdcrBufferManager(SolrCore core) {
        this.core = core;
    }

    void setLeaderStateManager(CdcrLeaderStateManager leaderStateManager) {
        this.leaderStateManager = leaderStateManager;
        this.leaderStateManager.register(this);
    }

    void setBufferStateManager(CdcrBufferStateManager bufferStateManager) {
        this.bufferStateManager = bufferStateManager;
        this.bufferStateManager.register(this);
    }

    @Override
    public synchronized void stateUpdate() {
        CdcrUpdateLog ulog = (CdcrUpdateLog)this.core.getUpdateHandler().getUpdateLog();
        if (!this.leaderStateManager.amILeader()) {
            ulog.enableBuffer();
            return;
        }
        if (this.bufferStateManager.getState().equals((Object)CdcrParams.BufferState.ENABLED)) {
            ulog.enableBuffer();
            return;
        }
        ulog.disableBuffer();
    }
}

