/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jdbm.helper.Conversion;
import org.apache.directory.api.ldap.extras.extended.startTransaction.StartTransactionResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartTransactionHandler
implements ExtendedOperationHandler<ExtendedRequest, ExtendedResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(StartTransactionHandler.class);
    public static final Set<String> EXTENSION_OIDS;

    @Override
    public String getOid() {
        return "1.3.6.1.1.21.1";
    }

    @Override
    public void handleExtendedOperation(LdapSession session, ExtendedRequest req) throws Exception {
        LOG.debug("StartTransaction requested");
        CoreSession coreSession = session.getCoreSession();
        long transactionId = coreSession.beginSessionTransaction();
        StartTransactionResponseImpl startTransactionResponse = new StartTransactionResponseImpl(req.getMessageId(), Conversion.convertToByteArray((long)transactionId));
        startTransactionResponse.setResponseName("1.3.6.1.1.21.1");
        session.getIoSession().write((Object)startTransactionResponse);
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> set = new HashSet<String>(2);
        set.add("1.3.6.1.1.21.1");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

