/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Associates a hostname with its corresponding certificate and private key")
public class ApiHostCertInfo {
    @SerializedName(value="hostname")
    private String hostname = null;
    @SerializedName(value="certificate")
    private String certificate = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="subjectAltNames")
    private List<String> subjectAltNames = null;

    public ApiHostCertInfo hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Schema(description="The FQDN of a host in the deployment.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ApiHostCertInfo certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    @Schema(example="host-cert.pem", description="The certificate for this host in PEM format.")
    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public ApiHostCertInfo key(String key) {
        this.key = key;
        return this;
    }

    @Schema(example="host-key.pem", description="The private key for this host in PEM format.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ApiHostCertInfo subjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
        return this;
    }

    public ApiHostCertInfo addSubjectAltNamesItem(String subjectAltNamesItem) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.add(subjectAltNamesItem);
        return this;
    }

    @Schema(example="DNS:example.cloudera.com", description="A list of alt names for a host.")
    public List<String> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHostCertInfo apiHostCertInfo = (ApiHostCertInfo)o;
        return Objects.equals(this.hostname, apiHostCertInfo.hostname) && Objects.equals(this.certificate, apiHostCertInfo.certificate) && Objects.equals(this.key, apiHostCertInfo.key) && Objects.equals(this.subjectAltNames, apiHostCertInfo.subjectAltNames);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.certificate, this.key, this.subjectAltNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHostCertInfo {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    subjectAltNames: ").append(this.toIndentedString(this.subjectAltNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

