/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util.urltemplate;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.util.urltemplate.Fragment;
import org.apache.knox.gateway.util.urltemplate.Host;
import org.apache.knox.gateway.util.urltemplate.Password;
import org.apache.knox.gateway.util.urltemplate.Path;
import org.apache.knox.gateway.util.urltemplate.Port;
import org.apache.knox.gateway.util.urltemplate.Query;
import org.apache.knox.gateway.util.urltemplate.Scheme;
import org.apache.knox.gateway.util.urltemplate.Template;
import org.apache.knox.gateway.util.urltemplate.Token;
import org.apache.knox.gateway.util.urltemplate.Username;

public class Builder {
    private String original;
    private boolean literal;
    private boolean hasScheme;
    private Scheme scheme;
    private boolean hasAuthority;
    private boolean isAuthorityOnly;
    private Username username;
    private Password password;
    private Host host;
    private Port port;
    private boolean isAbsolute;
    private boolean isDirectory;
    private List<Path> path;
    private boolean hasQuery;
    private Map<String, Query> query;
    private Query extra;
    private boolean hasFragment;
    private Fragment fragment;

    public Builder() {
        this((String)null);
    }

    public Builder(String original) {
        this.original = original;
        this.literal = false;
        this.hasScheme = false;
        this.scheme = null;
        this.hasAuthority = false;
        this.isAuthorityOnly = false;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = null;
        this.isAbsolute = false;
        this.isDirectory = false;
        this.path = new ArrayList<Path>();
        this.hasQuery = false;
        this.query = new LinkedHashMap<String, Query>();
        this.extra = null;
        this.hasFragment = false;
        this.fragment = null;
    }

    public Builder(Template template) {
        this.hasScheme = template.hasScheme();
        this.scheme = this.copyScheme(template.getScheme());
        this.hasAuthority = template.hasAuthority();
        this.isAuthorityOnly = template.isAuthorityOnly();
        this.username = this.copyUsername(template.getUsername());
        this.password = this.copyPassword(template.getPassword());
        this.host = this.copyHost(template.getHost());
        this.port = this.copyPort(template.getPort());
        this.isAbsolute = template.isAbsolute();
        this.isDirectory = template.isDirectory();
        this.path = this.copyPath(template.getPath());
        this.hasQuery = template.hasQuery();
        this.query = this.copyQuery(template.getQuery());
        this.extra = this.copyExtra(template.getExtra());
        this.hasFragment = template.hasFragment();
        this.fragment = this.copyFragment(template.getFragment());
    }

    private Scheme copyScheme(Scheme orig) {
        Scheme copy = null;
        if (orig != null) {
            copy = new Scheme(orig);
        }
        return copy;
    }

    private Username copyUsername(Username orig) {
        Username copy = null;
        if (orig != null) {
            copy = new Username(orig);
        }
        return copy;
    }

    private Password copyPassword(Password orig) {
        Password copy = null;
        if (orig != null) {
            copy = new Password(orig);
        }
        return copy;
    }

    private Host copyHost(Host orig) {
        Host copy = null;
        if (orig != null) {
            copy = new Host(orig);
        }
        return copy;
    }

    private Port copyPort(Port orig) {
        Port copy = null;
        if (orig != null) {
            copy = new Port(orig);
        }
        return copy;
    }

    private Query copyExtra(Query orig) {
        Query copy = null;
        if (orig != null) {
            copy = new Query(orig);
        }
        return copy;
    }

    private List<Path> copyPath(List<Path> orig) {
        ArrayList<Path> copy = new ArrayList<Path>();
        if (orig != null) {
            for (Path path : orig) {
                copy.add(new Path(path));
            }
        }
        return copy;
    }

    private Fragment copyFragment(Fragment orig) {
        Fragment copy = null;
        if (orig != null) {
            copy = new Fragment(orig);
        }
        return copy;
    }

    private Map<String, Query> copyQuery(Map<String, Query> orig) {
        LinkedHashMap<String, Query> copy = new LinkedHashMap<String, Query>();
        if (orig != null) {
            for (Map.Entry<String, Query> entry : orig.entrySet()) {
                copy.put(entry.getKey(), new Query(entry.getValue()));
            }
        }
        return copy;
    }

    public Template build() {
        return new Template(this.original, this.scheme, this.hasScheme, this.username, this.password, this.host, this.port, this.hasAuthority, this.isAuthorityOnly, this.path, this.isAbsolute, this.isDirectory, this.query, this.extra, this.hasQuery, this.fragment, this.hasFragment);
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public void setLiteral(boolean literal) {
        this.literal = literal;
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean getHasScheme() {
        return this.hasScheme;
    }

    public void setHasScheme(boolean hasScheme) {
        this.hasScheme = hasScheme;
        if (!hasScheme) {
            this.scheme = null;
        }
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public void setScheme(String paramName, String valuePattern, boolean literal) {
        this.scheme = new Scheme(paramName, valuePattern, literal);
        this.setHasScheme(true);
    }

    void setScheme(Token t) {
        this.scheme = new Scheme(t);
        this.setHasScheme(true);
    }

    public boolean getHasAuthority() {
        return this.hasAuthority;
    }

    public void setHasAuthority(boolean hasAuthority) {
        this.hasAuthority = hasAuthority;
    }

    public boolean getIsAuthorityOnly() {
        return this.isAuthorityOnly;
    }

    public void setIsAuthorityOnly(boolean isAuthorityOnly) {
        this.isAuthorityOnly = isAuthorityOnly;
    }

    public Username getUsername() {
        return this.username;
    }

    public void setUsername(String paramName, String valuePattern, boolean literal) {
        this.setHasAuthority(true);
        this.username = new Username(new Token(paramName, valuePattern, literal));
    }

    void setUsername(Token token) {
        this.setHasAuthority(true);
        this.username = new Username(token);
    }

    public Password getPassword() {
        return this.password;
    }

    public void setPassword(String paramName, String valuePattern, boolean literal) {
        this.setHasAuthority(true);
        this.password = new Password(paramName, valuePattern, literal);
    }

    void setPassword(Token token) {
        this.setHasAuthority(true);
        this.password = new Password(token);
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(String paramName, String valuePattern, boolean literal) {
        this.setHost(new Token(paramName, valuePattern, literal));
    }

    void setHost(Token token) {
        this.setHasAuthority(true);
        this.host = new Host(token);
    }

    public Port getPort() {
        return this.port;
    }

    public void setPort(String paramName, String valuePattern, boolean literal) {
        this.setPort(new Token(paramName, valuePattern, literal));
    }

    void setPort(Token token) {
        this.setHasAuthority(true);
        this.port = new Port(token);
    }

    public boolean getIsAbsolute() {
        return this.isAbsolute;
    }

    public Builder setIsAbsolute(boolean isAbsolute) {
        this.isAbsolute = isAbsolute;
        return this;
    }

    public boolean getIsDirectory() {
        return this.isDirectory;
    }

    public Builder setIsDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
        return this;
    }

    public List<Path> getPath() {
        return this.path;
    }

    public Builder addPath(String paramName, String valuePattern, boolean literal) {
        Path segment = new Path(paramName, valuePattern, literal);
        this.path.add(segment);
        return this;
    }

    Builder addPath(Token token) {
        Path segment = new Path(token);
        this.path.add(segment);
        return this;
    }

    public boolean getHasQuery() {
        return this.hasQuery;
    }

    public Builder setHasQuery(boolean hasQuery) {
        this.hasQuery = hasQuery;
        return this;
    }

    public Map<String, Query> getQuery() {
        return this.query;
    }

    public Builder addQuery(String queryName, String paramName, String valuePattern, boolean literal) {
        if ("*".equals(queryName) || "**".equals(queryName)) {
            if (this.extra == null) {
                this.extra = new Query(queryName, paramName, valuePattern, literal);
            }
        } else {
            Query segment = this.query.get(queryName);
            if (segment == null) {
                segment = new Query(queryName, paramName, valuePattern, literal);
                this.query.put(queryName, segment);
            } else {
                segment.addValue(new Token(queryName, valuePattern, literal));
            }
        }
        return this;
    }

    Builder addQuery(String queryName, Token token) {
        if ("*".equals(queryName) || "**".equals(queryName)) {
            if (this.extra == null) {
                this.extra = new Query(queryName, token);
            }
        } else {
            Query segment = this.query.get(queryName);
            if (segment == null) {
                segment = new Query(queryName, token);
                this.query.put(queryName, segment);
            } else {
                segment.addValue(token);
            }
        }
        return this;
    }

    public boolean getHasFragment() {
        return this.hasFragment;
    }

    public void setHasFragment(boolean hasFragment) {
        this.hasFragment = hasFragment;
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public void setFragment(String paramName, String valuePattern) {
        this.setHasFragment(true);
        this.fragment = new Fragment(paramName, valuePattern, this.literal);
    }

    void setFragment(Token t) {
        this.setHasFragment(true);
        this.fragment = new Fragment(t);
    }
}

