/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.persistence.core.mappings.CoreAttributeAccessor;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.core.helper.CoreField;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBHelperContext;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBListWrapper;
import org.eclipse.persistence.sessions.Session;

public class JAXBValueStore
implements ValueStore {
    private JAXBHelperContext jaxbHelperContext;
    private Object entity;
    private XMLDescriptor descriptor;
    private SDODataObject dataObject;
    private Map<Property, JAXBListWrapper> listWrappers;

    public JAXBValueStore(JAXBHelperContext aJAXBHelperContext, SDOType sdoType) {
        this.jaxbHelperContext = aJAXBHelperContext;
        this.listWrappers = new WeakHashMap<Property, JAXBListWrapper>();
        this.descriptor = this.jaxbHelperContext.getObjectDescriptor(sdoType);
        this.entity = this.descriptor.getInstantiationPolicy().buildNewInstance();
    }

    public JAXBValueStore(JAXBHelperContext aJAXBHelperContext, Object anEntity) {
        this.jaxbHelperContext = aJAXBHelperContext;
        this.listWrappers = new WeakHashMap<Property, JAXBListWrapper>();
        JAXBContext jaxbContext = (JAXBContext)this.jaxbHelperContext.getJAXBContext();
        this.descriptor = (XMLDescriptor)jaxbContext.getXMLContext().getSession(anEntity).getDescriptor(anEntity);
        this.entity = anEntity;
    }

    private JAXBValueStore(JAXBHelperContext aJAXBHelperContext, Object anEntity, XMLDescriptor aDescriptor, SDODataObject aDataObject, Map<Property, JAXBListWrapper> aMap) {
        this.jaxbHelperContext = aJAXBHelperContext;
        this.entity = anEntity;
        this.descriptor = aDescriptor;
        this.dataObject = aDataObject;
        this.listWrappers = aMap;
        for (JAXBListWrapper jaxbListWrapper : this.listWrappers.values()) {
            jaxbListWrapper.getCurrentElements().setValueStore(this);
        }
    }

    SDODataObject getDataObject() {
        return this.dataObject;
    }

    Object getEntity() {
        return this.entity;
    }

    XMLDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    JAXBHelperContext getJAXBHelperContext() {
        return this.jaxbHelperContext;
    }

    @Override
    public void initialize(DataObject aDataObject) {
        this.dataObject = (SDODataObject)aDataObject;
    }

    @Override
    public Object getDeclaredProperty(int propertyIndex) {
        SDOProperty declaredProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(propertyIndex);
        if (declaredProperty.getType().isChangeSummaryType()) {
            return this.dataObject.getChangeSummary();
        }
        Mapping mapping = this.getJAXBMappingForProperty(declaredProperty);
        Object value = mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
        if (declaredProperty.isMany()) {
            JAXBListWrapper listWrapper = this.listWrappers.get(declaredProperty);
            if (listWrapper != null) {
                return listWrapper;
            }
            listWrapper = new JAXBListWrapper(this, declaredProperty);
            this.listWrappers.put(declaredProperty, listWrapper);
            return listWrapper;
        }
        if (value == null || declaredProperty.getType().isDataType()) {
            return value;
        }
        if (declaredProperty.isContainment()) {
            return this.jaxbHelperContext.wrap(value, (Property)declaredProperty, (DataObject)this.dataObject);
        }
        return this.jaxbHelperContext.wrap(value);
    }

    @Override
    public void setDeclaredProperty(int propertyIndex, Object value) {
        SDOProperty declaredProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(propertyIndex);
        if (declaredProperty.getType().isChangeSummaryType()) {
            return;
        }
        Mapping mapping = this.getJAXBMappingForProperty(declaredProperty);
        Object newValue = value;
        Object oldValue = mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
        if (declaredProperty.getType().isDataType()) {
            if (!declaredProperty.isMany()) {
                AbstractSession session = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
                XMLDirectMapping directMapping = (XMLDirectMapping)mapping;
                if (directMapping.hasConverter()) {
                    newValue = directMapping.getConverter().convertDataValueToObjectValue(newValue, (Session)session);
                } else {
                    CoreField field = mapping.getField();
                    newValue = session.getDatasourcePlatform().getConversionManager().convertObject(newValue, this.descriptor.getObjectBuilder().getFieldClassification((DatabaseField)((XMLField)field)));
                }
            }
            mapping.setAttributeValueInObject(this.entity, newValue);
        } else if (declaredProperty.isMany()) {
            ListWrapper listWrapper = (ListWrapper)this.getDeclaredProperty(propertyIndex);
            listWrapper.addAll((Collection)((List)newValue));
        } else {
            XMLCompositeObjectMapping compositeMapping;
            if (mapping.isAbstractCompositeObjectMapping()) {
                compositeMapping = (XMLCompositeObjectMapping)mapping;
                if (oldValue != null && compositeMapping.getContainerAccessor() != null) {
                    compositeMapping.getContainerAccessor().setAttributeValueInObject(oldValue, null);
                }
            }
            newValue = this.jaxbHelperContext.unwrap((DataObject)value);
            mapping.getAttributeAccessor().setAttributeValueInObject(this.entity, newValue);
            if (mapping.isAbstractCompositeObjectMapping()) {
                compositeMapping = (XMLCompositeObjectMapping)mapping;
                if (value != null && compositeMapping.getContainerAccessor() != null) {
                    compositeMapping.getContainerAccessor().setAttributeValueInObject(newValue, this.entity);
                }
            }
        }
    }

    @Override
    public boolean isSetDeclaredProperty(int propertyIndex) {
        SDOProperty declaredProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(propertyIndex);
        if (declaredProperty.getType().isChangeSummaryType()) {
            return true;
        }
        Mapping mapping = this.getJAXBMappingForProperty(declaredProperty);
        if (declaredProperty.isMany()) {
            Collection collection = (Collection)mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
            if (collection == null) {
                return false;
            }
            return !collection.isEmpty();
        }
        return mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity) != null;
    }

    @Override
    public void unsetDeclaredProperty(int propertyIndex) {
        SDOProperty declaredProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(propertyIndex);
        Mapping mapping = this.getJAXBMappingForProperty(declaredProperty);
        if (declaredProperty.isMany()) {
            Object oldContainer;
            XMLCompositeCollectionMapping compositeMapping;
            ContainerMapping containerMapping = (ContainerMapping)mapping;
            ContainerPolicy containerPolicy = containerMapping.getContainerPolicy();
            if (mapping.isAbstractCompositeCollectionMapping() && (compositeMapping = (XMLCompositeCollectionMapping)mapping).getContainerAccessor() != null && (oldContainer = mapping.getAttributeValueFromObject(this.entity)) != null) {
                AbstractSession session = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
                Object iterator = containerPolicy.iteratorFor(oldContainer);
                while (containerPolicy.hasNext(iterator)) {
                    Object oldValue = containerPolicy.next(iterator, session);
                    compositeMapping.getContainerAccessor().setAttributeValueInObject(oldValue, null);
                }
            }
            Object container = containerPolicy.containerInstance();
            mapping.getAttributeAccessor().setAttributeValueInObject(this.entity, container);
        } else {
            XMLCompositeObjectMapping compositeMapping;
            Object oldValue = mapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
            if (mapping.isAbstractCompositeObjectMapping() && (compositeMapping = (XMLCompositeObjectMapping)mapping).getContainerAccessor() != null && oldValue != null) {
                compositeMapping.getContainerAccessor().setAttributeValueInObject(oldValue, null);
            }
            mapping.getAttributeAccessor().setAttributeValueInObject(this.entity, null);
        }
    }

    @Override
    public Object getOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOpenContentProperty(Property property, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSetOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unsetOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setManyProperty(Property property, Object value) {
    }

    @Override
    public ValueStore copy() {
        AbstractSession session = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
        Object originalEntity = this.entity;
        this.entity = this.descriptor.getInstantiationPolicy().buildNewInstance();
        for (SDOProperty sdoProperty : this.dataObject.getType().getProperties()) {
            if (sdoProperty.getType().isChangeSummaryType()) continue;
            Mapping mapping = this.getJAXBMappingForProperty(sdoProperty);
            CoreAttributeAccessor attributeAccessor = mapping.getAttributeAccessor();
            Object attributeValue = attributeAccessor.getAttributeValueFromObject(originalEntity);
            if (mapping.isCollectionMapping()) {
                Object containerCopy = null;
                SDOChangeSummary sdoChangeSummary = this.dataObject.getChangeSummary();
                if (sdoChangeSummary != null) {
                    List list = this.listWrappers.get(sdoProperty);
                    containerCopy = sdoChangeSummary.getOriginalElements().get(list);
                }
                if (containerCopy == null) {
                    CoreContainerPolicy containerPolicy = mapping.getContainerPolicy();
                    containerCopy = containerPolicy.containerInstance();
                    if (attributeValue != null) {
                        Object attributeValueIterator = containerPolicy.iteratorFor(attributeValue);
                        while (containerPolicy.hasNext(attributeValueIterator)) {
                            containerPolicy.addInto(containerPolicy.nextEntry(attributeValueIterator), containerCopy, (CoreAbstractSession)session);
                        }
                    }
                }
                attributeAccessor.setAttributeValueInObject(this.entity, containerCopy);
                continue;
            }
            attributeAccessor.setAttributeValueInObject(this.entity, attributeValue);
        }
        return new JAXBValueStore(this.jaxbHelperContext, originalEntity, this.descriptor, this.dataObject, this.listWrappers);
    }

    Mapping getJAXBMappingForProperty(SDOProperty sdoProperty) {
        XPathFragment xPathFragment;
        XMLField field;
        DatabaseMapping sdoMapping = sdoProperty.getXmlMapping();
        if (sdoMapping instanceof XMLObjectReferenceMapping) {
            XMLObjectReferenceMapping referenceMapping = (XMLObjectReferenceMapping)sdoMapping;
            field = (XMLField)referenceMapping.getFields().get(0);
        } else {
            field = (XMLField)sdoMapping.getField();
        }
        TreeObjectBuilder treeObjectBuilder = (TreeObjectBuilder)this.descriptor.getObjectBuilder();
        Object xPathNode = treeObjectBuilder.getRootXPathNode();
        for (xPathFragment = field.getXPathFragment(); xPathNode != null && xPathFragment != null; xPathFragment = xPathFragment.getNextFragment()) {
            Map nonAttributeChildrenMap;
            if (xPathFragment.isAttribute()) {
                if (sdoProperty.isMany() && !sdoProperty.isContainment() && !sdoProperty.getType().isDataType()) {
                    xPathFragment = null;
                    break;
                }
                Map attributeChildrenMap = xPathNode.getAttributeChildrenMap();
                if (attributeChildrenMap == null) {
                    xPathNode = null;
                    continue;
                }
                xPathNode = (XPathNode)attributeChildrenMap.get(xPathFragment);
                continue;
            }
            xPathNode = xPathFragment.nameIsText() ? xPathNode.getTextNode() : ((nonAttributeChildrenMap = xPathNode.getNonAttributeChildrenMap()) == null ? null : (XPathNode)nonAttributeChildrenMap.get(xPathFragment));
            if (xPathFragment == null || !xPathFragment.nameIsText() || !sdoProperty.isMany() || sdoProperty.isContainment()) continue;
            xPathFragment = null;
            break;
        }
        if (xPathFragment == null && xPathNode != null && xPathNode.getNodeValue().isMappingNodeValue()) {
            MappingNodeValue mappingNodeValue = (MappingNodeValue)xPathNode.getNodeValue();
            return mappingNodeValue.getMapping();
        }
        throw SDOException.sdoJaxbNoMappingForProperty((String)sdoProperty.getName(), (String)field.getXPath());
    }
}

