/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariDynamicServiceURLCreator;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLCreator;

public class ServiceURLFactory {
    private Map<String, ServiceURLCreator> urlCreators = new HashMap<String, ServiceURLCreator>();
    private ServiceURLCreator defaultURLCreator;

    private ServiceURLFactory(AmbariCluster cluster) {
        this.defaultURLCreator = new AmbariDynamicServiceURLCreator(cluster);
        ServiceLoader<ServiceURLCreator> creators = ServiceLoader.load(ServiceURLCreator.class);
        for (ServiceURLCreator creator : creators) {
            String type = creator.getTargetService();
            if (type == null || type.isEmpty()) continue;
            creator.init(cluster);
            this.urlCreators.put(creator.getTargetService(), creator);
        }
    }

    public static ServiceURLFactory newInstance(AmbariCluster cluster) {
        return new ServiceURLFactory(cluster);
    }

    public List<String> create(String service, Map<String, String> serviceParams) {
        ServiceURLCreator creator = this.urlCreators.get(service);
        if (creator == null) {
            creator = this.defaultURLCreator;
        }
        return new ArrayList<String>(creator.create(service, serviceParams));
    }
}

