/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zstd;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DirectDecompressor;
import org.apache.hadoop.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZStandardDecompressor
implements Decompressor {
    private static final Logger LOG = LoggerFactory.getLogger(ZStandardDecompressor.class);
    private long stream;
    private int directBufferSize;
    private ByteBuffer compressedDirectBuf = null;
    private int compressedDirectBufOff;
    private int bytesInCompressedBuffer;
    private ByteBuffer uncompressedDirectBuf = null;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufferBytesToConsume = 0;
    private boolean finished;
    private int remaining = 0;
    private static boolean nativeZStandardLoaded = false;

    public static boolean isNativeCodeLoaded() {
        return nativeZStandardLoaded;
    }

    public static int getRecommendedBufferSize() {
        return ZStandardDecompressor.getStreamSize();
    }

    public ZStandardDecompressor() {
        this(ZStandardDecompressor.getStreamSize());
    }

    public ZStandardDecompressor(int bufferSize) {
        this.directBufferSize = bufferSize;
        this.compressedDirectBuf = ByteBuffer.allocateDirect(this.directBufferSize);
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
        this.stream = ZStandardDecompressor.create();
        this.reset();
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufferBytesToConsume = len;
        this.setInputFromSavedData();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
    }

    private void setInputFromSavedData() {
        this.compressedDirectBufOff = 0;
        this.bytesInCompressedBuffer = this.userBufferBytesToConsume;
        if (this.bytesInCompressedBuffer > this.directBufferSize) {
            this.bytesInCompressedBuffer = this.directBufferSize;
        }
        this.compressedDirectBuf.rewind();
        this.compressedDirectBuf.put(this.userBuf, this.userBufOff, this.bytesInCompressedBuffer);
        this.userBufOff += this.bytesInCompressedBuffer;
        this.userBufferBytesToConsume -= this.bytesInCompressedBuffer;
    }

    @Override
    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("Dictionary support is not enabled");
    }

    @Override
    public boolean needsInput() {
        if (this.uncompressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.bytesInCompressedBuffer - this.compressedDirectBufOff <= 0) {
            if (this.userBufferBytesToConsume <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    @Override
    public boolean needsDictionary() {
        return false;
    }

    @Override
    public boolean finished() {
        return this.finished && this.uncompressedDirectBuf.remaining() == 0;
    }

    @Override
    public int decompress(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.uncompressedDirectBuf.remaining();
        if (n > 0) {
            return this.populateUncompressedBuffer(b, off, len, n);
        }
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        n = this.inflateBytesDirect(this.compressedDirectBuf, this.compressedDirectBufOff, this.bytesInCompressedBuffer, this.uncompressedDirectBuf, 0, this.directBufferSize);
        this.uncompressedDirectBuf.limit(n);
        return this.populateUncompressedBuffer(b, off, len, n);
    }

    @Override
    public int getRemaining() {
        this.checkStream();
        return this.userBufferBytesToConsume + this.remaining;
    }

    @Override
    public void reset() {
        this.checkStream();
        ZStandardDecompressor.init(this.stream);
        this.remaining = 0;
        this.finished = false;
        this.compressedDirectBufOff = 0;
        this.bytesInCompressedBuffer = 0;
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
        this.userBufOff = 0;
        this.userBufferBytesToConsume = 0;
    }

    @Override
    public void end() {
        if (this.stream != 0L) {
            ZStandardDecompressor.free(this.stream);
            this.stream = 0L;
        }
    }

    protected void finalize() {
        this.reset();
    }

    private void checkStream() {
        if (this.stream == 0L) {
            throw new NullPointerException("Stream not initialized");
        }
    }

    private int populateUncompressedBuffer(byte[] b, int off, int len, int n) {
        n = Math.min(n, len);
        this.uncompressedDirectBuf.get(b, off, n);
        return n;
    }

    private static native void initIDs();

    private static native long create();

    private static native void init(long var0);

    private native int inflateBytesDirect(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    private static native void free(long var0);

    private static native int getStreamSize();

    int inflateDirect(ByteBuffer src, ByteBuffer dst) throws IOException {
        assert (this instanceof ZStandardDirectDecompressor);
        int originalPosition = dst.position();
        int n = this.inflateBytesDirect(src, src.position(), src.limit(), dst, dst.position(), dst.limit());
        dst.position(originalPosition + n);
        if (this.bytesInCompressedBuffer > 0) {
            src.position(this.compressedDirectBufOff);
        } else {
            src.position(src.limit());
        }
        return n;
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                ZStandardDecompressor.initIDs();
                nativeZStandardLoaded = true;
            }
            catch (Throwable t) {
                LOG.warn("Error loading zstandard native libraries: " + t);
            }
        }
    }

    public static class ZStandardDirectDecompressor
    extends ZStandardDecompressor
    implements DirectDecompressor {
        private boolean endOfInput;

        public ZStandardDirectDecompressor(int directBufferSize) {
            super(directBufferSize);
        }

        @Override
        public boolean finished() {
            return this.endOfInput && super.finished();
        }

        @Override
        public void reset() {
            super.reset();
            this.endOfInput = true;
        }

        @Override
        public void decompress(ByteBuffer src, ByteBuffer dst) throws IOException {
            assert (dst.isDirect()) : "dst.isDirect()";
            assert (src.isDirect()) : "src.isDirect()";
            assert (dst.remaining() > 0) : "dst.remaining() > 0";
            this.inflateDirect(src, dst);
            this.endOfInput = !src.hasRemaining();
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("byte[] arrays are not supported for DirectDecompressor");
        }

        @Override
        public int decompress(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("byte[] arrays are not supported for DirectDecompressor");
        }
    }
}

