/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.yarn;

import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class JobHistoryUIServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "JOBHISTORYUI";
    private static final String SERVICE_TYPE = "YARN";
    private static final String ROLE_TYPE = "JOBHISTORY";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return SERVICE_TYPE.equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        if (this.isSSLEnabled(service, serviceConfig)) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, "mapreduce_jobhistory_webapp_https_address");
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, "mapreduce_jobhistory_webapp_address");
        }
        return new ServiceModel(ServiceModel.Type.UI, SERVICE, String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
    }

    private boolean isSSLEnabled(ApiService service, ApiServiceConfig serviceConfig) throws ApiException {
        ServicesResourceApi servicesResourceApi = new ServicesResourceApi(this.getClient());
        String clusterName = service.getClusterRef().getClusterName();
        String hdfsService = this.getServiceConfigValue(serviceConfig, "hdfs_service");
        ApiServiceConfig hdfsServiceConfig = servicesResourceApi.readServiceConfig(clusterName, hdfsService, "full");
        return Boolean.parseBoolean(this.getServiceConfigValue(hdfsServiceConfig, "hdfs_hadoop_ssl_enabled"));
    }
}

