/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.deploy;

import java.util.List;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.services.security.CryptoService;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class JWTAccessTokenAssertionContributor
extends ProviderDeploymentContributorBase {
    private static final String ENCRYPT_ACCESS_TOKENS = "encrypt_access_tokens";
    private static final String FILTER_CLASSNAME = "org.apache.knox.gateway.provider.federation.jwt.filter.JWTAccessTokenAssertionFilter";
    private CryptoService crypto;

    public String getRole() {
        return "identity-assertion";
    }

    public String getName() {
        return "JWTAccessTokenAsserter";
    }

    public void initializeContribution(DeploymentContext context) {
        super.initializeContribution(context);
        this.crypto.createAndStoreEncryptionKeyForCluster("__gateway", ENCRYPT_ACCESS_TOKENS);
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(FILTER_CLASSNAME).params(params);
    }

    public void setCryptoService(CryptoService crypto) {
        this.crypto = crypto;
    }
}

