/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt.eis;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomSessionIdGenerator
implements SessionIdGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomSessionIdGenerator.class);
    private static final String RANDOM_NUM_GENERATOR_ALGORITHM_NAME = "SHA1PRNG";
    private Random random;

    public RandomSessionIdGenerator() {
        try {
            this.random = SecureRandom.getInstance(RANDOM_NUM_GENERATOR_ALGORITHM_NAME);
        }
        catch (NoSuchAlgorithmException e2) {
            LOGGER.debug("The SecureRandom SHA1PRNG algorithm is not available on the current platform.  Using the platform's default SecureRandom algorithm.", e2);
            this.random = new SecureRandom();
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public Serializable generateId(Session session) {
        return Long.toString(this.getRandom().nextLong());
    }
}

