/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene92;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene92.Lucene92HnswVectorsReader;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.packed.DirectMonotonicReader;

abstract class OffHeapFloatVectorValues
extends FloatVectorValues {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final int byteSize;
    protected int lastOrd = -1;
    protected final float[] value;
    protected final VectorSimilarityFunction vectorSimilarityFunction;

    OffHeapFloatVectorValues(int dimension, int size, VectorSimilarityFunction vectorSimilarityFunction, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = 4 * dimension;
        this.value = new float[dimension];
        this.vectorSimilarityFunction = vectorSimilarityFunction;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public float[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.value;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readFloats(this.value, 0, this.value.length);
        this.lastOrd = targetOrd;
        return this.value;
    }

    static OffHeapFloatVectorValues load(Lucene92HnswVectorsReader.FieldEntry fieldEntry, IndexInput vectorData) throws IOException {
        if (fieldEntry.docsWithFieldOffset() == -2L) {
            return new EmptyOffHeapVectorValues(fieldEntry.dimension());
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", fieldEntry.vectorDataOffset(), fieldEntry.vectorDataLength());
        if (fieldEntry.docsWithFieldOffset() == -1L) {
            return new DenseOffHeapVectorValues(fieldEntry.dimension(), fieldEntry.size(), fieldEntry.similarityFunction(), bytesSlice);
        }
        return new SparseOffHeapVectorValues(fieldEntry, vectorData, fieldEntry.similarityFunction(), bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        public EmptyOffHeapVectorValues(int dimension) {
            super(dimension, 0, VectorSimilarityFunction.COSINE, null);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public OffHeapFloatVectorValues copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] vectorValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(float[] query2) {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        public DenseOffHeapVectorValues(int dimension, int size, VectorSimilarityFunction vectorSimilarityFunction, IndexInput slice) {
            super(dimension, size, vectorSimilarityFunction, slice);
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.vectorSimilarityFunction, this.slice.clone());
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(final float[] query2) throws IOException {
            final DenseOffHeapVectorValues values = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = values.iterator();
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return values.vectorSimilarityFunction.compare(values.vectorValue(iterator.index()), query2);
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final Lucene92HnswVectorsReader.FieldEntry fieldEntry;

        public SparseOffHeapVectorValues(Lucene92HnswVectorsReader.FieldEntry fieldEntry, IndexInput dataIn, VectorSimilarityFunction vectorSimilarityFunction, IndexInput slice) throws IOException {
            super(fieldEntry.dimension(), fieldEntry.size(), vectorSimilarityFunction, slice);
            this.fieldEntry = fieldEntry;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(fieldEntry.addressesOffset(), fieldEntry.addressesLength());
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance(fieldEntry.meta(), addressesData);
            this.disi = new IndexedDISI(dataIn, fieldEntry.docsWithFieldOffset(), fieldEntry.docsWithFieldLength(), fieldEntry.jumpTableEntryCount(), fieldEntry.denseRankPower(), fieldEntry.size());
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.fieldEntry, this.dataIn, this.vectorSimilarityFunction, this.slice.clone());
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator(this.disi);
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }

        @Override
        public VectorScorer scorer(final float[] query2) throws IOException {
            final SparseOffHeapVectorValues values = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = values.iterator();
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return values.vectorSimilarityFunction.compare(values.vectorValue(iterator.index()), query2);
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }
}

