/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.table.TableUnit;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpTable
extends Op0 {
    private Table table;

    public static OpTable unit() {
        return new OpTable(TableFactory.createUnit());
    }

    public static OpTable empty() {
        return new OpTable(TableFactory.createEmpty());
    }

    public static OpTable create(Table table) {
        return new OpTable(table);
    }

    private OpTable(Table table) {
        this.table = table;
    }

    public boolean isJoinIdentity() {
        return TableUnit.isTableUnit(this.table);
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return "table";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    @Override
    public Op0 copy() {
        return new OpTable(this.table);
    }

    @Override
    public int hashCode() {
        return this.table.hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpTable)) {
            return false;
        }
        OpTable opTable = (OpTable)other;
        return this.table.equals(opTable.table);
    }
}

