/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.runner;

import java.io.IOException;
import java.net.BindException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiAbortException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.runner.Runner;

abstract class AbstractRunner
implements Runner {
    private static Object lock = new Object();

    AbstractRunner() {
    }

    @Override
    public void exec(String ... args) {
        FusekiServer fusekiServer = this.process(args);
        AbstractRunner.startAsync(fusekiServer);
        fusekiServer.join();
    }

    private static boolean isBindException(FusekiException ex) {
        IOException ex2;
        Throwable throwable;
        Throwable throwable2 = ex.getCause();
        if (throwable2 instanceof IOException && (throwable = (ex2 = (IOException)throwable2).getCause()) instanceof BindException) {
            BindException exBind = (BindException)throwable;
            return true;
        }
        return false;
    }

    private static void exitWithMessage(int exitStatus, String msg) {
        throw new FusekiAbortException(exitStatus, msg);
    }

    @Override
    public FusekiServer runAsync(String ... args) {
        FusekiServer server = this.process(args);
        AbstractRunner.startAsync(server);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FusekiServer process(String ... args) {
        Object object = lock;
        synchronized (object) {
            FusekiServer server = this.construct(args);
            return server;
        }
    }

    private static FusekiServer startAsync(FusekiServer server) {
        int port = server.getHttpPort();
        try {
            return server.start();
        }
        catch (FusekiAbortException ex) {
            throw ex;
        }
        catch (FusekiException ex) {
            if (AbstractRunner.isBindException(ex) && port > 0) {
                AbstractRunner.exitWithMessage(2, "Failed to bind port " + port + " - another Fuseki running on this machine?");
            }
            throw ex;
        }
        catch (Exception ex) {
            throw AbstractRunner.exception("Failed to start server: " + ex.getMessage(), ex);
        }
    }

    private static RuntimeException exception(String message, Throwable ex) {
        throw new FusekiException(message, ex);
    }

    private static RuntimeException abort(String message, Throwable ex) {
        throw new FusekiException(message, ex);
    }

    @Override
    public FusekiServer construct(String ... args) {
        FusekiServer.Builder builder = this.builder(args);
        return builder.build();
    }

    protected abstract FusekiServer.Builder builder(String ... var1);
}

