/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieve.core;

import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import org.apache.james.core.Username;
import org.apache.james.managesieve.api.AuthenticationException;
import org.apache.james.managesieve.api.AuthenticationProcessor;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SyntaxException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;

public class PlainAuthenticationProcessor
implements AuthenticationProcessor {
    private final UsersRepository usersRepository;

    public PlainAuthenticationProcessor(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    @Override
    public String initialServerResponse(Session session) {
        return "+ \"\"";
    }

    @Override
    public Username isAuthenticationSuccesfull(Session session, String suppliedClientData) throws SyntaxException, AuthenticationException {
        try {
            byte[] decoded = Base64.getDecoder().decode(suppliedClientData.getBytes());
            String decodedString = new String(decoded, StandardCharsets.US_ASCII);
            return this.authenticateWithSeparator(session, decodedString, '\u0000');
        }
        catch (Exception e) {
            if (suppliedClientData.contains("\u0000")) {
                return this.authenticateWithSeparator(session, suppliedClientData, '\u0000');
            }
            return this.authenticateWithSeparator(session, suppliedClientData, ' ');
        }
    }

    private Username authenticateWithSeparator(Session session, String suppliedClientData, char c) throws SyntaxException, AuthenticationException {
        Iterator it = Splitter.on((char)c).omitEmptyStrings().split((CharSequence)suppliedClientData).iterator();
        if (!it.hasNext()) {
            throw new SyntaxException("You must supply a username for the authentication mechanism. Formal syntax : <NULL>username<NULL>password");
        }
        Username userName = Username.of((String)((String)it.next()));
        if (!it.hasNext()) {
            throw new SyntaxException("You must supply a password for the authentication mechanism. Formal syntax : <NULL>username<NULL>password");
        }
        String password = (String)it.next();
        session.setUser(userName);
        try {
            User user = this.usersRepository.getUserByName(userName);
            if (user != null && user.verifyPassword(password)) {
                return userName;
            }
            return null;
        }
        catch (UsersRepositoryException e) {
            throw new AuthenticationException(e.getMessage());
        }
    }
}

