/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeUtils;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ITableDeviceSchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedStatement;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.apache.tsfile.write.schema.MeasurementSchema;

public abstract class WrappedInsertStatement
extends WrappedStatement
implements ITableDeviceSchemaValidation {
    protected TableSchema tableSchema;

    protected WrappedInsertStatement(InsertBaseStatement innerTreeStatement, MPPQueryContext context) {
        super(innerTreeStatement, context);
    }

    @Override
    public InsertBaseStatement getInnerTreeStatement() {
        return (InsertBaseStatement)super.getInnerTreeStatement();
    }

    public abstract void updateAfterSchemaValidation(MPPQueryContext var1) throws QueryProcessException;

    public TableSchema getTableSchema() {
        if (this.tableSchema == null) {
            InsertBaseStatement insertBaseStatement = this.getInnerTreeStatement();
            this.tableSchema = this.toTableSchema(insertBaseStatement);
        }
        return this.tableSchema;
    }

    protected TableSchema toTableSchema(InsertBaseStatement insertBaseStatement) {
        String tableName = insertBaseStatement.getDevicePath().getFullPath();
        ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>(insertBaseStatement.getMeasurements().length);
        for (int i = 0; i < insertBaseStatement.getMeasurements().length; ++i) {
            if (insertBaseStatement.getMeasurements()[i] != null) {
                TSDataType dataType = insertBaseStatement.getDataType(i);
                if (dataType == null) {
                    dataType = TypeInferenceUtils.getPredictedDataType(insertBaseStatement.getFirstValueOfIndex(i), true);
                }
                columnSchemas.add(new ColumnSchema(insertBaseStatement.getMeasurements()[i], dataType != null ? TypeFactory.getType((TSDataType)dataType) : null, false, insertBaseStatement.getColumnCategory(i)));
                continue;
            }
            columnSchemas.add(null);
        }
        return new TableSchema(tableName, columnSchemas);
    }

    public void validateTableSchema(Metadata metadata, MPPQueryContext context) {
        TableSchema incomingSchema;
        String databaseName = this.getDatabase();
        TableSchema realSchema = metadata.validateTableHeaderSchema(databaseName, incomingSchema = this.getTableSchema(), context, true, false).orElse(null);
        if (realSchema == null) {
            throw new SemanticException("Schema validation failed, table cannot be created: " + incomingSchema);
        }
        InsertBaseStatement innerTreeStatement = this.getInnerTreeStatement();
        this.validateTableSchema(realSchema, incomingSchema, innerTreeStatement);
    }

    protected void validateTableSchema(TableSchema realSchema, TableSchema incomingTableSchema, InsertBaseStatement innerTreeStatement) {
        List<ColumnSchema> incomingSchemaColumns = incomingTableSchema.getColumns();
        HashMap realSchemaMap = new HashMap();
        realSchema.getColumns().forEach(c -> realSchemaMap.put(c.getName(), c));
        int incomingSchemaColumnsSize = incomingSchemaColumns.size();
        for (int i = 0; i < incomingSchemaColumnsSize; ++i) {
            ColumnSchema incomingSchemaColumn = incomingSchemaColumns.get(i);
            ColumnSchema realSchemaColumn = (ColumnSchema)realSchemaMap.get(incomingSchemaColumn.getName());
            WrappedInsertStatement.validateTableSchema(incomingSchemaColumn, realSchemaColumn, i, innerTreeStatement);
        }
        List<ColumnSchema> realIdColumns = realSchema.getIdColumns();
        this.adjustIdColumns(realIdColumns, innerTreeStatement);
    }

    public void adjustIdColumns(List<ColumnSchema> realIdColumnSchemas, InsertBaseStatement baseStatement) {
        List<ColumnSchema> incomingColumnSchemas = this.toTableSchema(baseStatement).getColumns();
        for (int realIdColPos = 0; realIdColPos < realIdColumnSchemas.size(); ++realIdColPos) {
            ColumnSchema realColumn = realIdColumnSchemas.get(realIdColPos);
            int incomingIdColPos = incomingColumnSchemas.indexOf(realColumn);
            if (incomingIdColPos == -1) {
                baseStatement.insertColumn(realIdColPos, realColumn);
                incomingColumnSchemas.add(realIdColPos, realColumn);
                continue;
            }
            baseStatement.swapColumn(incomingIdColPos, realIdColPos);
            Collections.swap(incomingColumnSchemas, incomingIdColPos, realIdColPos);
        }
        this.tableSchema = null;
    }

    public static void processNonExistColumn(ColumnSchema incoming, InsertBaseStatement innerTreeStatement, int i) {
        SemanticException semanticException = new SemanticException("Column " + incoming.getName() + " does not exists or fails to be created", TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode());
        if (incoming.getColumnCategory() != TsTableColumnCategory.FIELD || !IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
            throw semanticException;
        }
        innerTreeStatement.markFailedMeasurement(i, (Exception)((Object)semanticException));
    }

    public static void processTypeConflictColumn(ColumnSchema incoming, ColumnSchema real, int i, InsertBaseStatement innerTreeStatement) {
        SemanticException semanticException = new SemanticException(String.format("Incompatible data type of column %s: %s/%s", incoming.getName(), incoming.getType(), real.getType()), TSStatusCode.DATA_TYPE_MISMATCH.getStatusCode());
        if (incoming.getColumnCategory() != TsTableColumnCategory.FIELD || !IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
            throw semanticException;
        }
        innerTreeStatement.markFailedMeasurement(i, (Exception)((Object)semanticException));
    }

    public static void validateTableSchema(ColumnSchema incoming, ColumnSchema real, int i, InsertBaseStatement innerTreeStatement) {
        if (real == null) {
            WrappedInsertStatement.processNonExistColumn(incoming, innerTreeStatement, i);
            return;
        }
        if (incoming.getType() == null || incoming.getColumnCategory() != TsTableColumnCategory.FIELD) {
            innerTreeStatement.setDataType(InternalTypeManager.getTSDataType(real.getType()), i);
        } else if (!InternalTypeManager.getTSDataType(real.getType()).isCompatible(InternalTypeManager.getTSDataType(incoming.getType())) && !innerTreeStatement.isForceTypeConversion()) {
            WrappedInsertStatement.processTypeConflictColumn(incoming, real, i, innerTreeStatement);
            return;
        }
        if (incoming.getColumnCategory() == null) {
            innerTreeStatement.setColumnCategory(real.getColumnCategory(), i);
        } else if (!incoming.getColumnCategory().equals((Object)real.getColumnCategory())) {
            throw new SemanticException(String.format("Inconsistent column category of column %s: %s/%s", incoming.getName(), incoming.getColumnCategory(), real.getColumnCategory()), TSStatusCode.COLUMN_CATEGORY_MISMATCH.getStatusCode());
        }
        TSDataType tsDataType = InternalTypeManager.getTSDataType(real.getType());
        MeasurementSchema measurementSchema = new MeasurementSchema(real.getName(), tsDataType, EncodingInferenceUtils.getDefaultEncoding(tsDataType), TSFileDescriptor.getInstance().getConfig().getCompressor(tsDataType));
        innerTreeStatement.setMeasurementSchema(measurementSchema, i);
        try {
            innerTreeStatement.selfCheckDataTypes(i);
        }
        catch (DataTypeMismatchException | PathNotExistException e) {
            throw new SemanticException(e);
        }
    }

    public void validateDeviceSchema(Metadata metadata, MPPQueryContext context) {
        metadata.validateDeviceSchema(this, context);
    }

    @Override
    public String getDatabase() {
        String databaseName = AnalyzeUtils.getDatabaseName(this.getInnerTreeStatement(), this.context);
        if (databaseName == null) {
            throw new SemanticException("database is not specified");
        }
        return databaseName;
    }

    public void toLowerCase() {
        this.getInnerTreeStatement().toLowerCase();
    }

    public void removeAttributeColumns() {
        this.getInnerTreeStatement().removeAttributeColumns();
    }
}

