/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.BackBinaryTVList;
import org.apache.iotdb.db.utils.datastructure.QuickBinaryTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.utils.datastructure.TimBinaryTVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TsPrimitiveType;

public abstract class BinaryTVList
extends TVList {
    protected List<Binary[]> values = new ArrayList<Binary[]>();

    BinaryTVList() {
    }

    public static BinaryTVList newList() {
        switch (PrimitiveArrayManager.TVLIST_SORT_ALGORITHM) {
            case QUICK: {
                return new QuickBinaryTVList();
            }
            case BACKWARD: {
                return new BackBinaryTVList();
            }
        }
        return new TimBinaryTVList();
    }

    @Override
    public synchronized BinaryTVList clone() {
        BinaryTVList cloneList = BinaryTVList.newList();
        this.cloneAs(cloneList);
        this.cloneBitMap(cloneList);
        for (Binary[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private Binary[] cloneValue(Binary[] array) {
        Binary[] cloneArray = new Binary[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public synchronized void putBinary(long timestamp, Binary value) {
        this.checkExpansion();
        int arrayIndex = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
        this.maxTime = Math.max(this.maxTime, timestamp);
        this.minTime = Math.min(this.minTime, timestamp);
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        if (this.indices != null) {
            ((int[])this.indices.get((int)arrayIndex))[elementIndex] = this.rowCount;
        }
        ++this.rowCount;
        if (this.sorted) {
            if (this.rowCount > 1 && timestamp < this.getTime(this.rowCount - 2)) {
                this.sorted = false;
            } else {
                ++this.seqRowCount;
            }
        }
    }

    @Override
    public Binary getBinary(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int valueIndex = this.getValueIndex(index);
        int arrayIndex = valueIndex / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = valueIndex % PrimitiveArrayManager.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    @Override
    protected void clearValue() {
        if (this.values != null) {
            for (Binary[] dataArray : this.values) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    protected void expandValues() {
        if (this.indices != null) {
            this.indices.add((int[])this.getPrimitiveArraysByType(TSDataType.INT32));
        }
        this.values.add((Binary[])this.getPrimitiveArraysByType(TSDataType.TEXT));
        if (this.bitMap != null) {
            this.bitMap.add(null);
        }
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)this.getBinary(index)));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.TEXT, (Object)this.getBinary(index)));
    }

    @Override
    protected void writeValidValuesIntoTsBlock(TsBlockBuilder builder, int floatPrecision, TSEncoding encoding, List<TimeRange> deletionList) {
        int[] deleteCursor = new int[]{0};
        for (int i = 0; i < this.rowCount; ++i) {
            if (this.isNullValue(this.getValueIndex(i)) || ModificationUtils.isPointDeleted(this.getTime(i), deletionList, deleteCursor) || i != this.rowCount - 1 && this.getTime(i) == this.getTime(i + 1)) continue;
            builder.getTimeColumnBuilder().writeLong(this.getTime(i));
            builder.getColumnBuilder(0).writeBinary(this.getBinary(i));
            builder.declarePosition();
        }
    }

    @Override
    public synchronized void putBinaries(long[] time, Binary[] value, BitMap bitMap, int start, int end) {
        this.checkExpansion();
        int idx = start;
        int timeIdxOffset = 0;
        if (bitMap != null && !bitMap.isAllUnmarked()) {
            long[] clonedTime = new long[end - start];
            System.arraycopy(time, start, clonedTime, 0, end - start);
            time = clonedTime;
            timeIdxOffset = start;
            Binary[] clonedValue = new Binary[value.length];
            System.arraycopy(value, 0, clonedValue, 0, value.length);
            value = clonedValue;
            int nullCnt = this.dropNullValThenUpdateMinMaxTimeAndSorted(time, value, bitMap, start, end, timeIdxOffset);
            end -= nullCnt;
        } else {
            this.updateMinMaxTimeAndSorted(time, start, end);
        }
        while (idx < end) {
            int[] indexes;
            int inputRemaining = end - idx;
            int arrayIdx = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                if (this.indices != null) {
                    indexes = IntStream.range(this.rowCount, this.rowCount + inputRemaining).toArray();
                    System.arraycopy(indexes, 0, this.indices.get(arrayIdx), elementIdx, inputRemaining);
                }
                this.rowCount += inputRemaining;
                break;
            }
            System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            if (this.indices != null) {
                indexes = IntStream.range(this.rowCount, this.rowCount + internalRemaining).toArray();
                System.arraycopy(indexes, 0, this.indices.get(arrayIdx), elementIdx, internalRemaining);
            }
            idx += internalRemaining;
            this.rowCount += internalRemaining;
            this.checkExpansion();
        }
    }

    int dropNullValThenUpdateMinMaxTimeAndSorted(long[] time, Binary[] values, BitMap bitMap, int start, int end, int tIdxOffset) {
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        int nullCnt = 0;
        int inputSeqRowCount = 0;
        for (int vIdx = start; vIdx < end; ++vIdx) {
            if (bitMap.isMarked(vIdx)) {
                ++nullCnt;
                continue;
            }
            int tIdx = vIdx - tIdxOffset;
            if (nullCnt != 0) {
                time[tIdx - nullCnt] = time[tIdx];
                values[vIdx - nullCnt] = values[vIdx];
            }
            inPutMinTime = Math.min(inPutMinTime, time[tIdx -= nullCnt]);
            this.maxTime = Math.max(this.maxTime, time[tIdx]);
            if (!inputSorted) continue;
            if (tIdx > 0 && time[tIdx - 1] > time[tIdx]) {
                inputSorted = false;
                continue;
            }
            ++inputSeqRowCount;
        }
        this.minTime = Math.min(this.minTime, inPutMinTime);
        if (this.sorted && (this.rowCount == 0 || end - start > nullCnt && time[start - tIdxOffset] >= this.getTime(this.rowCount - 1))) {
            this.seqRowCount += inputSeqRowCount;
        }
        this.sorted = this.sorted && inputSorted && (this.rowCount == 0 || inPutMinTime >= this.getTime(this.rowCount - 1));
        return nullCnt;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.TEXT;
    }

    @Override
    public int serializedSize() {
        int size = 5 + this.rowCount * 9;
        for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
            size += ReadWriteIOUtils.sizeToWrite((Binary)this.getBinary(rowIdx));
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        WALWriteUtils.write(TSDataType.TEXT, buffer);
        buffer.putInt(this.rowCount);
        for (int rowIdx = 0; rowIdx < this.rowCount; ++rowIdx) {
            buffer.putLong(this.getTime(rowIdx));
            Binary valueT = this.getBinary(rowIdx);
            if (valueT != null) {
                WALWriteUtils.write(this.getBinary(rowIdx), buffer);
            } else {
                WALWriteUtils.write(new Binary(new byte[0]), buffer);
            }
            WALWriteUtils.write(this.isNullValue(this.getValueIndex(rowIdx)), buffer);
        }
    }

    public static BinaryTVList deserialize(DataInputStream stream) throws IOException {
        BinaryTVList tvList = BinaryTVList.newList();
        int rowCount = stream.readInt();
        long[] times = new long[rowCount];
        Binary[] values = new Binary[rowCount];
        BitMap bitMap = new BitMap(rowCount);
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            times[rowIdx] = stream.readLong();
            values[rowIdx] = ReadWriteIOUtils.readBinary((InputStream)stream);
            if (!ReadWriteIOUtils.readBool((InputStream)stream)) continue;
            bitMap.mark(rowIdx);
        }
        tvList.putBinaries(times, values, bitMap, 0, rowCount);
        return tvList;
    }

    public static BinaryTVList deserializeWithoutBitMap(DataInputStream stream) throws IOException {
        BinaryTVList tvList = BinaryTVList.newList();
        int rowCount = stream.readInt();
        long[] times = new long[rowCount];
        Binary[] values = new Binary[rowCount];
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            times[rowIdx] = stream.readLong();
            values[rowIdx] = ReadWriteIOUtils.readBinary((InputStream)stream);
        }
        tvList.putBinaries(times, values, null, 0, rowCount);
        return tvList;
    }
}

