/*
 * Copyright (c) 2017 Ahome' Innovation Technologies. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ait.lienzo.test.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Lienzo's JSO fully qualified class names to be mocked.
 * <p>
 * NOTE: Use <code>$</code> as the inner class separator character on the fqcn.
 *
 * @author Roger Martinez
 * @See com.ait.lienzo.test.annotation.Settings#mocks
 * @since 1.0
 */
@Retention(RUNTIME)
@Target(TYPE)
public @interface Mocks {

    public String[] value();
}
