/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */
package org.kie.workbench.common.dmn.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public class DMNEditorConstants {

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_ReturnToLink = "ExpressionEditor.ReturnToLink";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_ExpressionTypeText = "ExpressionEditor.ExpressionTypeText";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_UndefinedExpressionType = "ExpressionEditor.UndefinedExpressionType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_LiteralExpressionType = "ExpressionEditor.LiteralExpressionType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_ContextExpressionType = "ExpressionEditor.ContextExpressionType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_DecisionTableExpressionType = "ExpressionEditor.DecisionTableExpressionType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_RelationType = "ExpressionEditor.RelationType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_FunctionType = "ExpressionEditor.FunctionType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_PMMLFunctionType = "ExpressionEditor.PMMLFunctionType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_JavaFunctionType = "ExpressionEditor.JavaFunctionType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_InvocationType = "ExpressionEditor.InvocationType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_ListType = "ExpressionEditor.ListType";

    @TranslationKey(defaultValue = "")
    public static final String ExpressionEditor_Clear = "ExpressionEditor.Clear";

    @TranslationKey(defaultValue = "")
    public static final String LiteralExpression_EditExpression = "LiteralExpression.EditExpression";

    @TranslationKey(defaultValue = "")
    public static final String ContextEditor_Header = "ContextEditor.Header";

    @TranslationKey(defaultValue = "")
    public static final String ContextEditor_InsertContextEntry = "ContextEditor.InsertContextEntry";

    @TranslationKey(defaultValue = "")
    public static final String ContextEditor_InsertContextEntryAbove = "ContextEditor.InsertContextEntryAbove";

    @TranslationKey(defaultValue = "")
    public static final String ContextEditor_InsertContextEntryBelow = "ContextEditor.InsertContextEntryBelow";

    @TranslationKey(defaultValue = "")
    public static final String ContextEditor_DeleteContextEntry = "ContextEditor.DeleteContextEntry";

    @TranslationKey(defaultValue = "")
    public static final String ContextEditor_EditExpression = "ContextEditor.EditExpression";

    @TranslationKey(defaultValue = "")
    public static final String ContextEditor_EditContextEntry = "ContextEditor.EditContextEntry";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_HeaderRows = "RelationEditor.HeaderRows";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_InsertRowAbove = "RelationEditor.InsertRowAbove";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_InsertRowBelow = "RelationEditor.InsertRowBelow";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_DeleteRow = "RelationEditor.DeleteRow";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_HeaderColumns = "RelationEditor.HeaderColumns";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_InsertColumnLeft = "RelationEditor.InsertColumnLeft";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_InsertColumnRight = "RelationEditor.InsertColumnRight";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_DeleteColumn = "RelationEditor.DeleteColumn";

    @TranslationKey(defaultValue = "")
    public static final String RelationEditor_EditRelation = "RelationEditor.EditRelation";

    @TranslationKey(defaultValue = "")
    public static final String InvocationEditor_Header = "InvocationEditor.Header";

    @TranslationKey(defaultValue = "")
    public static final String InvocationEditor_InsertParameter = "InvocationEditor.InsertParameter";

    @TranslationKey(defaultValue = "")
    public static final String InvocationEditor_InsertParameterAbove = "InvocationEditor.InsertParameterAbove";

    @TranslationKey(defaultValue = "")
    public static final String InvocationEditor_InsertParameterBelow = "InvocationEditor.InsertParameterBelow";

    @TranslationKey(defaultValue = "")
    public static final String InvocationEditor_DeleteParameter = "InvocationEditor.DeleteParameter";

    @TranslationKey(defaultValue = "")
    public static final String InvocationEditor_EditExpression = "InvocationEditor.EditExpression";

    @TranslationKey(defaultValue = "")
    public static final String InvocationEditor_EditParameter = "InvocationEditor.EditParameter";

    @TranslationKey(defaultValue = "")
    public static final String InvocationEditor_EnterFunction = "InvocationEditor.EnterFunction";

    @TranslationKey(defaultValue = "")
    public static final String ListEditor_HeaderRows = "ListEditor.HeaderRows";

    @TranslationKey(defaultValue = "")
    public static final String ListEditor_InsertRowAbove = "ListEditor.InsertRowAbove";

    @TranslationKey(defaultValue = "")
    public static final String ListEditor_InsertRowBelow = "ListEditor.InsertRowBelow";

    @TranslationKey(defaultValue = "")
    public static final String ListEditor_DeleteRow = "ListEditor.DeleteRow";

    @TranslationKey(defaultValue = "")
    public static final String ListEditor_EditExpression = "ListEditor.EditExpression";

    @TranslationKey(defaultValue = "")
    public static final String FunctionEditor_FEEL = "FunctionEditor.FEEL";

    @TranslationKey(defaultValue = "")
    public static final String FunctionEditor_JAVA = "FunctionEditor.JAVA";

    @TranslationKey(defaultValue = "")
    public static final String FunctionEditor_PMML = "FunctionEditor.PMML";

    @TranslationKey(defaultValue = "")
    public static final String FunctionEditor_Undefined = "FunctionEditor.Undefined";

    @TranslationKey(defaultValue = "")
    public static final String FunctionEditor_EditExpression = "FunctionEditor.EditExpression";

    @TranslationKey(defaultValue = "")
    public static final String FunctionEditor_EditParameters = "FunctionEditor.EditParameters";

    @TranslationKey(defaultValue = "")
    public static final String FunctionEditor_EditParametersTitle = "FunctionEditor.EditParametersTitle";

    @TranslationKey(defaultValue = "")
    public static final String FunctionEditor_SelectFunctionKind = "FunctionEditor.SelectFunctionKind";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_DecisionRuleHeader = "DecisionTableEditor.DecisionRuleHeader";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InsertDecisionRuleAbove = "DecisionTableEditor.InsertDecisionRuleAbove";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InsertDecisionRuleBelow = "DecisionTableEditor.InsertDecisionRuleBelow";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_DeleteDecisionRule = "DecisionTableEditor.DeleteDecisionRule";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_DuplicateDecisionRule = "DecisionTableEditor.DuplicateDecisionRule";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InputClauseHeader = "DecisionTableEditor.InputClauseHeader";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InsertInputClauseLeft = "DecisionTableEditor.InsertInputClauseLeft";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InsertInputClauseRight = "DecisionTableEditor.InsertInputClauseRight";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_DeleteInputClause = "DecisionTableEditor.DeleteInputClause";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_OutputClauseHeader = "DecisionTableEditor.OutputClauseHeader";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_RuleAnnotationClauseHeader = "DecisionTableEditor.RuleAnnotationClauseHeader";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InsertRuleAnnotationClauseLeft = "DecisionTableEditor.InsertRuleAnnotationClauseLeft";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InsertRuleAnnotationClauseRight = "DecisionTableEditor.InsertRuleAnnotationClauseRight";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_DeleteRuleAnnotationClause = "DecisionTableEditor.DeleteRuleAnnotationClause";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InsertOutputClauseLeft = "DecisionTableEditor.InsertOutputClauseLeft";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InsertOutputClauseRight = "DecisionTableEditor.InsertOutputClauseRight";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_DeleteOutputClause = "DecisionTableEditor.DeleteOutputClause";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_NullBuiltinAggregator = "DecisionTableEditor.NullBuiltinAggregator";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_EditHitPolicy = "DecisionTableEditor.EditHitPolicy";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_EditInputClause = "DecisionTableEditor.EditInputClause";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_EditOutputClause = "DecisionTableEditor.EditOutputClause";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_HitPolicyLabel = "DecisionTableEditor.HitPolicyLabel";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_BuiltinAggregatorLabel = "DecisionTableEditor.BuiltinAggregatorLabel";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_EnterAnnotation = "DecisionTableEditor.EnterAnnotation";

    @TranslationKey(defaultValue = "")
    public static final String DecisionTableEditor_InputClauseColumnHeaderMetaData_ValueLabel = "DecisionTableEditor.InputClauseColumnHeaderMetaData.ValueLabel";

    @TranslationKey(defaultValue = "")
    public static final String UndefinedExpressionEditor_SelectorTitle = "UndefinedExpressionEditor.SelectorTitle";

    @TranslationKey(defaultValue = "")
    public static final String UndefinedExpressionEditor_SelectExpression = "UndefinedExpressionEditor.SelectExpression";

    @TranslationKey(defaultValue = "")
    public static final String DecisionNavigatorPresenter_DecisionNavigator = "DecisionNavigatorPresenter.DecisionNavigator";

    @TranslationKey(defaultValue = "")
    public static final String DecisionNavigatorBaseItemFactory_NoName = "DecisionNavigatorBaseItemFactory.NoName";

    @TranslationKey(defaultValue = "")
    public static final String TypePickerWidget_Choose = "TypePickerWidget.Choose";

    @TranslationKey(defaultValue = "")
    public static final String TypePickerWidget_Manage = "TypePickerWidget.Manage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeManager_None = "DataTypeManager.None";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeManager_Structure = "DataTypeManager.Structure";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeSelectView_DefaultTitle = "DataTypeSelectView.DefaultTitle";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeSelectView_CustomTitle = "DataTypeSelectView.CustomTitle";

    @TranslationKey(defaultValue = "")
    public static final String NameAndDataTypePopover_NameLabel = "NameAndDataTypePopover.NameLabel";

    @TranslationKey(defaultValue = "")
    public static final String NameAndDataTypePopover_DataTypeLabel = "NameAndDataTypePopover.DataTypeLabel";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeNameIsBlankErrorMessage_StrongMessage = "DataTypeNameIsBlankErrorMessage.StrongMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeNameIsBlankErrorMessage_RegularMessage = "DataTypeNameIsBlankErrorMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeNameIsInvalidErrorMessage_StrongMessage = "DataTypeNameIsInvalidErrorMessage.StrongMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeNameIsInvalidErrorMessage_RegularMessage = "DataTypeNameIsInvalidErrorMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeNameIsNotUniqueErrorMessage_StrongMessage = "DataTypeNameIsNotUniqueErrorMessage.StrongMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeNameIsNotUniqueErrorMessage_RegularMessage = "DataTypeNameIsNotUniqueErrorMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeWithFieldsWarningMessage_StrongMessage = "DataTypeWithFieldsWarningMessage.StrongMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeWithFieldsWarningMessage_RegularMessage = "DataTypeWithFieldsWarningMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeSuccessfullyImportedMessage_StrongMessage = "DataTypeSuccessfullyImportedMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String ReferencedDataTypeWarningMessage_StrongMessage = "ReferencedDataTypeWarningMessage.StrongMessage";

    @TranslationKey(defaultValue = "")
    public static final String ReferencedDataTypeWarningMessage_RegularMessage = "ReferencedDataTypeWarningMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeNameIsDefaultTypeMessage_StrongMessage = "DataTypeNameIsDefaultTypeMessage.StrongMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeNameIsDefaultTypeMessage_RegularMessage = "DataTypeNameIsDefaultTypeMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeConstraintView_ConstraintsTooltip = "DataTypeConstraintView.ConstraintsTooltip";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeConstraintView_AddConstraints = "DataTypeConstraintView.AddConstraints";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeListItemView_ArrowKeysTooltip = "DataTypeListItemView.ArrowKeysTooltip";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeListItemView_Edit = "DataTypeListItemView.Edit";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeListItemView_Save = "DataTypeListItemView.Save";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeListItemView_AddRowBelow = "DataTypeListItemView.AddRowBelow";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeListItemView_Remove = "DataTypeListItemView.Remove";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeListItemView_Cancel = "DataTypeListItemView.Cancel";

    @TranslationKey(defaultValue = "")
    public static final String DataTypesPage_Title = "DataTypesPage.Title";

    @TranslationKey(defaultValue = "")
    public static final String IncludedModelsPage_Title = "IncludedModelsPage.Title";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeSearchBarView_Search = "DataTypeSearchBarView.Search";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeConstraintExpressionView_Placeholder = "DataTypeConstraintExpressionView.Placeholder";

    @TranslationKey(defaultValue = "")
    public static final String DataTypeConstraintEnumerationItemView_None = "DataTypeConstraintEnumerationItemView.None";

    @TranslationKey(defaultValue = "")
    public static final String ConstraintPlaceholderHelper_SentenceDefault = "ConstraintPlaceholderHelper.SentenceDefault";

    @TranslationKey(defaultValue = "")
    public static final String ConstraintPlaceholderHelper_SampleDefault = "ConstraintPlaceholderHelper.SampleDefault";

    @TranslationKey(defaultValue = "")
    public static final String IncludedModelNameIsNotUniqueErrorMessage_StrongMessage = "IncludedModelNameIsNotUniqueErrorMessage.StrongMessage";

    @TranslationKey(defaultValue = "")
    public static final String IncludedModelNameIsNotUniqueErrorMessage_RegularMessage = "IncludedModelNameIsNotUniqueErrorMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String IncludedModelNameIsBlankErrorMessage_StrongMessage = "IncludedModelNameIsBlankErrorMessage.StrongMessage";

    @TranslationKey(defaultValue = "")
    public static final String IncludedModelNameIsBlankErrorMessage_RegularMessage = "IncludedModelNameIsBlankErrorMessage.RegularMessage";

    @TranslationKey(defaultValue = "")
    public static final String DayTimeValueConverter_Days = "DayTimeValueConverter.Days";

    @TranslationKey(defaultValue = "")
    public static final String DayTimeValueConverter_Hours = "DayTimeValueConverter.Hours";

    @TranslationKey(defaultValue = "")
    public static final String DayTimeValueConverter_Minutes = "DayTimeValueConverter.Minutes";

    @TranslationKey(defaultValue = "")
    public static final String DayTimeValueConverter_Seconds = "DayTimeValueConverter.Seconds";

    @TranslationKey(defaultValue = "")
    public static final String DayTimeValueConverter_Day = "DayTimeValueConverter.Day";

    @TranslationKey(defaultValue = "")
    public static final String DayTimeValueConverter_Hour = "DayTimeValueConverter.Hour";

    @TranslationKey(defaultValue = "")
    public static final String DayTimeValueConverter_Minute = "DayTimeValueConverter.Minute";

    @TranslationKey(defaultValue = "")
    public static final String DayTimeValueConverter_Second = "DayTimeValueConverter.Second";

    @TranslationKey(defaultValue = "")
    public static final String DecisionComponentsView_EnterText = "DecisionComponentsView.EnterText";

    @TranslationKey(defaultValue = "")
    public static final String DecisionComponentsItemView_DuplicatedNode = "DecisionComponentsItemView.DuplicatedNode";

    @TranslationKey(defaultValue = "")
    public static final String LiteralExpressionPMMLDocumentEditorDefinition_Placeholder = "LiteralExpressionPMMLDocumentEditorDefinition.Placeholder";

    @TranslationKey(defaultValue = "")
    public static final String LiteralExpressionPMMLDocumentModelEditorDefinition_Placeholder = "LiteralExpressionPMMLDocumentModelEditorDefinition.Placeholder";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_DmnModelDocumentation = "DMNDocumentationI18n.DmnModelDocumentation";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_GeneratedOn = "DMNDocumentationI18n.GeneratedOn";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_GeneratedBy = "DMNDocumentationI18n.GeneratedBy";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_GeneratedFrom = "DMNDocumentationI18n.GeneratedFrom";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_Namespace = "DMNDocumentationI18n.Namespace";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_TableOfContents = "DMNDocumentationI18n.TableOfContents";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_DmnModel = "DMNDocumentationI18n.DmnModel";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_DataTypes = "DMNDocumentationI18n.DataTypes";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_DrdComponents = "DMNDocumentationI18n.DrdComponents";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_NoDataTypes = "DMNDocumentationI18n.NoDataTypes";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_NoExternalLinks = "DMNDocumentationI18n.NoExternalLinks";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_ExternalLinks = "DMNDocumentationI18n.ExternalLinks";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_Question = "DMNDocumentationI18n.Question";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_AllowedAnswers = "DMNDocumentationI18n.AllowedAnswers";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_NoDRDs = "DMNDocumentationI18n.NoDRDs";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_DiagramDoesNotHaveElements = "DMNDocumentationI18n.DiagramDoesNotHaveElements";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_Add = "DMNDocumentationI18n.Add";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_None = "DMNDocumentationI18n.None";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_Name = "DMNDocumentationI18n.Name";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_NamePlaceholder = "DMNDocumentationI18n.NamePlaceholder";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_Ok = "DMNDocumentationI18n.Ok";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_Cancel = "DMNDocumentationI18n.Cancel";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_AttachmentTip = "DMNDocumentationI18n.AttachmentTip";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_URL = "DMNDocumentationI18n.URL";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationI18n_URLPlaceholder = "DMNDocumentationI18n.URLPlaceholder";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationFactory_Constraints = "DMNDocumentationFactory.Constraints";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationFactory_ListYes = "DMNDocumentationFactory.ListYes";

    @TranslationKey(defaultValue = "")
    public static final String DMNDocumentationFactory_Structure = "DMNDocumentationFactory.Structure";

    @TranslationKey(defaultValue = "")
    public static final String DMNPreviewDiagramDock_Title = "DMNPreviewDiagramDock.Title";

    @TranslationKey(defaultValue = "")
    public static final String DecisionServiceParameters_Inputs = "DecisionServiceParameters.Inputs";

    @TranslationKey(defaultValue = "")
    public static final String DecisionServiceParameters_Outputs = "DecisionServiceParameters.Outputs";

    @TranslationKey(defaultValue = "")
    public static final String DecisionServiceParameters_EncapsulatedDecisions = "DecisionServiceParameters.EncapsulatedDecisions";

    @TranslationKey(defaultValue = "")
    public static final String StructureTypesTooltipView_DescriptionStructured = "StructureTypesTooltipView.DescriptionStructured";

    @TranslationKey(defaultValue = "")
    public static final String StructureTypesTooltipView_DescriptionCustom = "StructureTypesTooltipView.DescriptionCustom";

    @TranslationKey(defaultValue = "")
    public static final String StructureTypesTooltipView_DescriptionIncluded = "StructureTypesTooltipView.DescriptionIncluded";

    @TranslationKey(defaultValue = "")
    public static final String StructureTypesTooltipView_ViewDataType = "StructureTypesTooltipView.ViewDataType";

    @TranslationKey(defaultValue = "")
    public static final String AutomaticLayout_Label = "AutomaticLayout.Label";

    @TranslationKey(defaultValue = "")
    public static final String AutomaticLayout_DiagramDoesNotHaveLayout = "AutomaticLayout.DiagramDoesNotHaveLayout";

    @TranslationKey(defaultValue = "")
    public static final String DMNMarshaller_UnsupportedMessageTitle = "DMNMarshaller.UnsupportedMessageTitle";

    @TranslationKey(defaultValue = "")
    public static final String DMNMarshaller_UnsupportedMessage = "DMNMarshaller.UnsupportedMessage";
}
