/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.exception.handler.replacement;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.security.authentication.AuthorizationException;
import io.micronaut.security.authentication.DefaultAuthorizationExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;

@Singleton
@Replaces(value=DefaultAuthorizationExceptionHandler.class)
@Requires(classes={AuthorizationException.class, ExceptionHandler.class})
public class DefaultAuthorizationExceptionHandlerReplacement
extends DefaultAuthorizationExceptionHandler {
    protected MutableHttpResponse<? extends Problem> httpResponseWithStatus(HttpRequest<?> request, AuthorizationException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(exception.isForbidden() ? HttpCode.FORBIDDEN : HttpCode.UNAUTHORIZED));
    }
}

