/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.GridNioException;
import org.apache.ignite.internal.util.nio.GridNioFilterAdapter;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;

public class GridConnectionBytesVerifyFilter
extends GridNioFilterAdapter {
    private static final int MAGIC_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private static final int MAGIC_BUF_KEY = GridNioSessionMetaKey.nextUniqueKey();
    private IgniteLogger log;

    public GridConnectionBytesVerifyFilter(IgniteLogger log) {
        super("GridConnectionBytesVerifyFilter");
        this.log = log;
    }

    @Override
    public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionOpened(ses);
    }

    @Override
    public void onSessionClosed(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionClosed(ses);
    }

    @Override
    public void onExceptionCaught(GridNioSession ses, IgniteCheckedException ex) throws IgniteCheckedException {
        this.proceedExceptionCaught(ses, ex);
    }

    @Override
    public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg, boolean fut, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        return this.proceedSessionWrite(ses, msg, fut, ackC);
    }

    @Override
    public void onMessageReceived(GridNioSession ses, Object msg) throws IgniteCheckedException {
        if (!ses.accepted()) {
            this.proceedMessageReceived(ses, msg);
            return;
        }
        if (!(msg instanceof ByteBuffer)) {
            throw new GridNioException("Failed to decode incoming message (message should be a byte buffer, is filter properly placed?): " + msg.getClass());
        }
        ByteBuffer buf = (ByteBuffer)msg;
        Integer magic = (Integer)ses.meta(MAGIC_META_KEY);
        if (magic == null || magic < U.IGNITE_HEADER.length) {
            byte[] magicBuf = (byte[])ses.meta(MAGIC_BUF_KEY);
            if (magicBuf == null) {
                magicBuf = new byte[U.IGNITE_HEADER.length];
            }
            int magicRead = magic == null ? 0 : magic;
            int cnt = buf.remaining();
            buf.get(magicBuf, magicRead, Math.min(U.IGNITE_HEADER.length - magicRead, cnt));
            if (cnt + magicRead < U.IGNITE_HEADER.length) {
                ses.addMeta(MAGIC_META_KEY, cnt + magicRead);
                ses.addMeta(MAGIC_BUF_KEY, magicBuf);
            } else if (U.bytesEqual(magicBuf, 0, U.IGNITE_HEADER, 0, U.IGNITE_HEADER.length)) {
                ses.removeMeta(MAGIC_BUF_KEY);
                ses.addMeta(MAGIC_META_KEY, U.IGNITE_HEADER.length);
                this.proceedMessageReceived(ses, buf);
            } else {
                ses.close();
                LT.warn(this.log, "Unknown connection detected (is some other software connecting to this Ignite port?) [rmtAddr=" + ses.remoteAddress() + ", locAddr=" + ses.localAddress() + "]");
            }
        } else {
            this.proceedMessageReceived(ses, buf);
        }
    }

    @Override
    public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) throws IgniteCheckedException {
        return this.proceedSessionClose(ses);
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionIdleTimeout(ses);
    }

    @Override
    public void onSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionWriteTimeout(ses);
    }
}

