/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.handshake;

import java.util.UUID;
import org.apache.ignite.internal.network.handshake.HandshakeAction;

public class HandshakeResult {
    private final HandshakeAction action;
    private final String consistentId;
    private final UUID launchId;

    private HandshakeResult(UUID launchId, String consistentId, HandshakeAction action) {
        this.action = action;
        this.consistentId = consistentId;
        this.launchId = launchId;
    }

    public HandshakeAction action() {
        return this.action;
    }

    public String consistentId() {
        return this.consistentId;
    }

    public UUID launchId() {
        return this.launchId;
    }

    public static HandshakeResult fail() {
        return new HandshakeResult(null, null, HandshakeAction.FAIL);
    }

    public static HandshakeResult noOp() {
        return new HandshakeResult(null, null, HandshakeAction.NOOP);
    }

    public static HandshakeResult removeHandler(UUID launchId, String consistentId) {
        return new HandshakeResult(launchId, consistentId, HandshakeAction.REMOVE_HANDLER);
    }
}

