/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.table;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.StreamerReceiverSerializer;
import org.apache.ignite.internal.table.partition.HashPartition;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.partition.Partition;

public class ClientStreamerWithReceiverBatchSendRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteTables tables) {
        return ClientTableCommon.readTableAsync(in, tables).thenCompose(table -> {
            int partition = in.unpackInt();
            List deploymentUnits = in.unpackDeploymentUnits();
            boolean returnResults = in.unpackBoolean();
            int payloadElementCount = in.unpackInt();
            int payloadSize = in.unpackBinaryHeader();
            byte[] payloadArr = new byte[payloadSize + 4];
            ByteBuffer payloadBuf = ByteBuffer.wrap(payloadArr).order(ByteOrder.LITTLE_ENDIAN);
            payloadBuf.putInt(payloadElementCount);
            in.readPayload(payloadBuf);
            return ((CompletableFuture)table.partitionManager().primaryReplicaAsync((Partition)new HashPartition(partition)).thenCompose(node -> table.internalTable().streamerReceiverRunner().runReceiverAsync(payloadArr, node, deploymentUnits))).thenAccept(res -> StreamerReceiverSerializer.serializeReceiverResultsForClient((ClientMessagePacker)out, (byte[])((byte[])(returnResults ? res : null))));
        });
    }
}

