/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.chm.ChmAssert;
import org.apache.tika.parser.microsoft.chm.ChmLzxcResetTable;
import org.apache.tika.parser.microsoft.chm.ChmParsingException;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChmCommons {
    public static final int UNDEFINED = 0;
    public static final int VERBATIM = 1;
    public static final int ALIGNED_OFFSET = 2;
    public static final int UNCOMPRESSED = 3;
    private static final Logger LOG = LoggerFactory.getLogger(ChmCommons.class);

    private ChmCommons() {
    }

    public static void assertByteArrayNotNull(byte[] data) throws TikaException {
        if (data == null) {
            throw new TikaException("byte[] is null");
        }
    }

    public static int getWindowSize(int window) {
        int win = 0;
        while (window > 1) {
            window >>>= 1;
            ++win;
        }
        return win;
    }

    public static byte[] getChmBlockSegment(byte[] data, ChmLzxcResetTable resetTable, int blockNumber, int lzxcBlockOffset, int lzxcBlockLength) throws TikaException {
        ChmAssert.assertChmBlockSegment(data, resetTable, blockNumber, lzxcBlockOffset, lzxcBlockLength);
        int blockLength = -1;
        blockLength = blockNumber < resetTable.getBlockAddress().length - 1 ? (int)(resetTable.getBlockAddress()[blockNumber + 1] - resetTable.getBlockAddress()[blockNumber]) : (blockNumber >= resetTable.getBlockAddress().length ? 0 : (int)((long)lzxcBlockLength - resetTable.getBlockAddress()[blockNumber]));
        byte[] t = ChmCommons.copyOfRange(data, (int)((long)lzxcBlockOffset + resetTable.getBlockAddress()[blockNumber]), (int)((long)lzxcBlockOffset + resetTable.getBlockAddress()[blockNumber] + (long)blockLength));
        return t != null ? t : new byte[1];
    }

    public static String getLanguage(long langID) {
        switch ((int)langID) {
            case 1025: {
                return "Arabic";
            }
            case 1069: {
                return "Basque";
            }
            case 1027: {
                return "Catalan";
            }
            case 2052: {
                return "Chinese (Simplified)";
            }
            case 1028: {
                return "Chinese (Traditional)";
            }
            case 1029: {
                return "Czech";
            }
            case 1030: {
                return "Danish";
            }
            case 1043: {
                return "Dutch";
            }
            case 1033: {
                return "English (United States)";
            }
            case 1035: {
                return "Finnish";
            }
            case 1036: {
                return "French";
            }
            case 1031: {
                return "German";
            }
            case 1032: {
                return "Greek";
            }
            case 1037: {
                return "Hebrew";
            }
            case 1038: {
                return "Hungarian";
            }
            case 1040: {
                return "Italian";
            }
            case 1041: {
                return "Japanese";
            }
            case 1042: {
                return "Korean";
            }
            case 1044: {
                return "Norwegian";
            }
            case 1045: {
                return "Polish";
            }
            case 2070: {
                return "Portuguese";
            }
            case 1046: {
                return "Portuguese (Brazil)";
            }
            case 1049: {
                return "Russian";
            }
            case 1051: {
                return "Slovakian";
            }
            case 1060: {
                return "Slovenian";
            }
            case 3082: {
                return "Spanish";
            }
            case 1053: {
                return "Swedish";
            }
            case 1055: {
                return "Turkish";
            }
        }
        return "unknown - http://msdn.microsoft.com/en-us/library/bb165625%28VS.80%29.aspx";
    }

    public static boolean hasSkip(DirectoryListingEntry directoryListingEntry) {
        String name = directoryListingEntry.getName();
        return name.startsWith("/$") || name.startsWith("/#") || name.startsWith("::");
    }

    public static void writeFile(byte[][] buffer, String fileToBeSaved) throws TikaException {
        if (buffer == null || fileToBeSaved == null || ChmCommons.isEmpty(fileToBeSaved)) {
            return;
        }
        try (FileOutputStream output = new FileOutputStream(fileToBeSaved);){
            for (byte[] bufferEntry : buffer) {
                output.write(bufferEntry);
            }
        }
        catch (FileNotFoundException e) {
            throw new TikaException(e.getMessage());
        }
        catch (IOException e) {
            LOG.warn("problem writing tmp file", (Throwable)e);
        }
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static final int indexOfResetTableBlock(byte[] text, byte[] pattern) throws ChmParsingException {
        return ChmCommons.indexOfDataSpaceStorageElement(text, pattern) - 4;
    }

    public static int indexOfDataSpaceStorageElement(byte[] text, byte[] pattern) throws ChmParsingException {
        int[] next = null;
        int i = 0;
        int j = -1;
        if (pattern != null && text != null) {
            next = new int[pattern.length];
            next[0] = -1;
        } else {
            throw new ChmParsingException("pattern and/or text should not be null");
        }
        while (i < pattern.length - 1) {
            if (j == -1 || pattern[i] == pattern[j]) {
                if (pattern[++i] != pattern[++j]) {
                    next[i] = j;
                    continue;
                }
                next[i] = next[j];
                continue;
            }
            j = next[j];
        }
        j = 0;
        i = 0;
        while (i < text.length && j < pattern.length) {
            if (j == -1 || pattern[j] == text[i]) {
                ++i;
                ++j;
                continue;
            }
            j = next[j];
        }
        if (j == pattern.length) {
            return i - j;
        }
        return -1;
    }

    public static int indexOfDataSpaceStorageElement(List<DirectoryListingEntry> list, String pattern) {
        int place = 0;
        for (DirectoryListingEntry directoryListingEntry : list) {
            if (directoryListingEntry.getName().startsWith("::DataSpace/Storage") && directoryListingEntry.getName().contains(pattern)) {
                return place;
            }
            ++place;
        }
        return -1;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) throws TikaException {
        ChmCommons.checkCopyOfRangeParams(original, from, to);
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private static void checkCopyOfRangeParams(byte[] original, int from, int to) {
        if (original == null) {
            throw new NullPointerException("array is null");
        }
        if (from < 0) {
            throw new IllegalArgumentException(from + " should be > 0");
        }
        if (to < 0) {
            throw new IllegalArgumentException(to + " should be > 0");
        }
        if (to > original.length) {
            throw new IllegalArgumentException("can't copy beyond array length");
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static enum IntelState {
        STARTED,
        NOT_STARTED;

    }

    public static enum LzxState {
        STARTED_DECODING,
        NOT_STARTED_DECODING;

    }

    public static enum EntryType {
        UNCOMPRESSED,
        COMPRESSED;

    }
}

