/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAvroDeserializer
extends AbstractKafkaAvroDeserializer
implements Deserializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(KafkaAvroDeserializer.class);

    public KafkaAvroDeserializer() {
    }

    public KafkaAvroDeserializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
    }

    public KafkaAvroDeserializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, false);
    }

    public void configure(Map<String, ?> props, boolean isKey) {
        this.isKey = isKey;
        this.configure(this.deserializerConfig(props), null);
    }

    public KafkaAvroDeserializer(SchemaRegistryClient client, Map<String, ?> props, boolean isKey) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
        this.isKey = isKey;
        String specificAvroClassLookupKey = isKey ? "specific.avro.key.type" : "specific.avro.value.type";
        KafkaAvroDeserializerConfig config = this.deserializerConfig(props);
        Class type = config.getClass(specificAvroClassLookupKey);
        if (type != null && !config.getBoolean("specific.avro.reader").booleanValue() && log.isWarnEnabled()) {
            log.warn(String.format("'%s' value of '%s' is ignored because '%s' is false", specificAvroClassLookupKey, type.getName(), "specific.avro.reader"));
        }
        if (type != null && !SpecificRecord.class.isAssignableFrom(type)) {
            throw new ConfigException(String.format("Value '%s' specified for '%s' is not a '%s'", type.getName(), specificAvroClassLookupKey, SpecificRecord.class.getName()));
        }
        this.configure(this.deserializerConfig(props), type);
    }

    public Object deserialize(String topic, byte[] bytes) {
        return this.deserialize(topic, null, bytes);
    }

    public Object deserialize(String topic, Headers headers, byte[] bytes) {
        return this.deserialize(topic, this.isKey, headers, bytes, this.specificAvroReaderSchema);
    }

    public Object deserialize(String topic, byte[] bytes, Schema readerSchema) {
        return this.deserialize(topic, this.isKey, bytes, readerSchema);
    }

    public Object deserialize(String topic, Headers headers, byte[] bytes, Schema readerSchema) {
        return this.deserialize(topic, this.isKey, headers, bytes, readerSchema);
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while closing deserializer", e);
        }
    }
}

