/*
 * Decompiled with CFR 0.152.
 */
package waffle.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.jaas.RolePrincipal;
import waffle.jaas.UserPrincipal;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class WindowsLoginModule
implements LoginModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsLoginModule.class);
    private String username;
    private boolean debug;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private IWindowsAuthProvider auth = new WindowsAuthProviderImpl();
    private Set<Principal> principals;
    private PrincipalFormat principalFormat = PrincipalFormat.FQN;
    private PrincipalFormat roleFormat = PrincipalFormat.FQN;
    private boolean allowGuestLogin = true;

    @Override
    public void initialize(Subject initSubject, CallbackHandler initCallbackHandler, Map<String, ?> initSharedState, Map<String, ?> initOptions) {
        this.subject = initSubject;
        this.callbackHandler = initCallbackHandler;
        for (Map.Entry<String, ?> option : initOptions.entrySet()) {
            if (option.getKey().equalsIgnoreCase("debug")) {
                this.debug = Boolean.parseBoolean((String)option.getValue());
                continue;
            }
            if (option.getKey().equalsIgnoreCase("principalFormat")) {
                this.principalFormat = PrincipalFormat.valueOf(((String)option.getValue()).toUpperCase(Locale.ENGLISH));
                continue;
            }
            if (!option.getKey().equalsIgnoreCase("roleFormat")) continue;
            this.roleFormat = PrincipalFormat.valueOf(((String)option.getValue()).toUpperCase(Locale.ENGLISH));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        IWindowsIdentity windowsIdentity;
        String password;
        String userName;
        if (this.callbackHandler == null) {
            throw new LoginException("Missing callback to gather information from the user.");
        }
        NameCallback usernameCallback = new NameCallback("user name: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        Callback[] callbacks = new Callback[]{usernameCallback, passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
            userName = usernameCallback.getName();
            password = passwordCallback.getPassword() == null ? "" : new String(passwordCallback.getPassword());
            passwordCallback.clearPassword();
        }
        catch (IOException e) {
            LOGGER.trace("{}", (Throwable)e);
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            LOGGER.trace("{}", (Throwable)e);
            throw new LoginException("Callback {} not available to gather authentication information from the user.".replace("{}", e.getCallback().getClass().getName()));
        }
        try {
            windowsIdentity = this.auth.logonUser(userName, password);
        }
        catch (Exception e) {
            LOGGER.trace("{}", (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        try {
            if (!this.allowGuestLogin && windowsIdentity.isGuest()) {
                LOGGER.debug("guest login disabled: {}", (Object)windowsIdentity.getFqn());
                throw new LoginException("Guest login disabled");
            }
            this.principals = new LinkedHashSet<Principal>();
            this.principals.addAll(WindowsLoginModule.getUserPrincipals(windowsIdentity, this.principalFormat));
            if (this.roleFormat != PrincipalFormat.NONE) {
                for (IWindowsAccount group : windowsIdentity.getGroups()) {
                    this.principals.addAll(WindowsLoginModule.getRolePrincipals(group, this.roleFormat));
                }
            }
            this.username = windowsIdentity.getFqn();
            LOGGER.debug("successfully logged in {} ({})", (Object)this.username, (Object)windowsIdentity.getSidString());
        }
        finally {
            windowsIdentity.dispose();
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principals == null) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject cannot be read-only.");
        }
        Set<Principal> principalsSet = this.subject.getPrincipals();
        principalsSet.addAll(this.principals);
        LOGGER.debug("committing {} principals", (Object)this.subject.getPrincipals().size());
        if (this.debug) {
            for (Principal principal : principalsSet) {
                LOGGER.debug(" principal: {}", (Object)principal.getName());
            }
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject cannot be read-only.");
        }
        this.subject.getPrincipals().clear();
        if (this.username != null) {
            LOGGER.debug("logging out {}", (Object)this.username);
        }
        return true;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public IWindowsAuthProvider getAuth() {
        return this.auth;
    }

    public void setAuth(IWindowsAuthProvider provider) {
        this.auth = provider;
    }

    private static List<Principal> getUserPrincipals(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat) {
        ArrayList<Principal> principalsList = new ArrayList<Principal>();
        switch (principalFormat) {
            case FQN: {
                principalsList.add(new UserPrincipal(windowsIdentity.getFqn()));
                break;
            }
            case SID: {
                principalsList.add(new UserPrincipal(windowsIdentity.getSidString()));
                break;
            }
            case BOTH: {
                principalsList.add(new UserPrincipal(windowsIdentity.getFqn()));
                principalsList.add(new UserPrincipal(windowsIdentity.getSidString()));
                break;
            }
            case NONE: {
                break;
            }
        }
        return principalsList;
    }

    private static List<Principal> getRolePrincipals(IWindowsAccount group, PrincipalFormat principalFormat) {
        ArrayList<Principal> principalsList = new ArrayList<Principal>();
        switch (principalFormat) {
            case FQN: {
                principalsList.add(new RolePrincipal(group.getFqn()));
                break;
            }
            case SID: {
                principalsList.add(new RolePrincipal(group.getSidString()));
                break;
            }
            case BOTH: {
                principalsList.add(new RolePrincipal(group.getFqn()));
                principalsList.add(new RolePrincipal(group.getSidString()));
                break;
            }
            case NONE: {
                break;
            }
        }
        return principalsList;
    }

    public boolean isAllowGuestLogin() {
        return this.allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean value) {
        this.allowGuestLogin = value;
    }
}

