/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.common.collect.ImmutableBiMap;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import autovalue.shaded.com.google.common.collect.Maps;
import autovalue.shaded.com.google.common.collect.Sets;
import com.google.auto.value.processor.AutoValueProcessor;
import com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.Nullables;
import java.util.AbstractCollection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class BuilderMethodClassifierForAutoValue
extends BuilderMethodClassifier<ExecutableElement> {
    private final ErrorReporter errorReporter;
    private final ImmutableBiMap<ExecutableElement, String> getterToPropertyName;
    private final ImmutableMap<String, ExecutableElement> getterNameToGetter;
    private final TypeMirror builtType;

    private BuilderMethodClassifierForAutoValue(ErrorReporter errorReporter, ProcessingEnvironment processingEnv, TypeMirror builtType, TypeElement builderType, ImmutableBiMap<ExecutableElement, String> getterToPropertyName, ImmutableMap<String, TypeMirror> rewrittenPropertyTypes, Nullables nullables) {
        super(errorReporter, processingEnv, builtType, builderType, rewrittenPropertyTypes, ImmutableSet.of(), nullables);
        this.errorReporter = errorReporter;
        this.getterToPropertyName = getterToPropertyName;
        this.getterNameToGetter = Maps.uniqueIndex(getterToPropertyName.keySet(), m -> m.getSimpleName().toString());
        this.builtType = builtType;
    }

    static Optional<BuilderMethodClassifier<ExecutableElement>> classify(Iterable<ExecutableElement> methods, ErrorReporter errorReporter, ProcessingEnvironment processingEnv, TypeElement autoValueClass, TypeElement builderType, ImmutableBiMap<ExecutableElement, String> getterToPropertyName, ImmutableMap<String, TypeMirror> rewrittenPropertyTypes, Nullables nullables, boolean autoValueHasToBuilder) {
        BuilderMethodClassifierForAutoValue classifier = new BuilderMethodClassifierForAutoValue(errorReporter, processingEnv, autoValueClass.asType(), builderType, getterToPropertyName, rewrittenPropertyTypes, nullables);
        if (classifier.classifyMethods(methods, autoValueHasToBuilder)) {
            return Optional.of(classifier);
        }
        return Optional.empty();
    }

    @Override
    TypeMirror originalPropertyType(ExecutableElement propertyElement) {
        return propertyElement.getReturnType();
    }

    @Override
    String propertyString(ExecutableElement propertyElement) {
        TypeElement type = MoreElements.asType(propertyElement.getEnclosingElement());
        return "property method " + type.getQualifiedName() + "." + propertyElement.getSimpleName() + "()";
    }

    @Override
    ImmutableBiMap<String, ExecutableElement> propertyElements() {
        return this.getterToPropertyName.inverse();
    }

    @Override
    Optional<String> propertyForBuilderGetter(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return Optional.ofNullable(this.getterNameToGetter.get(methodName)).map(this.getterToPropertyName::get);
    }

    @Override
    void checkForFailedJavaBean(ExecutableElement rejectedSetter) {
        Set allGetters = this.getterToPropertyName.keySet();
        ImmutableSet<ExecutableElement> prefixedGetters = AutoValueProcessor.prefixedGettersIn(allGetters);
        if (prefixedGetters.size() < ((AbstractCollection)((Object)allGetters)).size() && prefixedGetters.size() >= ((AbstractCollection)((Object)allGetters)).size() / 2) {
            this.errorReporter.reportNote(rejectedSetter, "This might be because you are using the getFoo() convention for some but not all methods. These methods don't follow the convention: %s", Sets.difference(allGetters, prefixedGetters));
        }
    }

    @Override
    String autoWhat() {
        return "AutoValue";
    }

    @Override
    String getterMustMatch() {
        return "a property method of " + this.builtType;
    }

    @Override
    String fooBuilderMustMatch() {
        return "foo() or getFoo()";
    }
}

