/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BitSetCoder
extends AtomicCoder<BitSet> {
    private static final @UnknownKeyFor @NonNull @Initialized BitSetCoder INSTANCE = new BitSetCoder();
    private static final @UnknownKeyFor @NonNull @Initialized ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

    private BitSetCoder() {
    }

    public static @UnknownKeyFor @NonNull @Initialized BitSetCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized BitSet value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized BitSet value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream,  @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null BitSet");
        }
        BYTE_ARRAY_CODER.encodeAndOwn(value.toByteArray(), outStream, context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BitSet decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BitSet decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream,  @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return BitSet.valueOf(BYTE_ARRAY_CODER.decode(inStream, context));
    }

    @Override
    public void verifyDeterministic() throws  @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        BitSetCoder.verifyDeterministic(this, "BitSetCoder requires its ByteArrayCoder to be deterministic.", BYTE_ARRAY_CODER);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }
}

