/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PacketExtInfo {
    private byte[] payload;
    private final Map<String, String> extNameToValue;

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter tw = new TypesWriter();
            tw.writeByte(7);
            tw.writeUINT32(this.extNameToValue.size());
            for (Map.Entry<String, String> nameAndValue : this.extNameToValue.entrySet()) {
                tw.writeString(nameAndValue.getKey());
                tw.writeString(nameAndValue.getValue());
            }
            this.payload = tw.getBytes();
        }
        return this.payload;
    }

    public Map<String, String> getExtNameToValue() {
        return this.extNameToValue;
    }

    public PacketExtInfo(byte[] payload, int off, int len) throws IOException {
        this.payload = new byte[len];
        System.arraycopy(payload, off, this.payload, 0, len);
        TypesReader tr = new TypesReader(payload, off, len);
        int packet_type = tr.readByte();
        if (packet_type != 7) {
            throw new IOException("This is not a SSH_MSG_EXT_INFO! (" + packet_type + ")");
        }
        int numExtensions = tr.readUINT32();
        if (numExtensions >= 1024) {
            throw new IOException("Too many entries in ext info packet");
        }
        HashMap<String, String> extNameToValue_ = new HashMap<String, String>(numExtensions);
        for (int i = 0; i < numExtensions; ++i) {
            String name = tr.readString();
            String value = tr.readString();
            extNameToValue_.put(name, value);
        }
        this.extNameToValue = Collections.unmodifiableMap(extNameToValue_);
        if (tr.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_EXT_INFO packet!");
        }
    }

    public PacketExtInfo(Map<String, String> extNameToValue) {
        this.extNameToValue = Collections.unmodifiableMap(new HashMap<String, String>(extNameToValue));
    }
}

