/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class IntegerSerializer
extends TypeSerializer<BigInteger> {
    public static final IntegerSerializer instance = new IntegerSerializer();

    @Override
    public <V> BigInteger deserialize(V value, ValueAccessor<V> accessor) {
        return !accessor.isEmpty(value) ? new BigInteger(accessor.toArray(value)) : null;
    }

    @Override
    public ByteBuffer serialize(BigInteger value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(value.toByteArray());
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
    }

    @Override
    public String toString(BigInteger value) {
        return value == null ? "" : value.toString(10);
    }

    @Override
    public Class<BigInteger> getType() {
        return BigInteger.class;
    }
}

